$().ready(function() {
	$("#loadingDiv").hide();
	$("#labelDiv").hide();
	$("#campoContrato").multiselect();
});

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor) {

	$.ajax({
		url: contextPath + actionRoute,
		type: 'POST',
		data: jsonActionParameter,
		dataType: "json",
		traditional: true,
		success: function(response) {
			functionProcessor(response);
		},
		error: function(jqXhr, textStatus, errorThrown) {
			showError("Fallo en ejecuci&oacute;n.");
		}
	});

}

function procesaDetalleContratos(jsonData) {

	var contratos = jsonData.detalleContratos;
	$('#campoContrato').find('option').remove();
	$("#campoContrato").multiselect('destroy');
	if (contratos.length > 0) {

		$("#campoContrato").prop("disabled", false);
		$("#botonConsultar").prop("disabled", false);

		for (var i = 0; i < contratos.length; i++) {
			cnt = contratos[i];
			$("#campoContrato").append('<option value="' + cnt.idContrato + '">' + cnt.numeroContrato + '</option>');
		}

	} else {
		$("#campoContrato").prop("disabled", true);
		$("#botonConsultar").prop("disabled", true);
		$("#botonExportar").prop("disabled", true);
		$("#botonNotificar").prop("disabled", true);
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: [], colModel: [], data: [], datatype: 'local' }).trigger('reloadGrid');
		showError("El estudio seleccionado no tiene contratos asociados");
	}
	reloadMultiSelect();

}

function reloadMultiSelect() {
	$("#campoContrato").multiselect({
		columns: 1,
		texts: {
			placeholder: 'Seleccione contratos',
			search: 'B&uacute;squeda contratos'
		},
		search: true,
		selectAll: true
	});
}

function llamaObtenerDetalleContratos() {


	var jsonString = '{"idEstudio" : "' + $("#campoEstudio").val() + '", "fechaInicio":"01/01/2021", "fechaFin":"01/01/2022"}';
	var stringJson = JSON.parse(jsonString);
	callActionAjax("/reporte/reportePago/detalleContrato", stringJson, procesaDetalleContratos);

}

var infoReporte = [];

function procesaReportePrincipal(jsonData) {

	var colNamesVar = [
		'contrato',
		'titulo',
		'idBroadview',
		'fechaInicio',
		'fechaFin',
		'costo',
		'anio',
		'meses'
	];
	var colModelVar = [{ name: 'contrato', index: 'contrato', width: 80, align: "left", sortable: false },
	{ name: 'titulo', index: 'titulo', width: 300, align: "left", sortable: false },
	{ name: 'idBroadview', index: 'idBroadview', width: 80, frozen: true, sortable: false },
	{ name: 'fechaInicio', index: 'fechaInicio', width: 150, align: "right", sortable: false },
	{ name: 'fechaFin', index: 'fechaFin', width: 150, align: "right", sortable: false },
	{ name: 'costo', index: 'costo', width: 80, align: "right", sortable: false },
	{ name: 'anio', index: 'anio', width: 40, align: "right", sortable: false },
	{ name: 'meses', index: 'meses', width: 40, align: "right", sortable: false }
	];

	var colModelNames = [
		'contrato',
		'titulo',
		'idBroadview',
		'fechaInicio',
		'fechaFin',
		'costo',
		'anio',
		'meses'];

	var datos = jsonData.reporte;
	var header = jsonData.encabezado;

	var imarcar = 0;
	var porMarcar = [];
	var patron = /^[A-Z]{4}\d{5}[A-Z]$/;

	$("#reporteTableDiv").show();
	if (datos.length > 0) {

		$("#botonExportar").prop("disabled", false);

		$("#botonNotificar").prop("disabled", false);
		jQuery("#reporteTable").jqGrid({
			datatype: "local",
			colNames: colNamesVar,
			colModel: colModelVar,
			width: '1000',
			height: '300',
			rowNum: 999999,
			autowidth: false,
			shrinkToFit: false,
			multiselect: false,
			loadComplete: function() {

			}
		});

		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: colNamesVar, colModel: colModelVar, data: datos, datatype: 'local' }).trigger('reloadGrid');

		for (var i = 0; i < colModelNames.length; i++) {
			jQuery("#reporteTable").jqGrid('setLabel', colModelNames[i], header[i]);
		}

		jQuery("#reporteTable").jqGrid('setRowData', 1, false, 'totalContratoRowClass');

		for (var i = 0; i < porMarcar.length; i++) {
			jQuery("#reporteTable").jqGrid('setRowData', porMarcar[i], false, 'contratoRowClass');
		}

		jQuery("#reporteTable").jqGrid('setFrozenColumns');

		infoReporte = datos;

	} else {
		showError("El contrato seleccionado no tiene titulos asociados.");
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', { colNames: colNamesVar, colModel: colModelVar, data: datos, datatype: 'local' }).trigger('reloadGrid');
		$("#botonExportar").prop("disabled", true);
		$("#botonNotificar").prop("disabled", true);
		$("#labelDiv").hide();
	}
	$("#loadingDiv").hide();

}

function colocaFechaFin() {

	var fechaInicio = new Date($("#campoFechaInicio").val());

	var cdia = '';
	var cmes = '';

	if (fechaInicio != null) {
		cmes = fechaInicio.getMonth() < 10 ? '0' : '';
		cdia = fechaInicio.getDate() < 10 ? '0' : '';
	}

	$("#campoFechaFin").val(cmes + (fechaInicio.getMonth() + 1) + '/' + cdia + fechaInicio.getDate() + '/' + (fechaInicio.getFullYear() + 1));
}

function llamaReporteInfoAction() { //Funcion de boton Consultar
	$("#loadingDiv").show();
	textoLabel();
	$("#labelDiv").show();
	$("#reporteTableDiv").hide();
	const selectedOptions = [];
	const options = $("#campoContrato").val();
	for (let i = 0; i < options.length; i++) {
		selectedOptions.push(options[i]);
	}
	const jsonObject = {
		idCon: selectedOptions,
		fechaInicio: "01/01/2021",
		fechaFin: "01/01/2022",
		idEstudio: $("#campoEstudio").val()
	};
	const jsonString = JSON.stringify(jsonObject);
	
	callActionAjax("/admin/reporteContingencia/reporteContInf", jsonObject, procesaReportePrincipal);
}

function descargarReporteEnExcel() {
	var url = contextPath + '/admin/reporteContingencia/reporteContingenciaExcel.action?idCon=' + $("#campoContrato").val() + '&idEstudio=' + $("#campoEstudio").val() + '&fechaInicio=01/01/2000';
	window.open(url);
}

function textoLabel() {
	const str2 = $("#campoContrato option:selected").text();
	if (str2.endsWith('A')) {
		$("#tipoContrato").text("Contrato Addendum");
	} else {
		if (str2.endsWith('O')) {
			$("#tipoContrato").text("Contrato Original");
		} else {
			if (str2.endsWith('V')) {
				$("#tipoContrato").text("Contrato Virtual");
			} else {
				$("#tipoContrato").text("Contrato Enmienda");
			}
		}
	}

}

function validarVacio() {
	const adenmOrig = [];
	const enmiendas = [];
	$("#campoContrato option:selected").each(function() {
		var $this = $(this);
		if ($this.length) {
			var str2 = $this.text();
			adenmOrig.push($this.val());
		}
	});
	if (adenmOrig.length === 0) {
		$("#botonNotificar").prop("disabled", true);
	} else {
		$("#botonNotificar").prop("disabled", false);
	}
}

function notificarSAP() {
	const adenmOrig = [];
	const enmiendas = [];
	$("#campoContrato option:selected").each(function() {
		var $this = $(this);
		if ($this.length) {
			var str2 = $this.text();
			if (str2.endsWith('A') || str2.endsWith('O') || str2.endsWith('V')) {
				adenmOrig.push($this.val());
			} else {
				enmiendas.push($this.val());
			}
		}
	});
	if (adenmOrig.length > 0) {
		$.ajax({
			url: '/DDA_CRN_Exhibicion/servicio',
			type: 'GET',
			dataType: "json",
			data: { lista: JSON.stringify(adenmOrig) },
			success: function(response) {
				showMessage("Se ha ejecutado el proceso de Notificaci&oacute;n SAP");
			},
			error: function(jqXhr, textStatus, errorThrown) {
				showError("Fallo en ejecuci&oacute;n de Notificaci&oacute;n SAP.");
			}
		});
	}
	if (enmiendas.length > 0) {
		$.ajax({
			url: '/DDA_CRN_ClienteSAP/servicioEnmienda',
			type: 'GET',
			dataType: "json",
			data: { lista: JSON.stringify(enmiendas) },
			success: function(response) {
				showMessage("Se ha ejecutado el proceso de Notificaci&oacute;n SAP");
			},
			error: function(jqXhr, textStatus, errorThrown) {
				showError("Fallo en ejecuci&oacute;n de Notificaci&oacute;n SAP.");
			}
		});
	}

}

