// Archivo que contiene los metodos para la funcionalidad de fees suscriptor  
function pintarDatosSuscriptor(data, tipoSuscriptor){	    
		var idPeriodo = data.idContratoPago;		
		var divPrincipal = $("<div/>").attr('id',"Contenedor"+idPeriodo).addClass("contenedor col-xs-12");		
		divPrincipal.append("<div><label class='mensajePer' style='color:red;'></label></div><br>");
		divPrincipal.append(crearDivPeriodo(idPeriodo, tipoSuscriptor, null , "s"));		
		divPrincipal.append(crearTablaSuscriptores(idPeriodo, data));										
		$("#divSuscriptores").append(divPrincipal);				
		if(idPeriodo <= 0)
		   $("#divSuscriptores").find("div.contenedor:last").before(divPrincipal);
}

function crearDivPeriodo(idPeriodo, tipoSuscriptor, anioTipo, tipoFee){	    
	var divPeriodo   = $("<div/>").attr('id',"divPeriodo"+idPeriodo).addClass("row periodo").attr("divPer",idPeriodo);				
	
	divPeriodo.append(crearDivHtml("<a class='control-label'>A\u00F1o Contrato</a>","1"));
	divPeriodo.append(crearDivHtml("<input id='anioContrato" + idPeriodo + tipoFee +"' type='text' class='form-control'/>","1"));
	divPeriodo.append(crearDivHtml("<a class='control-label'>Periodo </a>","1"));
	divPeriodo.append(crearDivHtml("<input id='fechaInicio" + idPeriodo + tipoFee +"' type='text' class='datepicker form-control'/>","2"));					
	divPeriodo.append(crearDivHtml("<input id='fechaFin" + idPeriodo + tipoFee +"' type='text' class='datepicker form-control'/>"   ,"2"));
								
	if(anioTipo != null)
	{
		var selectSusc = $("<select/>").attr("id", "tiempoVida").addClass("form-control");	
		selectSusc.append('<option value="0">Selecciona</option>');
		for (var i=0; i< anioTipo.length; i++) 	       	   				       	          				       	       
			 selectSusc.append('<option value="'+ anioTipo[i].value +'">'+ anioTipo[i].desc +'</option>');			   
		divPeriodo.append(crearDivHtml("<label class='control-label'>A\u00F1o: </label>","1"));
		divPeriodo.append(crearDivHtml(selectSusc,"3"));
	}
	
	if(tipoSuscriptor != null)
	{
		var selectSusc = $("<select/>").attr("id", "tipoSuscriptor").addClass("form-control");	
		selectSusc.append('<option value="0">Selecciona</option>');
		for (var i=0; i< tipoSuscriptor.length; i++) 	       	   				       	           				       	      
	         selectSusc.append('<option value="'+ tipoSuscriptor[i].idTipoSuscriptor +'">'+ tipoSuscriptor[i].descripcion +'</option>');			
		divPeriodo.append(crearDivHtml("<label class='control-label'>Tipo Suscriptor: </label>","1"));
		divPeriodo.append(crearDivHtml(selectSusc,"3"));									
	}		
	
	if(edoCto == 1)
	{
		var botonPer = $("<span onclick='eliminarPeriodo("+idPeriodo+")'/>").attr("data-toggle", "tooltip").attr("title","Eliminar Periodo").addClass("ui-icon  ui-icon-circle-close");
		divPeriodo.append(crearDivHtml(botonPer,"1"));
	}
			
	return divPeriodo;
}

function agregarColumnaSuscriptor(idTabla){	 
	nuevaColumna--;
	var thEncabezado = $("#tabla" + idTabla + " thead tr th:last");
	var columnas = parseInt(thEncabezado.attr("colspan"));
	thEncabezado.attr("colspan",  columnas + 2 );
					
	$("#tabla"+ idTabla +" tr[id=rangosDesc] th:last").before("<th>Desde</th><th>Hasta</th>");
	$("#tabla"+ idTabla +" tr[id=rangos]     th:last").before("<th idrango='"+nuevaColumna+"' width='80'><input type='text'/></th><th width='80'><input type='text'/></th>");					 
			
	$("#tabla" + idTabla + " tbody tr.categoria").each(function(){
		if($(this).attr("id") != "rangosDesc" || $(this).attr("id") != "rangos")			
		   $(this).find("td:last").after(createTdThTabla(2, "", true, null, 1));				
	});
	$("#tabla" + idTabla + " tr.eliminarCol td:last").before("<th colspan='2' width='80' id='"+nuevaColumna+"'><label class='mensaje'/><label><span data-toggle='tooltip' title='Eliminar Rango'  onclick='eliminarRango("+ idTabla +"," + nuevaColumna +","+ ((columnas + 1)/2 )+")'  class='ui-icon ui-icon-close'></span></label></th>");
	bindingInputValoresRangos();
	bindingInputValores();
}

function agregarNuevoSuscriptor(tipoSuscriptorLista, tipo, inflacion, anioContrato, idPeriodo){		
	var rangos = []; 									

	if($("#divSuscriptores div.contenedor").length == 0 || tipo == "VACIO")
		inicializarVacioSuscriptor(tipoSuscriptorLista);
	else
	{
		var rangosTh = $("#" + idPeriodo + " table tr[id=rangos] input[type='text']");		
			
		for(var i=0; i< rangosTh.length; i++ )
		{					
				var rango     = { "desde": "", "hasta": "", "idRango": 0, "monto": "" };
				rango.desde   = rangosTh[i].value;						
				rango.hasta   = rangosTh[++i].value;
				rangos.push(rango);
		}
			
		var categorias = [];
		$("#" + idPeriodo + " table tr.categoria").each(function(){		
				var ranCat = [];
				for(var i=0; i < rangos.length; i++)
					ranCat[i] = { "desde": rangos[i].desde, "hasta": rangos[i].hasta, "idRango": 0, "monto": "" };;
				
				var categoria = { "descCategoria": "", "idCategoria": "", "rangos": null };
				var inputs       = $(this).find("td input[type='text']");																		
				
				categoria.descCategoria = inputs[0].value;			
				categoria.idCategoria   = $(this).attr("id");
													
				for(var i=1; i< inputs.length; i++ )
				{			
					var infla = inflacion == true ? $("#inflacion").val() : ""; 
					if(infla == "")
						ranCat[i-1].monto   = inputs[i].value;
					else 					
					    ranCat[i-1].monto   = formatCurrency(Number(unformatCurrency( calculaValorInflacion(unformatCurrency(inputs[i].value), infla) )), 2);  
				}																				
				categoria.rangos = ranCat;				
				categorias.push(categoria);
		});
										
		var json = { "datos": [{ "categorias"    : categorias,			              			              		
				              "fechaFin"      : "",
				              "fechaInicio"   : "",
				              "idContrato"    : 0,
				              "idContratoPago": 0,
				              "idSuscriptor"  : $("#divSuscriptores div.contenedor:first select").val(),
				              "maxAnios"      : 6,
				              "maxRangos"     : rangos.length,
				              "operacion"     : "nuevo",
				              "tipoAnio"      : "",
				              "tipoPago"      : "",
				              "anioContrato"  : anioContrato
				            }]
		           };								    
		json.datos[0].idContratoPago = nuevoPeriodo;
		crearSuscriptor(json.datos[0], tipoSuscriptorLista);		
	}
}

function inicializarVacioSuscriptor(tipoSuscriptorLista){
   var categorias = [];
   var rangos     = [ { "desde": "", "hasta": "", "idRango": 0, "monto": "" }];
      
   if($("#divSuscriptores div.contenedor").length > 0)
   {
	   $("#divSuscriptores div.contenedor:first tr.categoria").each(function(){												
			var categoria = { "descCategoria": $(this).find("td:first input[type='text']").val(), "idCategoria":  $(this).attr("id") == null ?0 :$(this).attr("id"), "rangos": rangos };		
		    categorias.push(categoria);   
	   });
   }
   else
	   categorias = [{ "idCategoria":0, "descPeriodo": "", "idPeriodo": "", "rangos": [ { "desde": "", "hasta": "", "idRango": 0, "monto": "" } ] }];
	   
   var json = { "datos": [{
		              "categorias": categorias,
		              "descSuscriptor": "", "fechaFin"      : "", "fechaInicio" : "",
		              "idContrato"    : 0 , "idContratoPago": 0 , "idSuscriptor": 0,
		              "maxAnios": 6 , "maxRangos": 1, "operacion": "nuevo",
		              "tipoAnio": "", "tipoPago" : "",
		              "anioContrato"  : $("#anioContrato").val() == "" ? "" : parseInt($("#anioContrato").val())
		        }]
		      };	   
	json.datos[0].idContratoPago = nuevoPeriodo;	
	crearSuscriptor(json.datos[0], tipoSuscriptorLista);
}

function mostrarDivSuscriptor(){
	$("#optradioFlat").attr('checked', false);
	$("#optradioNA").attr('checked', false);
	$("#optradioCostoTotal").attr('checked', false);
	tipoSuscriptor = "s";
	$("#divSuscriptores").show();
	$("#divFlat").hide();	
    $("#divBotones").show();    
    $("#tiempoVida").hide();
    mostrarComunDiv();
}

function obtenerSuscriptores(){	
	var periodos   = [];
	var validacion = true;
	validacionForma = true;
	if($("#divSuscriptores div.contenedor").length > 0)
	{
		$("#divSuscriptores div.contenedor").each(function(){	    
			var periodo = obtenerSuscriptor($(this));		
			validacion  = validarSuscriptor($(this), periodo);
			if(validacionForma)
				validacionForma = validacion;
			periodos.push(periodo);																											  
		});						
		validacionFeesInflacionYFechas(periodos);
	}
	return periodos;
}

function obtenerSuscriptor(contenedor){				   
	//Se obtienen rangos suscriptor
	var rangos = []; 																													
	var rangosInput = contenedor.find("table tr[id=rangos] th input[type='text']");
	var rangosTh    = contenedor.find("table tr[id=rangos] th");
	var j = 1;
	
	for(var i=0; i< rangosInput.length; i++ )
	{				
		var rango     = { "desde": "", "hasta": "", "idRango": "", "monto": "" };
		rango.desde   = rangosInput[i].value;		
		rango.idRango = rangosTh[j].attributes.idrango.value;
		j += 2;
		rango.hasta   = rangosInput[++i].value;
		rangos.push(rango);
	}
		
	//Se obtienen las categorias
	var categorias = [];
	contenedor.find("table tr.categoria").each(function(){		
		var rangostr = [];
		for(var i=0; i< rangos.length; i++)
			rangostr[i] = { "desde": unformatCurrency(rangos[i].desde), "hasta": unformatCurrency(rangos[i].hasta), "idRango": rangos[i].idRango, "monto": "" };	
		
		var categoria = { "descCategoria": "", "idCategoria": "", "rangos": null };
		var inputs       = $(this).find("td input[type='text']");																		
		
		categoria.descCategoria = encodeURIComponent(inputs[0].value);			
		categoria.idCategoria   = $(this).attr("id");
											
		for(var i=1; i< inputs.length; i++ ){
			rangostr[i-1].monto   = inputs[i].value == "0" ? inputs[i].value : unformatCurrency(inputs[i].value);				
		}																	
		categoria.rangos = rangostr;							
		categorias.push(categoria);
	});	
		
	//Se crea el objeto completo del periodo	
	var periodo = { "categorias"    : categorias,  
					"fechaFin"      : contenedor.find("div.periodo #fechaFin"    + contenedor.find("div.periodo").attr("divPer") + "s").val(), 
				    "fechaInicio"   : contenedor.find("div.periodo #fechaInicio" + contenedor.find("div.periodo").attr("divPer") + "s").val(),
			        "idSuscriptor"  : contenedor.find("div.periodo #tipoSuscriptor").val(),							        
                    "idContratoPago": contenedor.find("div.periodo").attr("divper"), 
                    "operacion"     : tipoOperacion,
                    "tipoPago"      : "ESCALA",
                    "anioContrato"  : parseInt(contenedor.find("div.periodo #anioContrato" + contenedor.find("div.periodo").attr("divPer") + "s").val())
                  };		
	
	return periodo;
}

function validarSuscriptor(contenedor, periodo){
	var validacion = true;
	
	if(periodo.categorias.length != 0)
	{
		//Se valida que rangos sea correcto
		var resultado = validaRangosSuscritor(periodo.categorias[0].rangos);
		validacion    = resultado.validacion;
		
		if(!resultado.validacion)				
			$("#tabla"+ periodo.idContratoPago+" tr[id=rangos] label.mensaje").text(resultado.mensaje).show();				
		else
			$("#tabla"+ periodo.idContratoPago+" label.mensaje").hide();
		
		if(validacion)
		{
			var resultado = validarCategoriasFees(periodo.categorias);		
			if(validacion)
				validacion = resultado.validacion;
			if(!resultado.validacion)		
				$("label.mensajePer").text(resultado.mensaje).show();									
			else
				$("label.mensajePer").hide();
		}
				
		if(validacion)
		{		
			for(var i=0; i < periodo.categorias.length; i++)
			{
				var resultadoCat = validaCategoriaSuscriptor(periodo.categorias[i]);					
				
				if(validacion)
				   validacion = resultadoCat.validacion;
				
				if(!resultadoCat.validacion)				
					$("#tabla"+ periodo.idContratoPago + " tr[id='"+periodo.categorias[i].idCategoria+"']").find("label.mensaje").text(resultadoCat.mensaje).show();							
				else
					$("#tabla"+ periodo.idContratoPago + " tr[id='"+periodo.categorias[i].idCategoria+"']").find("label.mensaje").hide();	
			}					
		}
			
		if(validacion)
		{					
			var resultadoPer = validaPeriodoSuscriptor(periodo);
			validacion = resultadoPer.validacion;
			if(!resultadoPer.validacion)			
				$("#Contenedor"+ periodo.idContratoPago + " label.mensajePer").text(resultadoPer.mensaje).show();					
			else
				$("#Contenedor"+ periodo.idContratoPago + " label.mensajePer").hide();
		}
		
		if(!validacion)
			showError("Revisar los datos.");
	}
	else
	{
		validacion = false;
		showError("No existen categorias");
	}		
	return validacion;
}

function crearSuscriptor(suscriptor, listaSuscriptor){
	pintarDatosSuscriptor(suscriptor, listaSuscriptor);	   
	llenarDatosSuscriptor(suscriptor);
	
	//despues de pintar los nuevos valores se hacen los bindings
    bindingInputCategoria();  
    bindingInputValores();
    bindingInputValoresRangos();
}

function crearTablaSuscriptores(idPeriodo, data){	
	var tabla  = tablaDinam.crearTabla("tabla" + idPeriodo, "tSuscriptores");    		
	var rangos = data.categorias[0].rangos;
	
	var encabezados = [];
	encabezados.push({id:null, clase : '', colspan:2,                      texto:'Categor\u00EDas'       ,  html:''});
	encabezados.push({id:null, clase : '', colspan:((data.maxRangos*2)+1), texto:'Escala de Suscriptores',  html:''});	
	tablaDinam.agregarFilaEncabezado(tabla, encabezados, 'encabezado');	
	
	var rangosTh    = [];
	var rangosDesTh = [];		
	rangosTh   .push($("<th colspan='2' width='160' style='background:#CB2C25'/>"));
	rangosDesTh.push($("<th colspan='2' width='160' style='background:#CB2C25'/>"));
	
	var eliminarAnios = [];	
	    	
	for(var i=0; i< data.maxRangos; i++)
	{		
		rangosDesTh.push($("<th/>").text("Desde"));
		rangosDesTh.push($("<th/>").text("Hasta"));									
		rangosTh.push( createTdThTabla(1, rangos[i].desde == null ? "" : formatCurrency(Number(unformatCurrency(rangos[i].desde)), 0) , true, null, 0).attr("idRango", rangos[i].idRango));													
		rangosTh.push( createTdThTabla(1, rangos[i].hasta == null ? "" : formatCurrency(Number(unformatCurrency(rangos[i].hasta)), 0) , true, null, 0));		
		if( i > 0 )
		    eliminarAnios.push("<th colspan='2' width='160' id='"+rangos[i].idRango+"'><label><span data-toggle='tooltip' title='Eliminar Rango' class='ui-icon ui-icon-close' onclick='eliminarRango("+idPeriodo+","+ rangos[i].idRango +","+ (i+1)+")'></span></label></th>");		
	}		
	
	var thStr  = "<th/>";
	var thStr1 = "<th/>";
	if(edoCto == 1)
	{
		thStr = "<th><label style='display=none;' class='mensaje'/>"+
				    "<label><span data-toggle='tooltip' title='Agregar Categor\u00EDa' class='ui-icon ui-icon-plus' onclick='agregarCategoriaSuscriptor("+idPeriodo+")'></span></label>" +				              
  		        "</th>";		
		thStr1= "<th><label style='display=none;' class='mensaje'/>"+"<label><span data-toggle='tooltip' title='Agregar Rango'     class='ui-icon ui-icon-grip-solid-vertical' onclick='agregarColumnaSuscriptor("+idPeriodo+")'></span></label>" +"</th>";
	}	
	rangosDesTh.push(thStr);		
	rangosTh.push(thStr1);
	
	tabla = tablaDinam.agregarFilaThTd(tabla, "rangosDesc", rangosDesTh);
	tabla = tablaDinam.agregarFilaThTd(tabla, "rangos", rangosTh);
	
	var fila = tablaDinam.crearFilaEliminarCol("eliminarCol", data.maxRangos, 2, eliminarAnios);
	fila.find("td:first").attr("colspan","2");
	fila.find("td:nth-child(2)").attr("colspan","2");
	
	tabla.append(fila);
	if(edoCto != 1){
		tabla.find("tr.eliminarCol").hide();	
	}
		
	return tablaDinam.envolverTabla("divTabla" + idPeriodo, tabla);
}	

function llenarDatosSuscriptor(data){	   	
    for(var i=0; i < data.categorias.length; i++)
    	agregarFilaTablaSuscriptor(data.idContratoPago, data.categorias[i].idCategoria, data.categorias[i].descCategoria, data.categorias[i].rangos);
    
    if(data.idSuscriptor != null && data.fechaInicio != null && data.fechaFin != null)
    {   
    	$("#divSuscriptores > #Contenedor" + data.idContratoPago +"> #divPeriodo" + data.idContratoPago +" input[id=fechaInicio" + data.idContratoPago +"s]").val(data.fechaInicio);
    	$("#divSuscriptores > #Contenedor" + data.idContratoPago +"> #divPeriodo" + data.idContratoPago +" input[id=fechaFin" + data.idContratoPago +"s]").val(data.fechaFin);
    	$("#divSuscriptores > #Contenedor" + data.idContratoPago +"> #divPeriodo" + data.idContratoPago +" select[id=tipoSuscriptor]").val(data.idSuscriptor);
    	$("#divSuscriptores > #Contenedor" + data.idContratoPago +"> #divPeriodo" + data.idContratoPago +" input[id=anioContrato" + data.idContratoPago +"s]").val(data.anioContrato);
    }    
}

function agregarFilaTablaSuscriptor(idPeriodo, idCategoria, descCategoria, rangos){	    	
	var atributos = [];
	var datos     = [];
	
	atributos.push(["id", idCategoria]);		
	datos.push(createTdThTabla(2, descCategoria == null ? "" : descCategoria, true, null, 1));
			
	for(var i=0; i< rangos.length; i++)		
		datos.push(createTdThTabla(2, rangos[i].monto == null ? "" : formatCurrency(Number(unformatCurrency(rangos[i].monto)), 2) , true, null, 1));	
	
	var str = "<th></th>";	
	if(edoCto == 1)
		str = "<th><label class='mensaje' style='display=none;'/><label><span data-toggle='tooltip' title='Eliminar'  onclick='eliminarFila("+idPeriodo+","+ idCategoria+",0)'  class='ui-icon ui-icon-close'></span></label></th>";			
	datos.push(str);
	
	var fila = tablaDinam.crearFila("categoria", datos, atributos);
	$("#divSuscriptores #tabla" + idPeriodo +" tr.eliminarCol").before(fila);		
}	

function agregarCategoriaSuscriptor(idPeriodo){	
	$("#divSuscriptores table.tSuscriptores").each(function(){
		var atributos = [];
		atributos.push(["id", nuevoCategoria]);				
		
		numRangos = ($(this).find("tr[id='rangos']").find("th").length-2)/2;
		
		var fila      = crearFilaVacia("categoria", numRangos+1, atributos, 2);
		
		if(edoCto == 1)
			fila.append("<th><label class='mensaje' style='display=none;'/><label><span data-toggle='tooltip' title='Eliminar'  onclick='eliminarFila("+idPeriodo+","+ nuevoCategoria+",0)'  class='ui-icon ui-icon-close'></span></label></th>");
		else
			fila.append("<th></th>");		
		$("#"+$(this).attr("id") + " tr.eliminarCol").before(fila); //Se agrega la nueva fila a cada tabla
	});
	bindingInputCategoria();	
	bindingInputValores();    
	nuevoCategoria--;
}

function agregarCategoriaSuscriptorDirecto(idPeriodo, categoria){	
	$("#divSuscriptores table.tSuscriptores").each(function(){		
		var id = $(this).attr("id").substring(5, $(this).attr("id").length);
		
		if(parseInt(id) != parseInt(idPeriodo))
		{					
			var atributos = [];
			atributos.push(["id", nuevoCategoria]);				
			
			numRangos = ($(this).find("tr[id='rangos']").find("th").length-2)/2;
			
			var fila      = crearFilaVacia("categoria", numRangos+1, atributos, 2);
			fila.find("input[type='text']:first").val(categoria);
			
			if(edoCto == 1)
				fila.append("<th><label class='mensaje' style='display=none;'/><label><span data-toggle='tooltip' title='Eliminar'  onclick='eliminarFila("+idPeriodo+","+ nuevoCategoria+",0)'  class='ui-icon ui-icon-close'></span></label></th>");
			else
				fila.append("<th></th>");		
			$("#"+$(this).attr("id") + " tr.eliminarCol").before(fila); //Se agrega la nueva fila a cada tabla
		}		
	});
	bindingInputCategoria();	
	bindingInputValores();    
	nuevoCategoria--;
}

function bindingInputCategoria(){
	$("#divSuscriptores table.tSuscriptores tr.categoria").each(function() {    	
    	var idCat = $(this).attr("id");
    	$(this).find("td:first input").change(function() {
			var valor = $(this).val();
			$("#divSuscriptores table.tSuscriptores").each(function(){
				 $(this).find("tr[id="+idCat+"] td:first input").val(valor);		
			});
    	});
	});
}

function bindingInputValores(){	
	$("table tr.categoria").each(function(){
		var valido = false;
		var cate = $(this);
    	$(this).find("input").each(function(){    		    	
    		if(valido)
    			$(this).change(function() {      				
    				var valor = $(this).val() == "0" ? $(this).val() : unformatCurrency($(this).val());    				
    				if(!validaNumero(valor))
    				   showError("El valor ingresado no es un n\u00FAmero."); 
    				else
    					$(this).val( formatCurrency(Number(unformatCurrency(valor)), 2) );
    			});
    		valido = true;
    	});
	});
}

function bindingInputValoresRangos(){	
	$("table tr[id='rangos']").each(function(){
		var valido = false;
		var cate = $(this);
    	$(this).find("input").each(function(){    		    	    		
    		$(this).change(function() {  
    			var valor = unformatCurrency($(this).val());    				
    			if(!validaNumero(valor))
    			   showError("El valor ingresado no es un n\u00FAmero."); 
    			else
    				$(this).val( formatCurrency(Number(unformatCurrency(valor)), 0) );
    		});    		
    	});
	});
}

function eliminarRango(idPeriodo, idRango, columna){
	var thEncabezado = $("#tabla" + idPeriodo + " thead tr th:last");
	var columnas = parseInt(thEncabezado.attr("colspan"));
	thEncabezado.attr("colspan",  columnas - 2 );
	
	columna = 1;
	var encontrado =  false;
	$("#tabla"+ idPeriodo + " tbody tr.eliminarCol").find("th").each(function(){
		
		if(!encontrado){
			columna++;						
		}
		if($(this).attr("id") == idRango)
			encontrado = true;														        	
	});
		
	$("#tabla"+ idPeriodo + " tr[id='rangosDesc']") .find("th:nth-child("+(columna*2)+")").remove();
	$("#tabla"+ idPeriodo + " tr[id='rangosDesc']") .find("th:nth-child("+(columna*2)+")").remove();
	$("#tabla"+ idPeriodo + " tr[id='rangos']")     .find("th:nth-child("+(columna*2)+")").remove();
	$("#tabla"+ idPeriodo + " tr[id='rangos']")     .find("th:nth-child("+(columna*2)+")").remove();
	$("#tabla"+ idPeriodo + " tr.eliminarCol")      .find("th:nth-child("+(columna+1)+")").remove();	
		
	$("#tabla"+ idPeriodo + " tbody tr.categoria").each(function(){		
		$(this).find("td:nth-child("+(columna+1)+")").remove();				        		
	});			
}

function verificarAniosContratosSuscriptor(valor){
	var valido = true;
	$("div.periodo").each(function(){		
		var actual = $(this).find("div:nth-child(2)").find("input").val(); 
		if(valor == actual)
			valido = false;																	        
	});
	return valido;
}