package com.mx.dla.dda.admin.catalogos.transacciones.bos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.executor.result.ResultMapException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

import com.mx.dla.dda.admin.catalogos.transacciones.daos.TransaccionesDAO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.CategoriasDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ConfiguracionesDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.EstudiosTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ExcepcionesTransDTO;
import com.mx.dla.dda.admin.catalogos.transacciones.dtos.ReporteGeneralDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.bos.BaseBO;

@Service
public class TransaccionesBO extends BaseBO {

	@Autowired
	TransaccionesDAO transacciones;

	@Autowired
	private ExcelMapperContext excelMapperContext;

	@Autowired
	protected ExcelMapperTransform excelMapperTransform;

	public List<ExcepcionesTransDTO> getExcepciones() throws ResultMapException, SQLException, TransaccionException {
		try {
			return transacciones.getExcepciones();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public List<CategoriasDTO> getCategorias() throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.getCategorias();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public List<EstudiosTransDTO> getEstudiosTrans() throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.getEstudiosTrans();
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void agregarExcepcion(ExcepcionesTransDTO excepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.agregarExcepcion(excepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void agregarCategoria(CategoriasDTO categoria)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.agregarCategoria(categoria);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void agregarEstudioTrans(EstudiosTransDTO estudio)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.agregarEstudioTrans(estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void eliminarEstudio(EstudiosTransDTO estudio)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.eliminarEstudio(estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public void eliminarCategoria(CategoriasDTO categoria)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.eliminarCategoria(categoria);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public void eliminarExcepcion(ExcepcionesTransDTO excepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.eliminarExcepcion(excepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public CategoriasDTO getCategoriaById(String idCategoria)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.getCategoriaById(idCategoria);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void updateCategoria(CategoriasDTO categoria) throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.updateCategoria(categoria);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public EstudiosTransDTO getEstudioTransById(String idEstudio)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.getEstudioTransById(idEstudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void updateEstudioTrans(EstudiosTransDTO estudio)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.eliminarEstudioByName(estudio);
			transacciones.agregarEstudioTrans(estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public ExcepcionesTransDTO getExcepcionesById(String idExcepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.getExcepcionesById(idExcepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void updateExcepcion(ExcepcionesTransDTO excepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.updateExcepcion(excepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public List<ReporteGeneralDTO> reporteGeneral(String anio, String mes, String estudio)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.reporteGeneral(anio, mes, estudio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public InputStream obtenerReporteEnExcel(String anio, String mes, String estudio)
			throws ResultMapException, SQLException, TransaccionException {

		byte[] info = null;
		InputStream reporteGeneral = null;
		List<ReporteGeneralDTO> reporte = null;

		try {

			logger.debug("antes de reporte");
			reporte = transacciones.reporteGeneral(anio, mes, estudio);
			logger.debug("Regresando reporte");
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

		ExcelMapper mapper = excelMapperContext.getExcelMapper("reporteTransaccionesGeneral");

		try {

			info = excelMapperTransform.transformObjectToExcel(reporte, mapper, ReporteGeneralDTO.class);
			reporteGeneral = new ByteArrayInputStream(info);
		} catch (ExcelMapperException e) {
			logger.error("Error : " + e);
		} catch (IOException e) {
			logger.error("Error : " + e);
		}
		return reporteGeneral;
	}

	public ExcepcionesTransDTO validaExcepcionExistente(ExcepcionesTransDTO excepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.validaExcepcionExistente(excepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}

	}

	public ConfiguracionesDTO validaMescerrado(ExcepcionesTransDTO excepcion)
			throws ResultMapException, SQLException, TransaccionException {

		try {
			return transacciones.validaMesCerrado(excepcion);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void cerrarRporte(String fecha) throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.cerrarReporte(fecha, "FECHA_CIERRE_TRANS");
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

	public void reabrirReporte(String mes, String anio) throws ResultMapException, SQLException, TransaccionException {

		try {
			transacciones.reabrirReporte(mes, anio);
		} catch (PersistenceException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		} catch (DataAccessException e) {
			throw new TransaccionException("Error al cargar los datos de actualizacion " + e);
		}
	}

}
