package com.mx.dla.dda.carga.suscriptor.dtos;

import java.io.Serializable;

/**
 * Representa la respuesta que sera enviada al Front-End por parte de este componente al ejecutar el proceso de Calculo de Costo de Suscriptores
 * Incluye un mensaje y resultado de la transaccion.
 *
 */
public class ResponseCalculoCostoSuscriptoresDTO implements Serializable 
{
	private static final long serialVersionUID = 1L;
	private String mensaje;
	private boolean resultado;
	
	public String getMensaje() {
		return this.mensaje;
	}
	public void setMensaje(String mensaje) {
		this.mensaje = mensaje;
	}
	public boolean getResultado() {
		return resultado;
	}
	public void setResultado(boolean resultado) {
		this.resultado = resultado;
	}
	
	public String toString() 
	{
		StringBuilder result = new StringBuilder();
		String NEW_LINE = System.getProperty("line.separator");
		result.append(" [Begin of Class] " + NEW_LINE);
		result.append(this.getClass().getSimpleName() + " Object {" + NEW_LINE);
		result.append(" mensaje: _" + this.getMensaje() + "_" + NEW_LINE);
		result.append(" resultado: _" + this.getResultado() + "_" + NEW_LINE);
		result.append(" [End of Class] " + NEW_LINE);
		result.append("}");
		NEW_LINE = null;

		return result.toString();
	}
	
}
