package com.mx.dla.dda.reporte.pago.actions;

import java.io.InputStream;

import org.springframework.beans.factory.annotation.Autowired;

import com.mx.dla.dda.admin.catalogos.addons.bos.ReporteAddOnsBO;
import com.mx.dla.dda.contrato.common.actions.BaseContratoAction;

import lombok.Getter;
import lombok.Setter;

@Getter
@Setter
public class ReporteSuscriptoresExcelAction extends BaseContratoAction {

	private static final long serialVersionUID = 1L;
	private InputStream fileInputStream;
	private String fileName;
	private String idCon;
	private String idEstudio;
	private String fechaInicio;

	@Autowired
	private ReporteAddOnsBO reporteMovimientos;
	
	public String execute() {
		
		fileInputStream = reporteMovimientos.obtenerReporteEnExcel(idEstudio,fechaInicio);
		setFileName(reporteMovimientos.obtenerNombreEstudio(idEstudio)+"_"+fechaInicio.replace("/",""));
		return SUCCESS;
	}


}
