var uploader   = new UploaderEX("cargaFeesDiv"); // Se crear el objeto para
var datosSubir = null;						     // cargar archivos

var rentaPremierController = function($scope, $filter, $q, rentaPremierService, tablaService, feesValidateService) {

	$scope.tablaMinGar    = null;
	$scope.tablaMinAnio   = null;
	$scope.tablaRelease   = null;
	$scope.tablaImpuestos = null;
	$scope.tablaPrecios   = null;
	$scope.tablaRevenue   = null;
	$scope.tipoMin        = null;
	$scope.formatos       = null;
	$scope.idsCat         = null;
	$scope.idCatEli       = [];
	$scope.idsRel         = [0];
	$scope.idsRelEli      = [];	       
		
	rentaPremierService.inicializarTablas().then(function(data) {
		$scope.inicializar(data);						
	});
		
	$scope.inicializar = function(data) {
		
		if (data.datosMin != null && data.datosMinAnio == null) 
		{
			$scope.tablaMinGar = rentaPremierService.crearTablaMinimosGaranzatidosCateg(data.datosMin, null,data);

			var dataTem = [];
			var filaTem = [];
			for (var i = 0; i < data.aniosMin.length; i++)
				filaTem.push(null);
			dataTem.push(filaTem);

			$scope.tablaMinAnio = rentaPremierService.crearTablaMinimosGaranzatidosAnio(dataTem, null, data);
			$scope.tipoMin      = "categoria";
			$scope.idsCat       = data.idCatMin;
			this.inicializarDivMinimos();
		} 
		else if (data.datosMinAnio != null && data.datosMin == null) 
		{
			$scope.tablaMinAnio = rentaPremierService.crearTablaMinimosGaranzatidosAnio(data.datosMinAnio, null,data);

			var dataTem = [];
			var filaTem = [ null, null, "MFTV/MFV" ];
			for (var i = 0; i < data.aniosMin.length; i++)
				filaTem.push(null);
			dataTem.push(filaTem);
			$scope.tablaMinGar = rentaPremierService.crearTablaMinimosGaranzatidosCateg(dataTem, null, data);
			$scope.tipoMin     = "anio";
			$scope.idsCat      = [ 0 ];
			this.inicializarDivMinimos();
		} 
		else if (data.datosMinAnio != null && data.datosMin != null) 
		{
			$scope.tablaMinAnio = rentaPremierService.crearTablaMinimosGaranzatidosAnio(data.datosMinAnio, null,data);
			$scope.tablaMinGar  = rentaPremierService.crearTablaMinimosGaranzatidosCateg(data.datosMin, null,data);
			$scope.tipoMin      = null;
			$scope.idsCat       = [ 0 ];
			this.inicializarDivMinimos();
		}

		$scope.tablaRelease = rentaPremierService.crearTablaRelease(data.datosReleases, null, null);
		
		if (data.idCatRel == null)
			$scope.idsRel = [ 0 ];
		else
			$scope.idsRel = data.idCatRel;

		$scope.tablaImpuestos = rentaPremierService.crearTablaImpuestos(data.datosImpuestos, data.paises, null);
		$scope.tablaPrecios   = rentaPremierService.crearTablaPrecios(data.datosPrecio, data.paises, null);
		$scope.tablaRevenue   = rentaPremierService.crearTablaRevenue(data.datosRevenue, [], null);
		$scope.formatos       = data.formatos;
					
	};
	
	$scope.inicializarDivMinimos = function() {
		
		if($scope.tipoMin == "categoria")
		{
			$("#divMinCate").show();
			$("#divMinAnio").hide();			
		}
		else if($scope.tipoMin == "anio")
		{
			$("#divMinAnio").show();
			$("#divMinCate").hide();
		}
		else		
		{
			$("#divMinAnio").hide();
			$("#divMinCate").hide();
		}
	};

	$scope.editarTablaMinGarantizados = function(operacion, index, encabezado) {
		var tablaN;
		var numAnio = ($scope.tablaMinGar.datos[0].length - 3) + 1;
		var modificado = false;
		switch (operacion) {
		case 'removeRow':

			rentaPremierService.verificarCategMin($scope.idsCat[index]).then(function(data) {
				
				if(data.fees.valido)
				{
					tablaN = tablaService.removeRow($scope.tablaMinGar.datos, index);

					if ($scope.idsCat[index] != 0)
						$scope.idCatEli.push($scope.idsCat[index]);

					$scope.idsCat.splice(index, 1);
					modificado = true;
				}
				else
					showError("La categor\u00EDa no se puede eliminar.");				
			});
			
			break;
		case 'addRow':
			tablaN = tablaService.addRow($scope.tablaMinGar.datos);
			$scope.idsCat.push(0);
			modificado = true;
			break;
		case 'addColumn':			
			tablaN = tablaService.addColumn($scope.tablaMinGar.datos, $scope.tablaMinGar.encabezados, null, encabezado);
			modificado = true;
			break;
		default:
		}
		
		if(modificado)
		{
			$scope.tablaMinGar.datos = tablaN.datos != null ? tablaN.datos : $scope.tablaMinGar.datos;
			$scope.tablaMinGar.encabezados = tablaN.encabezados != null ? tablaN.encabezados: $scope.tablaMinGar.encabezados;	
		}		
	};

	$scope.editarTablaMinGarantizadosAnio = function(operacion, index, encabezado) {
		var tablaN;
		var numAnio = $scope.tablaMinAnio.datos[0].length + 1;
		switch (operacion) {
		case 'addColumn':
			tablaN = tablaService.addColumn($scope.tablaMinAnio.datos, $scope.tablaMinAnio.encabezados, $scope.tablaMinAnio.columnasEliminar, encabezado);
			modificado = true;
			break;
		case 'removeColumn':
			tablaN = tablaService.removeColumn($scope.tablaMinAnio.datos, $scope.tablaMinAnio.encabezados, $scope.tablaMinAnio.columnasEliminar, index);
			break;
		default:		
		}
		$scope.tablaMinAnio.datos = tablaN.datos != null ? tablaN.datos : $scope.tablaMinAnio.datos;
		$scope.tablaMinAnio.encabezados = tablaN.encabezados != null ? tablaN.encabezados : $scope.tablaMinAnio.encabezados;
	};

	$scope.editarTablaRelease = function(operacion, index) {
		var tablaN;
		switch (operacion) {
		case 'removeRow':
			tablaN = tablaService.removeRow($scope.tablaRelease.datos, index);
			this.editarTablaPrecios("removeRow", index, null, null);
			this.editarTablaRevenue("removeRow", index);
			
			if($scope.idsRel[index] != 0)
				   $scope.idsRelEli.push($scope.idsRel[index]);
			
			$scope.idsRel.splice(index, 1);						
			break;
		case 'addRow':
			tablaN = tablaService.addRow($scope.tablaRelease.datos);
			this.editarTablaPrecios("addRow", null, "", $scope.formatos);
			this.editarTablaRevenue("addRow", null);
			$scope.idsRel.push(0)
			break;
		default:
		}
		$scope.tablaRelease.datos = tablaN.datos != null ? tablaN.datos : $scope.tablaRelease.datos;
		$scope.tablaRelease.columnasEliminar = tablaN.columnasEliminar != null ? tablaN.columnasEliminar : $scope.tablaRelease.columnasEliminar;
		$scope.tablaRelease.encabezados = tablaN.encabezados != null ? tablaN.encabezados : $scope.tablaRelease.encabezados;

	};

	$scope.editarTablaPrecios = function(operacion, index, categoria, formatos) {
		var tablaN;
		var data = $scope.tablaPrecios.datos;

		switch (operacion) {
		case 'removeRow':
			var dataT = {
				datos : [],
				encabezados : null,
				columnasEliminar : null
			}

			for (var i = 0; i < data.length; i++) {
				var fila = [];
				for (var j = 0; j < data[0].length; j++)
					fila.push(data[i][j]);

				if (index != i && (index + 1) != i && (index + 2) != i)
					dataT.datos.push(fila);
			}
			tablaN = dataT;
			break;
		case 'addRow':
			var dataT = {
				datos : null,
				encabezados : null,
				columnasEliminar : null
			}

			if (data.length === 0) {
				var newrow = [];
				newrow = [ {
					'valor' : ''
				} ];
				data.push(newrow);
			} else {
				for (var i = 0; i <= 2; i++) {
					var newrow = [];
					for (var j = 0; j < data[0].length; j++) {
						if (j == 1)
							newrow.push({
								'valor' : formatos[i]
							});
						else if (j > 1)
							newrow.push({
								'valor' : null
							});
						else {
							if (i == 0)
								newrow.push({
									'valor' : categoria
								});
							else
								newrow.push({
									'valor' : ""
								});
						}
					}
					data.push(newrow);
				}
			}
			dataT.datos = data;
			tablaN = dataT;
			break;
		default:
		}
		$scope.tablaPrecios.datos = tablaN.datos != null ? tablaN.datos
				: $scope.tablaPrecios.datos;
		$scope.tablaPrecios.encabezados = tablaN.encabezados != null ? tablaN.encabezados
				: $scope.tablaPrecios.encabezados;
	};

	$scope.editarTablaRevenue = function(operacion, index) {
		var tablaN;
		switch (operacion) 
		{		
			case 'removeRow':
				tablaN = tablaService.removeRow($scope.tablaRevenue.datos, index);
				break;
			case 'addRow':
				tablaN = tablaService.addRow($scope.tablaRevenue.datos);
				break;
			default:
		}
		$scope.tablaRevenue.datos       = tablaN.datos       != null ? tablaN.datos      : $scope.tablaRevenue.datos;
		$scope.tablaRevenue.encabezados = tablaN.encabezados != null ? tablaN.encabezados: $scope.tablaRevenue.encabezados;
	};

	$scope.actualizarMinCelda = function(fila, columna, valor, metadatos) {
		var valClean = $filter('numDigNormal')(valor.srcElement.value);

		if (!isNaN(valClean) && parseFloat(valClean) > 0) {
			if ($scope.tipoMin == "anio") {
				if (valClean == "")
					$scope.tablaMinAnio.datos[fila][columna].valor = null;
				else
					valor.srcElement.value = $filter('numDigMoneda')(valClean,
							2);
			} else {
				if (columna != 2) {
					if (valClean == "")
						$scope.tablaMinGar.datos[fila][columna].valor = null;
					else
						valor.srcElement.value = $filter('numDigMoneda')(
								valClean, 2);
				}
			}
		} else {
			if ($scope.tipoMin != "categoria" && columna != 2)
				valor.srcElement.value = null;
		}
	};

	$scope.actualizarImpCelda = function(fila, columna, valor) {
		if (valor.srcElement.checked)
			$scope.tablaImpuestos.datos[fila][columna].valor = 'true';
		else
			$scope.tablaImpuestos.datos[fila][columna].valor = 'false';
	};

	$scope.actualizarReleaseCelda = function(fila, columna, valor, metadatos) {
		var valClean = $filter('numDigNormal')(valor.srcElement.value);
		if (!isNaN(valClean) && parseFloat(valClean) > 0) {
			if (columna <= 1) {
				if (valClean == "")
					$scope.tablaRelease.datos[fila][columna].valor = null;
				else
					valor.srcElement.value = $filter('numDigMoneda')(valClean,
							0);
			}
		} else {
			if (columna != 2)
				valor.srcElement.value = null;
			else {
				$scope.tablaRevenue.datos[fila][0].valor = valor.srcElement.value;
				if (fila == 0) {
					$scope.tablaPrecios.datos[fila][0].valor = valor.srcElement.value;
				} else {
					$scope.tablaPrecios.datos[fila * 3][0].valor = valor.srcElement.value;
				}
			}
		}
	};

	$scope.actualizarPrecioCelda = function(fila, columna, valor, metadatos) {
		var valClean = $filter('numDigNormal')(valor.srcElement.value);
		if (!isNaN(valClean) && parseFloat(valClean) > 0) 
		{
			if (valClean == "")
				$scope.tablaPrecios.datos[fila][columna].valor = null;
			else if (columna % 2 == 0) 
			{
				$scope.tablaPrecios.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value, 4);
				$scope.tablaPrecios.datos[fila][columna + 1].valor = null;
			}
			else
			{
				$scope.tablaPrecios.datos[fila][columna].valor = $filter('numDigMoneda')(valor.srcElement.value, 4);
				$scope.tablaPrecios.datos[fila][columna - 1].valor = null;
			}
		} 
		else
			valor.srcElement.value = null;
	};

	$scope.actualizarRevenueCelda = function(fila, columna, valor, metadatos) {
		var valClean = $filter('numDigNormal')(valor.srcElement.value.replace("%",""), 2);
		var resto    = null;
		
		if (!isNaN(valClean) && parseFloat(valClean) > 0) 
		{
			if (valClean > 100 || valClean < 0)
				valClean = 0;
			else
				resto = 100 - valClean;

			valor.srcElement.value = $filter('numDigMoneda')(String(valClean), 2);
		}
		
		if (resto != null)
			resto = $filter('numDigMoneda')(String(resto), 2);
		$scope.tablaRevenue.datos[fila][columna + 1].valor = resto;
	};

	$scope.setColspan = function(x) {
		return x.colspan;
	};

	$scope.guardarPremier = function() {
		var continuar = true;
		var tablas = [];

		// Se validan campos vacios		
		if($scope.tipoMin == "categoria") 
		{			
		   $scope.tablaMinGar.datos[0][0].valor = 0;
		   $scope.tablaMinGar.datos[0][1].valor = 0; 
		   $scope.tablaMinGar = feesValidateService.validarCeldasVacias($scope.tablaMinGar,$scope.tablaMinGar.datos[0].length, true); 
		   continuar          = feesValidateService.mensajeValidacion($scope.tablaMinGar.valida, $scope.tablaMinGar.nombre, ""); 
		   $scope.tablaMinGar.datos[0][0].valor = null; 
		   $scope.tablaMinGar.datos[0][1].valor = null; 
		}
		else 
		{
		   $scope.tablaMinAnio = feesValidateService.validarCeldasVacias($scope.tablaMinAnio, $scope.tablaMinAnio.datos[0].length, true); 
		   continuar = feesValidateService.mensajeValidacion($scope.tablaMinAnio.valida, $scope.tablaMinAnio.nombre, ""); 
		}
		  
		if(continuar) 
		{ 
		  $scope.tablaRelease = feesValidateService.validarCeldasVacias($scope.tablaRelease,
		  $scope.tablaRelease.datos[0].length, true); 
		  continuar = feesValidateService.mensajeValidacion($scope.tablaRelease.valida, $scope.tablaRelease.nombre, ""); 
		}
		  
		if(continuar) 
		{ 
		  $scope.tablaRevenue = feesValidateService.validarCeldasVacias($scope.tablaRevenue, $scope.tablaRevenue.datos[0].length, false); 
		  continuar = feesValidateService.mensajeValidacion($scope.tablaRevenue.valida, $scope.tablaRevenue.nombre, ", no se han registrado los porcentajes"); 
		}
		  
		//Se valida longitud categorias 
		if(continuar) 
		{ 
		  if($scope.tipoMin == "categoria") 
		  { 
			 $scope.tablaMinGar = feesValidateService.validarLongitudCeldas($scope.tablaMinGar, null, null, [2]);
			 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGar.valida, $scope.tablaMinGar.nombre, ""); 
		  } 
		}
		  
		if(continuar) 
		{ 
		  $scope.tablaRelease = feesValidateService.validarLongitudCeldas($scope.tablaRelease, null, null, [2]); 
		  continuar = feesValidateService.mensajeValidacion($scope.tablaRelease.valida, $scope.tablaRelease.nombre, ""); 
		}
		  
		//Se validan categorias repetidas 
		if(continuar)
		{ 
		  if($scope.tipoMin == "categoria") 
		  {
			 $scope.tablaMinGar = feesValidateService.validarCategoriasRepetidas($scope.tablaMinGar, 2);
			 continuar = feesValidateService.mensajeValidacion($scope.tablaMinGar.valida, $scope.tablaMinGar.nombre, ", existen categorias repetidas"); 
		  } 
		}
		  
		if(continuar) 
		{ 
		   $scope.tablaRelease = feesValidateService.validarCategoriasRepetidas($scope.tablaRelease, 2); 
		   continuar = feesValidateService.mensajeValidacion($scope.tablaRelease.valida, $scope.tablaRelease.nombre, ", existen categorias repetidas"); 
		}
		  
		//Se validan rangos 
		if(continuar) 
		{ 
		  if($scope.tipoMin == "categoria") 
		  {
		     $scope.tablaMinGar = feesValidateService.validarRangosTablas($scope.tablaMinGar, 0 ,1, 1);
		     continuar = feesValidateService.mensajeValidacion($scope.tablaMinGar.valida, $scope.tablaMinGar.nombre, ""); 
		  } 
		}
		  
		if(continuar) 
		{ 
		  $scope.tablaRelease = feesValidateService.validarRangosTablas($scope.tablaRelease, 0 ,1, 0);
		  continuar = feesValidateService.mensajeValidacion($scope.tablaRelease.valida, $scope.tablaRelease.nombre, ""); 
		}
		  
		//Se validan valores moneda 
		if(continuar) 
		{ 		  
          var formato     =	$scope.tablaPrecios.datos[0][1].valor;	
		  var numFormatos = 1;
		  for(var i=1; i<$scope.tablaPrecios.datos.length;i++)
		  {
			  if($scope.tablaPrecios.datos[i][1].valor == formato)
				  numFormatos++;
		  }
		  var numFormatos2 = $scope.tablaPrecios.datos.length / numFormatos;		  
		  var fila = numFormatos2 - 1;		  
		  var indicePais = 0;
		  
		  for(var j=2; j<$scope.tablaPrecios.datos[0].length; j+=2)
		  {			  		
			  if(!continuar) break;
			  fila = numFormatos2 - 1;
			  for(var i=0; i< $scope.tablaPrecios.datos.length; i+= numFormatos2)
			  {			
				  $scope.tablaPrecios = feesValidateService.validarValoresMonedaTablas($scope.tablaPrecios, i , fila, j, numFormatos2);
				  
				  var pais    = $scope.tablaPrecios.encabezados[indicePais].valor;
				  var mensaje = ". Falta regsitrar campos en el pa\u00EDs "+pais + " en el release "+$scope.tablaPrecios.datos[fila][0].valor;
				  continuar = feesValidateService.mensajeValidacion($scope.tablaPrecios.valida, $scope.tablaPrecios.nombre, mensaje);				  				  
				  fila = fila + numFormatos2;
				  if(!continuar) break;
			  }	
			  indicePais++;
		  }		  	  		   
		}
		 		
		//Se validan valores revenue porcentaje 
		if(continuar) 
		{ 
		  $scope.tablaRevenue = feesValidateService.validarTablasRevenuePorcentaje($scope.tablaRevenue, 1);
		  continuar = feesValidateService.mensajeValidacion($scope.tablaRevenue.valida, $scope.tablaRevenue.nombre, " debe ser menor de 100."); 
		}
		
		//se valida las fechas de minimos
		if (continuar)
		{
			var periodos = [];
			if ($scope.tipoMin == "categoria") 
			{				
				$("#tabMinCat thead tr th").each(function(index) {
					if(index > 1)
					{
						var fechas = $(this).text().split("-");
						if(fechas.length == 2)
						   periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})						
					}					   
				});				
			}
			else 
			{				
				$("#tabAnioMin thead tr th").each(function() {
					var fechas = $(this).text().split("-");
					if(fechas.length == 2)
					    periodos.push({fechaInicio: fechas[0], fechaFin: fechas[1]})
				});				
			}

			var valido = rentaPremierService.validarFechasPeriodos(periodos);
			continuar  = valido.validacion;
			if(!valido.validacion)
				showError(valido.mensaje);
						
			if(continuar)
			{
			   if( ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaInicioCto").val()).getTime() > $.datepicker.parseDate( 'mm/dd/yy',  periodos[0].fechaInicio).getTime()) ||  	    
				   ($.datepicker.parseDate( 'mm/dd/yy',  $("#fechaFinCto").val()).getTime()    < $.datepicker.parseDate( 'mm/dd/yy',  periodos[periodos.length-1].fechaFin).getTime()) )
			   {
				   continuar = false;
				   showError("El rango de fecha del periodo no est\u00E1 en el rango de tiempo del contrato.");
			   }			      		 
			}
		}
		
		if (continuar)
		{
			if($("#tipoCambio").val() == "0")
			{
				showError("Se debe seleccionar un valor para Tipo de Cambio.");
				continuar = false;
			}
		}
		
		if (continuar) 
		{
			var fees = {
				"categoriaMin" : null,
				"anioMin"      : null,
				"minimos"      : null,
				"minimosAnio"  : null,
				"releases"     : null,
				"impuestos"    : null,
				"revenue"      : null,
				"precio"       : null,
				"idCatMin"     : null,
				"paises"       : null,
				"aniosMin"     : null,
				"idCatEli"     : null,
				"idCatRel"     : null,
				"idCatRelEli"  : null
			}

			if ($scope.tipoMin == "categoria") 
			{
				fees.minimos  = rentaPremierService.crearMatriz($scope.tablaMinGar);
				fees.idCatMin = $scope.idsCat;
				fees.aniosMin = [];
				$("#tabMinCat thead tr th").each(function(index) {
					if(index > 1)
					{
						fees.aniosMin.push($(this).text())						
					}
					   
				});
				fees.idCatEli = $scope.idCatEli;
			}
			else 
			{
				fees.minimosAnio = rentaPremierService.crearMatriz($scope.tablaMinAnio);
				fees.aniosMin    = [ ];
				$("#tabAnioMin thead tr th").each(function() {
					fees.aniosMin.push($(this).text())
				});				
			}
			
			fees.releases  = rentaPremierService.crearMatriz($scope.tablaRelease);
			fees.idCatRel  = $scope.idsRel;
			fees.impuestos = rentaPremierService.crearMatriz($scope.tablaImpuestos);
			fees.precio    = rentaPremierService.crearMatriz($scope.tablaPrecios);
			fees.revenue   = rentaPremierService.crearMatriz($scope.tablaRevenue);
			fees.idsRelEli = $scope.idsRelEli;
			
			var idCto        = $("#idCto").val();
			var idTipoCambio = $("#tipoCambio").val();
			
			rentaPremierService.guardarPremier(fees, idCto, idTipoCambio).then(function(data) {
					if (data.error != null)
						showError(data.error);
					else
					{
						showMessage("Se han guardado los datos de la seccion Premier.");
						rentaPremierService.inicializarTablas().then(function(data) {
							$scope.inicializar(data);
							$scope.idCatEli = [];
						});
					}
            });
			
		}
	};

	$scope.abrirModalFechas = function(tipo, columna, operacion) {
		if(operacion == "periodo")
		{	
			$("#aceptarPer").hide();
			$("#addPer").show();
			$("#fechaPerInicio").val("");
			$("#fechaPerFin")   .val("");
			$("#modificarPeriodo").modal("show");
		}
		else
		{
			tipo = parseInt(tipo);
			$("#aceptarPer").show();
			$("#addPer").hide();
			if (tipo == 1) {
				if (parseInt(columna) > 1) {
					var fechas = $("#tabMinCat").find(
							"thead tr th:nth-child(" + (columna + 1) + ")").text()
							.split("-");
					$("#fechaPerInicio").val(fechas[0]);
					$("#fechaPerFin").val(fechas[1]);
					$("#modificarPeriodo").modal("show");
				}
			}
			if (tipo == 2) {
				var fechas = $("#tabAnioMin").find(
						"thead tr th:nth-child(" + (columna + 1) + ")").text()
						.split("-");
				$("#fechaPerInicio").val(fechas[0]);
				$("#fechaPerFin").val(fechas[1]);
				$("#modificarPeriodo").modal("show");
			}
			$("#modificarPeriodo").find("input[id='tipo']").val(tipo);
			$("#modificarPeriodo").find("input[id='columna']").val(columna);

		}
	};

	$scope.	agregarNuevoPeriodo = function() {
		
		if($("#fechaPerInicio").val() == "" || $("#fechaPerFin").val() == "")		
		   $("#labErroPer").text("No se han ingresado las fechas del periodo").show();
		else
		{
			var encabezado =  $("#fechaPerInicio").val()+"-" +$("#fechaPerFin").val();
				
			if($scope.tipoMin == "categoria")			
			   this.editarTablaMinGarantizados("addColumn",null, encabezado);	
			
			else if($scope.tipoMin == "anio")
				this.editarTablaMinGarantizadosAnio("addColumn",null, encabezado) ;
						
			$("#modificarPeriodo").modal("hide");	
		}			
	};

	$scope.actualizarPorFechas = function() {
		var tipo = parseInt($("#modificarPeriodo").find("input[id='tipo']")
				.val());
		var col = parseInt($("#modificarPeriodo").find("input[id='columna']")
				.val());
		var id = tipo == 1 ? "tabMinCat" : "tabAnioMin";

		var fecha = $("#fechaPerInicio").val() + "-" + $("#fechaPerFin").val();
		$("#" + id).find("thead tr th:nth-child(" + (col + 1) + ")")
				.text(fecha);
		$("#modificarPeriodo").modal("hide");
	};

	//funciones para importar exceles
	$scope.verificarDatos = function() {
		$('#modalImportarArchivo').modal('hide');
		if (datosSubir != null && datosSubir.datosMatriz != null) 
		{			
			if(uploader.tipoFees == "premier" && uploader.operacion == "minimos")			
			   this.importarMinimos(datosSubir.datosMatriz);
			if(uploader.tipoFees == "premier" && uploader.operacion == "release")
			   this.importarRelease(datosSubir.datosMatriz);
			if(uploader.tipoFees == "premier" && uploader.operacion == "precio")
			   this.importarPrecio(datosSubir.datosMatriz);						
		}
	};
	
	$scope.verifcarFilaVacia = function(data) {		
		var cont = 0;
		
		for(var i=0; i<data.fila.length; i++)
		{
			if(data.fila[i] === "" || data.fila[i] == null)
			   cont++
		}
		
		if(cont == data.fila.length)
			return true;
		else
			return false;
	};
	
	$scope.abrirModalMinimos = function() {
		uploader = new UploaderEX("cargaFeesDiv");
		uploader.tipoFees  = "premier";
		uploader.operacion = "minimos";
		this.abrirModalCarga();
	};
	
	$scope.importarMinimos = function(data) {		
		data.splice(0, 1);
		
		for(var i=0; i<data.length; i++)
		{
			if(!this.verifcarFilaVacia(data[i]))
			{
				var encontrado = false;
				for(var j=0; j<$scope.tablaMinGar.datos.length; j++)
				{										
					if($scope.tablaMinGar.datos[j][2].valor == data[i].fila[2])
					{
						$scope.tablaMinGar.datos[j][0].valor = data[i].fila[0];
						$scope.tablaMinGar.datos[j][1].valor = data[i].fila[1];
						
						var numCol = data[i].fila.length < $scope.tablaMinGar.datos[j].length ? data[i].fila.length :  $scope.tablaMinGar.datos[j].length;
						
						for(var k= 3; k< numCol; k++)
							$scope.tablaMinGar.datos[j][k].valor = data[i].fila[k];
						encontrado = true;
					}					 
				}
				
				if(!encontrado)
				{
					this.editarTablaMinGarantizados("addRow",null,null);
					var numCol = data[i].fila.length < $scope.tablaMinGar.datos[0].length ? data[i].fila.length :  $scope.tablaMinGar.datos[0].length;
										
					$scope.tablaMinGar.datos[$scope.tablaMinGar.datos.length-1][0].valor = data[i].fila[0];
					$scope.tablaMinGar.datos[$scope.tablaMinGar.datos.length-1][1].valor = data[i].fila[1];
					$scope.tablaMinGar.datos[$scope.tablaMinGar.datos.length-1][2].valor = data[i].fila[2];
																		
					for(var k= 3; k< numCol; k++)
						$scope.tablaMinGar.datos[$scope.tablaMinGar.datos.length-1][k].valor = data[i].fila[k];																	 					
				}
			}
		}
	};
							
	$scope.abrirModalRelease = function() {
		uploader = new UploaderEX("cargaFeesDiv");
		uploader.tipoFees  = "premier";
		uploader.operacion = "release";
		this.abrirModalCarga();
	};
	
	$scope.importarRelease = function(data) {
		
		data.splice(0, 1);
		
		for(var i=0; i<data.length; i++)
		{
			if(!this.verifcarFilaVacia(data[i]))
			{
				var encontrado = false;
				for(var j=0; j<$scope.tablaRelease.datos.length; j++)
				{										
					if($scope.tablaRelease.datos[j][2].valor == data[i].fila[2])
					{
						$scope.tablaRelease.datos[j][0].valor = data[i].fila[0];
						$scope.tablaRelease.datos[j][1].valor = data[i].fila[1];												
						encontrado = true;
					}					 
				}
				
				if(!encontrado)
				{
					this.editarTablaRelease("addRow",null,null);					
										
					$scope.tablaRelease.datos[$scope.tablaRelease.datos.length-1][0].valor = data[i].fila[0];
					$scope.tablaRelease.datos[$scope.tablaRelease.datos.length-1][1].valor = data[i].fila[1];
					$scope.tablaRelease.datos[$scope.tablaRelease.datos.length-1][2].valor = data[i].fila[2];					
					$scope.tablaPrecios.datos[($scope.tablaRelease.datos.length-1)*3][0].valor = data[i].fila[2];
					$scope.tablaRevenue.datos[$scope.tablaRelease.datos.length-1][0].valor = data[i].fila[2];
				}
			}
		}
	};
	
	$scope.abrirModalPrecio = function() {
		uploader = new UploaderEX("cargaFeesDiv");
		uploader.tipoFees  = "premier";
		uploader.operacion = "precio";
		this.abrirModalCarga();
	};
	
	$scope.importarPrecio = function(data) {		
		data.splice(0, 2);		
		for(var i=0; i<$scope.tablaPrecios.datos.length; i++)		
			for(var j=0; j<$scope.tablaPrecios.datos[0].length; j++)				
				$scope.tablaPrecios.datos[i][j].valor = data[i].fila[j];		
	};
								
	$scope.cargarDatos = function() {
		uploader.startUpload("modalCarga");
	};		
	
	$scope.abrirModalCarga = function() {
		uploader.limpiaForma("idFormCargaAlgo");
		$("#esperaDiv").html("");
		$("#modalImportarArchivo").modal("show");
	};
	
	//funcion para exportar excel
	$scope.exportarExcel = function(seccion, operacion, datos, encabezados) {
					
		datos   = rentaPremierService.crearMatriz(datos);		
		var enc = [];
		
		if(operacion == "min_cat")
		{
		   enc[0] = encabezados[0].valor;
		   enc[1] = "";
		   for(var i=1; i<encabezados.length;i++)
			   enc[i+1] = encabezados[i].valor;	
		}
		else if(operacion == "min_anio")
		{				
			$( "#tabAnioMin thead tr" ).find("th").each(function() {
				  enc.push($(this).text());
			});		   	
			enc.splice(enc.length-1,1);				
		}
		else if(operacion == "release")
		{
		   enc[0] = "Desde";
		   enc[1] = "Hasta";
		   enc[2] = "Categorias";		   	
		}
		else if(operacion == "precio")
		{
			var temp = datos;
			
			var valor = "";				
			for(var i=0; i< temp.length;i++)
			{
			   if(valor != temp[i][0])
				   valor = temp[i][0];
			   else
				  temp[i][0] = ""; 
			}
			
			var fila = [];
			fila.push("Release");
			fila.push("Formato");
			
			for(var i=0; i<(datos[0].length-2)/2;i++)
			{
				fila.push("ML");
			    fila.push("Dolares");
			}
			
			var datos1 = [];
			datos1.push(fila);
			
			for(var i=0; i<temp.length;i++)
				datos1.push(temp[i]);
			datos = datos1;	
			
			enc[0] = "Precio por evento";
			enc[1] = "";
			for(var i=0; i<encabezados.length;i++)
			{
				enc.push(encabezados[i].valor);
				enc.push("");
			}
			    
		}
		
		rentaPremierService.descargarArchivo(seccion, operacion, $("#idCto").val(), datos, enc).then(function(data) {  });				
	};
		
};

registraController("rentaPremierController", rentaPremierController);