/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.factura.general.bos;

import com.mx.dla.dda.factura.general.bos.ConvertidordDto2Rest;
import com.mx.dla.dda.factura.general.daos.FacturacionDAO;
import com.mx.dla.dda.factura.general.dtos.EstudioConsultaDTO;
import com.mx.dla.dda.factura.general.dtos.FacturaGeneralDTO;
import com.mx.dla.dda.factura.general.dtos.ParamNotificaFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.ResponseNotificarFacturaDTO;
import com.mx.dla.dda.factura.ws.dtos.DDA_I172334DTO;
import com.mx.dla.dda.factura.ws.dtos.DTFactura;
import com.mx.dla.dda.factura.ws.dtos.DTMovimientoFinalPO;
import com.mx.dla.dda.factura.ws.dtos.FacturaDTO;
import com.mx.dla.dda.general.constants.InterfazWSRespuesta;
import com.mx.dla.dda.general.dtos.ResponseDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FacturacionWServiceBO
extends BaseBO {
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private FacturacionDAO facturacionDAO;
    @Autowired
    private ConvertidordDto2Rest convertidor;
    @Value(value="${factura.detalle.isoMedida}")
    protected String isoMedida;

    public Integer notificaFacturaInterfaz(FacturaGeneralDTO facturaDTO) {
        Integer estatus = 0;
        String iso = this.facturacionDAO.consultaIsoMedida(this.isoMedida);
        iso = iso == null ? "" : iso;
        EstudioConsultaDTO estudio = this.facturacionDAO.consultaEstudio(facturaDTO.getIdEstudio());
        DTFactura message = this.convertidor.generaFacturaWS(facturaDTO, estudio.getDescEstudio(), estudio.getMoneda(), iso);
        try {
            this.logger.info("Rest FACTURA_NOTIFICA #14 {}", (Object)message.getFactura().getReferencia());
            DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.FACTURA_NOTIFICA);
            FacturaDTO response = client.get(message, FacturaDTO.class);
            this.logger.info("Notificar Factura Respuesta {}", (Object)response.getEstatusDda());
            if (response != null && response.getEstatusDda() != null && InterfazWSRespuesta.parse((String)response.getEstatusDda()).equals((Object)InterfazWSRespuesta.OK)) {
                estatus = new Integer(InterfazWSRespuesta.OK.getValue());
                facturaDTO.setIdSapRegistro(response.getrFactura());
            } else {
                estatus = new Integer(InterfazWSRespuesta.ERROR.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("Error: " + e.getMessage());
            estatus = 0;
        }
        return estatus;
    }

    public Integer enviaMovimientoFinal(String idSap) {
        DTMovimientoFinalPO message = this.convertidor.generaRegistro(idSap);
        Integer estatus = 0;
        try {
            this.logger.info("Servicio ENVIA_MOVIMIENTO_FINAL # 34.");
            this.logger.info("Solicitud {}", (Object)message.getRegistro().getNumDoc());
            DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.ENVIA_MOVIMIENTO_FINAL);
            DDA_I172334DTO response = client.get(message, DDA_I172334DTO.class);
            this.logger.info("Respuesta {}", (Object)response.getEstatus_dda());
            if (response != null && response.getEstatus_dda() != null) {
                estatus = InterfazWSRespuesta.parse((String)response.getEstatus_dda()).equals((Object)InterfazWSRespuesta.OK) ? new Integer(InterfazWSRespuesta.OK.getValue()) : new Integer(InterfazWSRespuesta.ERROR.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("Error: " + e.getMessage());
            estatus = 0;
        }
        return estatus;
    }

    public ResponseDTO notificaFactura(FacturaGeneralDTO facturaDTO) {
        ResponseDTO respuesta = new ResponseDTO();
        respuesta.setCodigo(new Integer(InterfazWSRespuesta.OK.getValue()));
        respuesta.setMensaje(InterfazWSRespuesta.OK.getDesc());
        ParamNotificaFacturaDTO message = new ParamNotificaFacturaDTO();
        message.setIdFactura(facturaDTO.getIdFactura().toString());
        try {
            this.logger.info("Rest FACTURA_NOTIFICA #14 {}", (Object)message.getIdFactura());
            this.logger.debug("Request servicio {}", (Object)message);
            DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.FACTURA_NOTIFICA);
            ResponseNotificarFacturaDTO response = client.get(message, ResponseNotificarFacturaDTO.class);
            this.logger.debug("Response servicio {}", (Object)response);
            if (response != null && response.getResultado()) {
                this.logger.info("Notificar Factura Respuesta {}", (Object)response.getMensaje());
                respuesta.setCodigo(new Integer(InterfazWSRespuesta.OK.getValue()));
                respuesta.setMensaje(InterfazWSRespuesta.OK.getDesc());
            } else {
                respuesta.setCodigo(new Integer(InterfazWSRespuesta.ERROR.getValue()));
                respuesta.setMensaje(response.getMensaje());
            }
        }
        catch (Exception e) {
            this.logger.error("Error: " + e.getMessage());
            respuesta.setCodigo(new Integer(InterfazWSRespuesta.ERROR.getValue()));
            respuesta.setMensaje(e.getMessage());
        }
        return respuesta;
    }
}

