/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.ncredito.general.bos;

import com.mx.dla.dda.general.constants.InterfazWSRespuesta;
import com.mx.dla.dda.ncredito.general.bos.NCreditoConvertidordDto2Rest;
import com.mx.dla.dda.ncredito.general.daos.NotaCreditoDAO;
import com.mx.dla.dda.ncredito.general.dtos.ContratoNotaCreditoGeneralDTO;
import com.mx.dla.dda.ncredito.ws.dtos.DTNotaCredito;
import com.mx.dla.dda.ncredito.ws.dtos.NotaCreditoDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class NotaCreditoWServiceBO
extends BaseBO {
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private NotaCreditoDAO facturacionDAO;
    @Autowired
    private NCreditoConvertidordDto2Rest convertidor;
    @Value(value="${factura.detalle.isoMedida}")
    protected String isoMedida;

    public Integer notificaFacturaInterfaz(ContratoNotaCreditoGeneralDTO facturaDTO) {
        Integer estatus = 0;
        DTNotaCredito message = this.convertidor.generaFacturaWS(facturaDTO);
        try {
            this.logger.info("Notificar Factura Request : {}", (Object)message.getRegistro());
            DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.NOTA_CREDITO_CARGA);
            NotaCreditoDTO response = client.get(message, NotaCreditoDTO.class);
            this.logger.info("Notificar Factura Response {}", (Object)response.getEstatusDda());
            if (response != null && response.getEstatusDda() != null && InterfazWSRespuesta.parse((String)response.getEstatusDda()).equals((Object)InterfazWSRespuesta.OK)) {
                estatus = new Integer(InterfazWSRespuesta.OK.getValue());
                facturaDTO.setIdSapRegistro(response.getrFactura());
            } else {
                estatus = new Integer(InterfazWSRespuesta.ERROR.getValue());
            }
        }
        catch (Exception e) {
            this.logger.error("Error: " + e.getMessage());
            estatus = 0;
        }
        return estatus;
    }
}

