/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config.impl;

import com.opensymphony.xwork2.util.PatternMatcher;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMatcher<E>
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractMatcher.class);
    PatternMatcher<Object> wildcard;
    List<Mapping<E>> compiledPatterns = new ArrayList<Mapping<E>>();

    public AbstractMatcher(PatternMatcher<?> helper) {
        this.wildcard = helper;
    }

    public void addPattern(String name, E target, boolean looseMatch) {
        if (!this.wildcard.isLiteral(name)) {
            int lastStar;
            if (looseMatch && name.length() > 0 && name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (log.isDebugEnabled()) {
                log.debug("Compiling pattern '" + name + "'", new String[0]);
            }
            Object pattern = this.wildcard.compilePattern(name);
            this.compiledPatterns.add(new Mapping<E>(name, pattern, target));
            if (looseMatch && (lastStar = name.lastIndexOf(42)) > 1 && lastStar == name.length() - 1 && name.charAt(lastStar - 1) != '*') {
                pattern = this.wildcard.compilePattern(name.substring(0, lastStar - 1));
                this.compiledPatterns.add(new Mapping<E>(name, pattern, target));
            }
        }
    }

    public void freeze() {
        this.compiledPatterns = Collections.unmodifiableList(new ArrayList());
    }

    public E match(String potentialMatch) {
        E config = null;
        if (this.compiledPatterns.size() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("Attempting to match '" + potentialMatch + "' to a wildcard pattern, " + this.compiledPatterns.size() + " available", new String[0]);
            }
            LinkedHashMap<String, String> vars = new LinkedHashMap<String, String>();
            for (Mapping<E> m : this.compiledPatterns) {
                if (!this.wildcard.match(vars, potentialMatch, m.getPattern())) continue;
                if (log.isDebugEnabled()) {
                    log.debug("Value matches pattern '" + m.getOriginalPattern() + "'", new String[0]);
                }
                config = this.convert(potentialMatch, m.getTarget(), vars);
                break;
            }
        }
        return config;
    }

    protected abstract E convert(String var1, E var2, Map<String, String> var3);

    protected Map<String, String> replaceParameters(Map<String, String> orig, Map<String, String> vars) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String key : orig.keySet()) {
            map.put(key, this.convertParam(orig.get(key), vars));
        }
        for (String key : vars.keySet()) {
            if (NumberUtils.isNumber((String)key)) continue;
            map.put(key, vars.get(key));
        }
        return map;
    }

    protected String convertParam(String val, Map<String, String> vars) {
        if (val == null) {
            return null;
        }
        int len = val.length();
        StringBuilder ret = new StringBuilder();
        for (int x = 0; x < len; ++x) {
            char c = val.charAt(x);
            if (x < len - 2 && c == '{' && '}' == val.charAt(x + 2)) {
                String varVal = vars.get(String.valueOf(val.charAt(x + 1)));
                if (varVal != null) {
                    ret.append(varVal);
                }
                x += 2;
                continue;
            }
            ret.append(c);
        }
        return ret.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Mapping<E>
    implements Serializable {
        private String original;
        private Object pattern;
        private E config;

        public Mapping(String original, Object pattern, E config) {
            this.original = original;
            this.pattern = pattern;
            this.config = config;
        }

        public Object getPattern() {
            return this.pattern;
        }

        public E getTarget() {
            return this.config;
        }

        public String getOriginalPattern() {
            return this.original;
        }
    }
}

