/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.apartados.bos;

import com.mx.dla.dda.admin.catalogos.apartados.daos.ApartadosDAO;
import com.mx.dla.dda.contrato.excepcion.SuscriptorException;
import com.mx.dla.dda.contrato.generales.dtos.ApartadoDTO;
import com.mx.dla.dda.contrato.ws.dtos.DTOrdenInterna;
import com.mx.dla.dda.ordenesinternas.dtos.OrdenesInternasDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApartadosBO
extends BaseBO {
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Autowired
    private ApartadosDAO apartadosDAO;
    @Value(value="${ordenInterna.centroCostos}")
    private String centroCostosOrdInt;
    @Value(value="${ordenInterna.sociedad}")
    private String sociedadOrdInt;

    public List<ApartadoDTO> selectBusquedaApartados(String operacion) {
        List apartados = null;
        apartados = operacion.compareTo("Amortizable") == 0 || operacion.compareTo("No Amortizable") == 0 ? this.apartadosDAO.getApartadosXAmortizable(operacion) : this.apartadosDAO.getApartados();
        return apartados;
    }

    public List<ApartadoDTO> getApartados() {
        return this.apartadosDAO.getApartados();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String generarApartado(String des, String id, String amortizable) throws Exception {
        String mensaje = "";
        if (id.compareTo("null") == 0) {
            Long idA = this.apartadosDAO.obtenerApartadoExistente(amortizable, des);
            if (idA != null) throw new SuscriptorException("No se ha podido guardar el apartado, ya existe.");
            ApartadoDTO apartado = new ApartadoDTO(des, amortizable);
            this.apartadosDAO.guardarApartado(apartado, Integer.valueOf(1));
            mensaje = apartado.getIdApartado().toString();
            if (amortizable.compareTo("Amortizable") != 0) return mensaje;
            this.notificarApartadoNoAmortizablesSAP(apartado);
            if (apartado.getIdSap() == null) {
                this.apartadosDAO.eliminarApartado(apartado.getIdApartado());
                throw new SuscriptorException("No se ha podido guardar el apartado a SAP");
            }
            if (apartado.getIdSap().compareTo("0") != 0) return mensaje;
            this.apartadosDAO.eliminarApartado(apartado.getIdApartado());
            throw new SuscriptorException("No se ha podido notificar el apartado a SAP");
        }
        this.logger.debug("edita apartado");
        ApartadoDTO apartado = new ApartadoDTO(Long.valueOf(Long.parseLong(id)), des, amortizable);
        this.apartadosDAO.editarApartado(apartado);
        return "Se ha actualizado el apartado.";
    }

    public void notificarApartadoNoAmortizablesSAP(ApartadoDTO apartado) {
        DTOrdenInterna dTOrdenInterna = new DTOrdenInterna();
        OrdenesInternasDTO ordenesInternasDTO = new OrdenesInternasDTO();
        DTOrdenInterna.Registro registro = new DTOrdenInterna.Registro();
        ArrayList<DTOrdenInterna.Registro> registros = new ArrayList<DTOrdenInterna.Registro>();
        registro.setIDDDA(String.valueOf(apartado.getIdApartado()));
        registro.setDescripcion(apartado.getDescripcion());
        registro.setSociedad(this.sociedadOrdInt);
        registro.setCentroCostos(this.centroCostosOrdInt);
        registros.add(registro);
        dTOrdenInterna.setRegistro(registros);
        try {
            this.logger.info("Se llama al servicio ORDENAS_INTERNAS #3");
            this.logger.info("IDDA: {}, DESCRIPCION: {}, SOCIEDAD: NT07, CENTROCOSTO: 07A01US602", (Object)apartado.getIdApartado(), (Object)apartado.getDescripcion());
            DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.ORDENES_INTERNAS);
            this.logger.info("url {}", (Object)c.getUri());
            ordenesInternasDTO = c.get(dTOrdenInterna, OrdenesInternasDTO.class);
            this.logger.info("Respuesta servicio id_sap:{}, estatus:{}", (Object)ordenesInternasDTO.getR_id_sap(), (Object)ordenesInternasDTO.getEstatus_dda());
            if (ordenesInternasDTO.getR_id_sap() == null || ordenesInternasDTO.getR_id_sap().trim().isEmpty()) {
                throw new Exception("La respuesta de SAP envio un id SAP nulo o vacio");
            }
            apartado.setIdSap(ordenesInternasDTO.getR_id_sap());
            this.apartadosDAO.editarSAP(apartado);
        }
        catch (Exception e) {
            this.logger.error("ERROR ", (Throwable)e);
            this.logger.error("CAUSA ", e.getCause());
            this.apartadosDAO.eliminarApartado(apartado.getIdApartado());
        }
    }
}

