/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.broadview.bos;

import com.mx.dla.dda.contrato.broadview.daos.ContratoBroadviewDAO;
import com.mx.dla.dda.contrato.broadview.dtos.ContratoBroadviewDTO;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContratoBroadviewBO {
    private static Logger logger = Logger.getLogger(ContratoBroadviewBO.class);
    @Autowired
    private TerminosDAO terminosDao;
    @Autowired
    private TituloDAO titulosDao;
    @Autowired
    private ContratoBroadviewDAO broadviewDao;

    public List<ContratoBroadviewDTO> cargaListaBroadViewTitulos(Long idCntBv) {
        return this.broadviewDao.consultaBroadviewTitulos(idCntBv);
    }

    public List<Titulo> cargaListaTitulosContrato(Long idContrato) {
        return this.titulosDao.buscarTitulosContrato(idContrato);
    }

    public List<ContratoBroadviewDTO> procesaBroadviewAsignados(List<ContratoBroadviewDTO> broadviewList, List<Titulo> ddaList, Integer operacionAsignados) {
        Iterator<ContratoBroadviewDTO> i = broadviewList.iterator();
        while (i.hasNext()) {
            ContratoBroadviewDTO s = i.next();
            Boolean asignado = false;
            for (Titulo tItem : ddaList) {
                if (tItem.getIdBv() == null || s.getIdBroadview().longValue() != new Long(tItem.getIdBv()).longValue()) continue;
                asignado = true;
            }
            if (asignado.booleanValue()) {
                s.setDdaAsignado(Integer.valueOf(1));
                if (operacionAsignados != 0) continue;
                i.remove();
                continue;
            }
            s.setDdaAsignado(Integer.valueOf(0));
        }
        return broadviewList;
    }

    public List<Titulo> procesaDDAAsignados(List<Titulo> ddaList, Integer operacionAsignados) {
        Iterator<Titulo> i = ddaList.iterator();
        while (i.hasNext()) {
            Titulo s = i.next();
            if (operacionAsignados != 0 || s.getIdBv() == null) continue;
            i.remove();
        }
        return ddaList;
    }

    public void asignaTitulosDDABroadviewPorDescripcion(List<ContratoBroadviewDTO> broadviewList, List<Titulo> ddaList) {
        for (ContratoBroadviewDTO broadviewItem : broadviewList) {
            for (Titulo ddaItem : ddaList) {
                if (!broadviewItem.getDescripcionTitulo().equals(ddaItem.getDescTitulo()) || this.esBroadviewAsignado(ddaList, broadviewItem.getIdBroadview())) continue;
                broadviewItem.setDdaAsignado(Integer.valueOf(1));
                ddaItem.setIdBv(broadviewItem.getIdBroadview().toString());
            }
        }
    }

    public List<ContratoBroadviewDTO> separaTitulosNoAsignadosBroadview(List<ContratoBroadviewDTO> broadviewList) {
        ArrayList<ContratoBroadviewDTO> newBroadviewList = new ArrayList<ContratoBroadviewDTO>();
        for (ContratoBroadviewDTO s : broadviewList) {
            if (s == null || s.getDdaAsignado() == null || s.getDdaAsignado() != 0) continue;
            newBroadviewList.add(s);
        }
        return newBroadviewList;
    }

    public List<Titulo> separaTitulosNoAsignadosDla(List<Titulo> ddaList) {
        ArrayList<Titulo> newDdaList = new ArrayList<Titulo>();
        for (Titulo s : ddaList) {
            if (s == null || s.getIdBv() != null) continue;
            newDdaList.add(s);
        }
        return newDdaList;
    }

    public List<ContratoBroadviewDTO> separaTitulosAsignadosBroadview(List<ContratoBroadviewDTO> broadviewList) {
        ArrayList<ContratoBroadviewDTO> newBroadviewList = new ArrayList<ContratoBroadviewDTO>();
        for (ContratoBroadviewDTO s : broadviewList) {
            if (s == null || s.getDdaAsignado() == null || s.getDdaAsignado() != 1) continue;
            newBroadviewList.add(s);
        }
        return newBroadviewList;
    }

    public List<Titulo> separaTitulosAsignadosDla(List<Titulo> ddaList) {
        ArrayList<Titulo> newDdaList = new ArrayList<Titulo>();
        for (Titulo s : ddaList) {
            if (s == null || s.getIdBv() == null) continue;
            newDdaList.add(s);
        }
        return newDdaList;
    }

    public boolean esBroadviewAsignado(List<Titulo> ddaList, Long idBroadview) {
        for (Titulo titulo : ddaList) {
            if (titulo.getIdBv() == null || new Long(titulo.getIdBv()).longValue() != idBroadview.longValue()) continue;
            return true;
        }
        return false;
    }

    public List<Titulo> ordenaTitulosDdaAsignadosDlaPorBroadview(List<Titulo> ddaList, List<ContratoBroadviewDTO> broadviewOrdenList) {
        ArrayList<Titulo> newDdaList = new ArrayList<Titulo>();
        for (ContratoBroadviewDTO itemBusca : broadviewOrdenList) {
            for (Titulo itemEncuentra : ddaList) {
                if (itemEncuentra.getIdBv() == null || (long)new Long(itemEncuentra.getIdBv()).intValue() != itemBusca.getIdBroadview()) continue;
                newDdaList.add(itemEncuentra);
            }
        }
        return newDdaList;
    }

    public void guardarTitulosListaContrato(List<Titulo> titulosDDAEditadaTitulos, Long idContrato) {
        List listaDDAActualTitulos = this.titulosDao.buscarTitulosContrato(idContrato);
        for (Titulo catTitulo : listaDDAActualTitulos) {
            catTitulo.setIdBv(null);
            this.titulosDao.actualizarTitulosContrato(catTitulo);
        }
        for (Titulo catTitulo : titulosDDAEditadaTitulos) {
            this.titulosDao.actualizarTitulosContrato(catTitulo);
        }
    }

    public void actualizaBroadviewContrato(ContratoConsultaDTO contratoConsulta) {
        this.terminosDao.actualizaBroadviewContrato(contratoConsulta);
    }

    public Long consultaDealPorContrato(Long idContrato) {
        ContratoConsultaDTO contrato = new ContratoConsultaDTO();
        contrato.setIdContrato(idContrato);
        contrato = this.terminosDao.consultaContrato(contrato);
        if (contrato == null) {
            return null;
        }
        if (contrato.getIdBv() == null) {
            return null;
        }
        return new Long(contrato.getIdBv());
    }
}

