/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.terminos.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.bos.TerminosMinimos;
import com.mx.dla.dda.contrato.transaccion.terminos.daos.TerminosTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.FsPeriodoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.MinimoTipos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.PeriodoTipos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueBoxGloDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueSeccionDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.RevenueTipos;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminoMinimoDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosAuxiliarDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosPaisDTO;
import com.mx.dla.dda.contrato.transaccion.terminos.dtos.TerminosRevenueDTO;
import com.mx.dla.dda.general.utilerias.ListaUtilerias;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TerminosRevenue
extends BaseBO {
    @Autowired
    private TerminosTransaccionDAO dao;
    @Autowired
    private FeesContratoDAO feesDao;
    @Autowired
    private TerminosMinimos minimo;

    public RevenueSeccionDTO obtenerRevenue(Long idContrato, String seccion, String[][] release) {
        List revenues = this.dao.obtenerRevenueRelease(idContrato, seccion);
        List periodos = this.dao.obtenerPeriodosRevenue(idContrato, seccion);
        String[] releases = new String[release.length];
        for (int i = 0; i < release.length; ++i) {
            releases[i] = release[i][2];
        }
        RevenueSeccionDTO revenue = this.procesoRevenue(idContrato, releases, revenues, (List<String>)periodos);
        return revenue;
    }

    public RevenueBoxGloDTO obtenerRevenueMovies(Long idContrato, String seccion, String[][] precio) {
        RevenueBoxGloDTO rev = new RevenueBoxGloDTO();
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        List revenues = this.dao.obtenerRevenueMoviesBox(idContrato);
        List periodos = this.dao.obtenerPeriodosRevenueMoviesBox(idContrato, idSeccion);
        HashSet<String> tiersRaw = new HashSet<String>();
        String tipoRevenue = this.obtenerTipoRevenue(idContrato, seccion);
        if (RevenueTipos.GLOBAL.equals((Object)RevenueTipos.getSeccion((String)tipoRevenue))) {
            rev.setRevenueBox(false);
            rev.setRevenueGlobal(true);
        } else {
            rev.setRevenueBox(true);
            rev.setRevenueGlobal(false);
        }
        for (String[] row : precio) {
            tiersRaw.add(row[0]);
        }
        String[] tiers = tiersRaw.toArray(new String[tiersRaw.size()]);
        RevenueSeccionDTO revenueBox = this.procesoRevenue(idContrato, tiers, revenues, (List<String>)periodos);
        rev.setDatosRevenueBox(revenueBox.getRevenue());
        rev.setPeriodos(revenueBox.getPeriodos());
        List revenueGlobal = this.dao.obtenerRevenueMoviesGlobal(idContrato, seccion);
        String[][] global = this.proceseoRevenueGlobal(revenueGlobal);
        rev.setDatosRevenueGlobal(global);
        return rev;
    }

    public RevenueBoxGloDTO obtenerRevenueSeries(Long idContrato, String seccion, String[][] precio) {
        RevenueBoxGloDTO rev = new RevenueBoxGloDTO();
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        List revenues = this.dao.obtenerRevenueSeriesBox(idContrato);
        List periodos = this.dao.obtenerPeriodosRevenueMoviesBox(idContrato, idSeccion);
        HashSet<String> tiersRaw = new HashSet<String>();
        String tipoRevenue = this.obtenerTipoRevenue(idContrato, seccion);
        if (RevenueTipos.GLOBAL.equals((Object)RevenueTipos.getSeccion((String)tipoRevenue))) {
            rev.setRevenueBox(false);
            rev.setRevenueGlobal(true);
        } else {
            rev.setRevenueBox(true);
            rev.setRevenueGlobal(false);
        }
        for (String[] row : precio) {
            tiersRaw.add(row[0]);
        }
        String[] tiers = tiersRaw.toArray(new String[tiersRaw.size()]);
        RevenueSeccionDTO revenueBox = this.procesoRevenue(idContrato, tiers, revenues, (List<String>)periodos);
        rev.setDatosRevenueBox(revenueBox.getRevenue());
        rev.setPeriodos(revenueBox.getPeriodos());
        List revenueGlobal = this.dao.obtenerRevenueMoviesGlobal(idContrato, seccion);
        String[][] global = this.proceseoRevenueGlobal(revenueGlobal);
        rev.setDatosRevenueGlobal(global);
        return rev;
    }

    public RevenueSeccionDTO procesoRevenue(Long idContrato, String[] release, List<TerminosRevenueDTO> revenues, List<String> periodos) {
        RevenueSeccionDTO revenue = new RevenueSeccionDTO();
        if (release == null || release.length == 0) {
            release[0] = "";
        }
        if (periodos == null || periodos.isEmpty()) {
            periodos = Arrays.asList(this.feesDao.fechaInicio(idContrato) + "-" + this.feesDao.fechaFin(idContrato));
        }
        String[][] datos = new String[release.length][periodos.size() * 2 + 1];
        int indFilaPais = 0;
        for (int i = 0; i < release.length; ++i) {
            datos[indFilaPais][0] = release[i];
            block1: for (int j = 0; j < periodos.size(); ++j) {
                for (int k = 0; k < revenues.size(); ++k) {
                    TerminosRevenueDTO item = revenues.get(k);
                    String fechaInicio = periodos.get(j).split("-")[0];
                    if (!item.getRelease().equals(release[i]) || !fechaInicio.equals(item.getFechaInicio())) continue;
                    datos[indFilaPais][j * 2 + 1] = item.getDdaPto();
                    datos[indFilaPais][j * 2 + 2] = item.getEstudioPto();
                    continue block1;
                }
            }
            ++indFilaPais;
        }
        String[] per = new String[periodos.size()];
        per = periodos.toArray(per);
        revenue.setPeriodos(per);
        revenue.setRevenue(datos);
        return revenue;
    }

    public String[][] proceseoRevenueGlobal(List<TerminosRevenueDTO> revenueGlobal) {
        String[][] global = new String[1][3];
        if (revenueGlobal != null && !revenueGlobal.isEmpty()) {
            global = new String[revenueGlobal.size()][3];
            for (int i = 0; i < revenueGlobal.size(); ++i) {
                global[i][0] = revenueGlobal.get(i).getFechaInicio() + "-" + revenueGlobal.get(i).getFechaFin();
                global[i][1] = revenueGlobal.get(i).getDdaPto();
                global[i][2] = revenueGlobal.get(i).getEstudioPto();
            }
        }
        return global;
    }

    public void guardarRevenue(Long idContrato, String seccion, Long[] release, RevenueSeccionDTO revenue) {
        if (revenue != null) {
            int i;
            Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.CATEGORIA.getDesc());
            ArrayList<FsPeriodoDTO> pers = new ArrayList<FsPeriodoDTO>();
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (i = 0; i < revenue.getPeriodos().length; ++i) {
                String[] periodosRev = revenue.getPeriodos()[i].split("-");
                FsPeriodoDTO periodo = new FsPeriodoDTO();
                periodo.setFechaInicio(periodosRev[0]);
                periodo.setFechaFin(periodosRev[1]);
                periodo.setIdSeccion(idSeccion);
                periodo.setIdContrato(idContrato);
                periodo.setTipo("REVENUE");
                this.dao.guardarPeridoMinimos(periodo);
                pers.add(periodo);
            }
            for (i = 0; i < revenue.getRevenue().length; ++i) {
                for (int j = 0; j < pers.size(); ++j) {
                    TerminosRevenueDTO t = new TerminosRevenueDTO();
                    t.setIdPeriodo(((FsPeriodoDTO)pers.get(j)).getIdPeriodo());
                    t.setIdRelease(release[i]);
                    t.setDdaPto(revenue.getRevenue()[i][j * 2 + 1]);
                    t.setEstudioPto(revenue.getRevenue()[i][j * 2 + 2]);
                    revenues.add(t);
                }
            }
            this.dao.guardarRevenue(revenues);
        }
    }

    public void guardarRevenueMovies(Long idContrato, String seccion, List<TerminosPaisDTO> categorias, RevenueBoxGloDTO revenue) {
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        if (revenue.isRevenueGlobal()) {
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (int i = 0; i < revenue.getDatosRevenueGlobal().length; ++i) {
                TerminosRevenueDTO t = new TerminosRevenueDTO();
                String[] fechas = revenue.getDatosRevenueGlobal()[i][0].split("-");
                t.setFechaInicio(fechas[0]);
                t.setFechaFin(fechas[1]);
                t.setDdaPto(revenue.getDatosRevenueGlobal()[i][1]);
                t.setEstudioPto(revenue.getDatosRevenueGlobal()[i][2]);
                revenues.add(t);
            }
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.GLOBAL.getDesc());
            this.dao.guardarValoresRevGlobal(idContrato, idSeccion, revenues);
        } else {
            int i;
            ArrayList<FsPeriodoDTO> pers = new ArrayList<FsPeriodoDTO>();
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (i = 0; i < revenue.getPeriodos().length; ++i) {
                String[] periodosRev = revenue.getPeriodos()[i].split("-");
                FsPeriodoDTO periodo = new FsPeriodoDTO();
                periodo.setFechaInicio(periodosRev[0]);
                periodo.setFechaFin(periodosRev[1]);
                periodo.setIdSeccion(idSeccion);
                periodo.setIdContrato(idContrato);
                periodo.setTipo("REVENUE");
                this.dao.guardarPeridoMinimos(periodo);
                pers.add(periodo);
            }
            for (i = 0; i < revenue.getDatosRevenueBox().length; ++i) {
                for (int j = 0; j < pers.size(); ++j) {
                    TerminosRevenueDTO t = new TerminosRevenueDTO();
                    t.setIdPeriodo(((FsPeriodoDTO)pers.get(j)).getIdPeriodo());
                    for (TerminosPaisDTO categoria : categorias) {
                        if (!revenue.getDatosRevenueBox()[i][0].equals(categoria.getDescripcion())) continue;
                        t.setIdRelease(categoria.getIdPais());
                    }
                    t.setDdaPto(revenue.getDatosRevenueBox()[i][j * 2 + 1]);
                    t.setEstudioPto(revenue.getDatosRevenueBox()[i][j * 2 + 2]);
                    revenues.add(t);
                }
            }
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.CATEGORIA.getDesc());
            this.dao.guardarValoresRevBoxMovies(idContrato, revenues);
        }
    }

    public void guardarRevenueSeries(Long idContrato, String seccion, List<TerminosPaisDTO> categorias, RevenueBoxGloDTO revenue) {
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        if (revenue.isRevenueGlobal()) {
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (int i = 0; i < revenue.getDatosRevenueGlobal().length; ++i) {
                TerminosRevenueDTO t = new TerminosRevenueDTO();
                String[] fechas = revenue.getDatosRevenueGlobal()[i][0].split("-");
                t.setFechaInicio(fechas[0]);
                t.setFechaFin(fechas[1]);
                t.setDdaPto(revenue.getDatosRevenueGlobal()[i][1]);
                t.setEstudioPto(revenue.getDatosRevenueGlobal()[i][2]);
                revenues.add(t);
            }
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.GLOBAL.getDesc());
            this.dao.guardarValoresRevGlobal(idContrato, idSeccion, revenues);
        } else {
            int i;
            ArrayList<FsPeriodoDTO> pers = new ArrayList<FsPeriodoDTO>();
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (i = 0; i < revenue.getPeriodos().length; ++i) {
                String[] periodosRev = revenue.getPeriodos()[i].split("-");
                FsPeriodoDTO periodo = new FsPeriodoDTO();
                periodo.setFechaInicio(periodosRev[0]);
                periodo.setFechaFin(periodosRev[1]);
                periodo.setIdSeccion(idSeccion);
                periodo.setIdContrato(idContrato);
                periodo.setTipo("REVENUE");
                this.dao.guardarPeridoMinimos(periodo);
                pers.add(periodo);
            }
            for (i = 0; i < revenue.getDatosRevenueBox().length; ++i) {
                for (int j = 0; j < pers.size(); ++j) {
                    TerminosRevenueDTO t = new TerminosRevenueDTO();
                    t.setIdPeriodo(((FsPeriodoDTO)pers.get(j)).getIdPeriodo());
                    for (TerminosPaisDTO categoria : categorias) {
                        if (!revenue.getDatosRevenueBox()[i][0].equals(categoria.getDescripcion())) continue;
                        t.setIdRelease(categoria.getIdPais());
                    }
                    t.setDdaPto(revenue.getDatosRevenueBox()[i][j * 2 + 1]);
                    t.setEstudioPto(revenue.getDatosRevenueBox()[i][j * 2 + 2]);
                    revenues.add(t);
                }
            }
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.CATEGORIA.getDesc());
            this.dao.guardarValoresRevBoxSeries(idContrato, revenues);
        }
    }

    public void eliminarRevenue(Long idContrato, String seccion) {
        this.dao.eliminarRevenue(idContrato, seccion);
    }

    public void elimnarRevenueGlobal(Long idContrato, String seccion) {
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        this.dao.eliminarRevenueGlobalMovies(idContrato, idSeccion);
    }

    public void eliminarRevenueBoxMovies(Long idContrato) {
        this.dao.eliminarRevenueBoxMovies(idContrato);
    }

    public void eliminarRevenueBoxSeries(Long idContrato) {
        this.dao.eliminarRevenueBoxSeries(idContrato);
    }

    public RevenueBoxGloDTO obtenerRevenueLibreria(Long idContrato, String seccion) {
        List revenues = this.dao.obtenerBoxOfficeRevenueDatos(idContrato, seccion, PeriodoTipos.REVENUE.getDesc());
        List minimos = this.dao.obtenerMinimosCategoriasBoxOffice(idContrato, seccion);
        List periodosAuxiliar = this.dao.obtenerPeriodos(idContrato, seccion, PeriodoTipos.REVENUE.getDesc());
        ArrayList<String> periodos = new ArrayList<String>();
        RevenueBoxGloDTO revenueData = new RevenueBoxGloDTO();
        for (TerminosAuxiliarDTO periodo : ListaUtilerias.safeList((List)periodosAuxiliar)) {
            periodos.add(periodo.getFechaInicio() + "-" + periodo.getFechaFin());
        }
        String tipoRevenue = this.obtenerTipoRevenue(idContrato, seccion);
        String tipoMinimo = this.minimo.obtenerTipoMinimo(idContrato, seccion);
        if (!MinimoTipos.CATEGORIA.equals((Object)MinimoTipos.getSeccion((String)tipoMinimo))) {
            revenues = null;
        }
        if (RevenueTipos.GLOBAL.equals((Object)RevenueTipos.getSeccion((String)tipoRevenue))) {
            revenues = null;
            revenueData.setRevenueBox(false);
            revenueData.setRevenueGlobal(true);
        } else {
            revenueData.setRevenueBox(true);
            revenueData.setRevenueGlobal(false);
        }
        RevenueSeccionDTO revenueBox = this.procesoRevenue(idContrato, minimos, revenues, periodos);
        revenueData.setDatosRevenueBox(revenueBox.getRevenue());
        revenueData.setPeriodos(revenueBox.getPeriodos());
        List revenueGlobal = this.dao.obtenerRevenueMoviesGlobal(idContrato, seccion);
        String[][] global = this.proceseoRevenueGlobal(revenueGlobal);
        revenueData.setDatosRevenueGlobal(global);
        return revenueData;
    }

    public RevenueSeccionDTO procesoRevenue(Long idContrato, List<TerminoMinimoDTO> minimos, List<TerminosAuxiliarDTO> revenues, List<String> periodos) {
        RevenueSeccionDTO revenue = new RevenueSeccionDTO();
        if (periodos == null || periodos.isEmpty()) {
            periodos.add(this.feesDao.fechaInicio(idContrato) + "-" + this.feesDao.fechaFin(idContrato));
        }
        if (minimos == null || minimos.size() == 0) {
            minimos = Arrays.asList(new TerminoMinimoDTO("MFTV/MFV"));
        }
        String[][] datos = new String[minimos.size()][periodos.size() * 2 + 3];
        for (int i = 0; i < ListaUtilerias.safeList(minimos).size(); ++i) {
            datos[i][0] = String.valueOf(minimos.get(i).getDesde());
            datos[i][1] = String.valueOf(minimos.get(i).getHasta());
            datos[i][2] = minimos.get(i).getCategoria();
            for (int j = 0; j < ListaUtilerias.safeList(revenues).size(); ++j) {
                if (!minimos.get(i).getId().equals(revenues.get(j).getId())) continue;
                for (int k = 0; k < periodos.size(); ++k) {
                    String fechaInicio = periodos.get(k).split("-")[0];
                    if (!fechaInicio.equals(revenues.get(j).getFechaInicio())) continue;
                    datos[i][k * 2 + 3] = revenues.get(j).getpDda();
                    datos[i][k * 2 + 4] = revenues.get(j).getpEstudio();
                }
            }
        }
        int cont = 0;
        for (int i = 0; i < datos.length; ++i) {
            if (datos[i][0] == null) continue;
            ++cont;
        }
        String[][] datos1 = new String[cont][periodos.size() * 2 + 3];
        for (int i = 0; i < datos.length; ++i) {
            if (datos[i][0] == null) continue;
            for (int j = 0; j < datos[0].length; ++j) {
                datos1[i][j] = datos[i][j];
            }
        }
        datos = datos1;
        String[] per = new String[periodos.size()];
        per = periodos.toArray(per);
        revenue.setPeriodos(per);
        revenue.setRevenue(datos);
        return revenue;
    }

    public void guardarRevenueBoxOfficeLibreria(Long idContrato, String seccion, RevenueBoxGloDTO revenue) {
        if (revenue != null) {
            Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
            ArrayList<FsPeriodoDTO> pers = new ArrayList<FsPeriodoDTO>();
            ArrayList<TerminosAuxiliarDTO> revenues = new ArrayList<TerminosAuxiliarDTO>();
            if (revenue.getPeriodos() != null && revenue.getDatosRevenueBox() != null && revenue.getDatosRevenueBox().length > 0 && revenue.getPeriodos().length > 0) {
                int i;
                for (i = 0; i < revenue.getPeriodos().length; ++i) {
                    String[] periodosExc = revenue.getPeriodos()[i].split("-");
                    FsPeriodoDTO periodo = new FsPeriodoDTO();
                    periodo.setFechaInicio(periodosExc[0]);
                    periodo.setFechaFin(periodosExc[1]);
                    periodo.setIdSeccion(idSeccion);
                    periodo.setIdContrato(idContrato);
                    periodo.setTipo(PeriodoTipos.REVENUE.getDesc());
                    this.dao.guardarPeridoMinimos(periodo);
                    pers.add(periodo);
                }
                for (i = 0; i < revenue.getDatosRevenueBox().length; ++i) {
                    for (int j = 0; j < pers.size(); ++j) {
                        String desde = revenue.getDatosRevenueBox()[i][0];
                        String hasta = revenue.getDatosRevenueBox()[i][1];
                        TerminosAuxiliarDTO aux = new TerminosAuxiliarDTO();
                        aux.setId(idContrato);
                        aux.setIdOpcionalA(idSeccion);
                        aux.setDesde(desde == null || desde.trim().equals("") ? "0" : desde);
                        aux.setHasta(hasta == null || hasta.trim().equals("") ? "0" : hasta);
                        aux.setNombre(revenue.getDatosRevenueBox()[i][2]);
                        Long idCategoria = this.dao.obtenerIdMinimoPorValores(aux);
                        TerminosAuxiliarDTO t = new TerminosAuxiliarDTO();
                        t.setId(idCategoria);
                        t.setIdOpcionalA(((FsPeriodoDTO)pers.get(j)).getIdPeriodo());
                        if (revenue.getDatosRevenueBox()[i][j * 2 + 3] != null) {
                            t.setpDda(revenue.getDatosRevenueBox()[i][j * 2 + 3]);
                        }
                        if (revenue.getDatosRevenueBox()[i][j * 2 + 4] != null) {
                            t.setpEstudio(revenue.getDatosRevenueBox()[i][j * 2 + 4]);
                        }
                        revenues.add(t);
                    }
                }
                this.dao.guardarRevenueLibreriaBoxOffice(revenues);
            }
        }
    }

    public void eliminarMinimosCategoriasBoxOffice(Long idContrato, String seccion) {
        this.dao.eliminarMinimosCategoriasBoxOffice(idContrato, seccion);
    }

    public String obtenerTipoRevenue(Long idContrato, String seccion) {
        String tipo = this.dao.obtenerTipoRevenue(idContrato, seccion);
        return tipo == null || tipo.trim().equals("") ? RevenueTipos.GLOBAL.getDesc() : tipo;
    }

    public void guardarRevenueLibreria(Long idContrato, String seccion, RevenueBoxGloDTO revenue) {
        Long idSeccion = this.dao.obtenerIdSeccion(idContrato, seccion);
        if (revenue.isRevenueGlobal()) {
            ArrayList<TerminosRevenueDTO> revenues = new ArrayList<TerminosRevenueDTO>();
            for (int i = 0; i < revenue.getDatosRevenueGlobal().length; ++i) {
                TerminosRevenueDTO t = new TerminosRevenueDTO();
                String[] fechas = revenue.getDatosRevenueGlobal()[i][0].split("-");
                t.setFechaInicio(fechas[0]);
                t.setFechaFin(fechas[1]);
                t.setDdaPto(revenue.getDatosRevenueGlobal()[i][1]);
                t.setEstudioPto(revenue.getDatosRevenueGlobal()[i][2]);
                revenues.add(t);
            }
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.GLOBAL.getDesc());
            this.dao.guardarValoresRevGlobal(idContrato, idSeccion, revenues);
        } else {
            this.dao.actualizaTipoRevenue(idSeccion, RevenueTipos.CATEGORIA.getDesc());
            this.guardarRevenueBoxOfficeLibreria(idContrato, seccion, revenue);
        }
    }
}

