/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.excelMapper.bos;

import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.constants.ExcelMapperDataType;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelEntityResult;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ExcelMapperTransform {
    private Logger logger = LoggerFactory.getLogger((String)"excelMapper");
    private static final String CELL_SEPARATOR = ",";
    @Autowired
    private ExcelMapperContext excelMapperContext;
    private BeanPopulator beanPopulator;

    @PostConstruct
    public void init() {
        this.beanPopulator = this.excelMapperContext.getBeanPopulator();
    }

    public <T> ExcelEntityResult<T> readExcelToObject(File stream, Class<T> c) throws ExcelMapperException {
        return this.readExcelToObject(stream, c.getName());
    }

    public <T> ExcelEntityResult<T> readExcelToObject(File stream, String idParse) throws ExcelMapperException {
        try {
            return this.readExcelToObject(new FileInputStream(stream), idParse);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
    }

    public <T> ExcelEntityResult<T> readExcelToObject(InputStream stream, String idParse) throws ExcelMapperException {
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper(idParse);
        ArrayList list = new ArrayList();
        ArrayList<String> errors = new ArrayList<String>();
        HashSet<Integer> rowsWithErrors = new HashSet<Integer>();
        ExcelEntityResult result = new ExcelEntityResult();
        try {
            Class<?> clzz = Class.forName(mapper.getClassName());
            Workbook wb = WorkbookFactory.create((InputStream)stream);
            Sheet sh = wb.getSheetAt(0);
            int init = mapper.getFirstRow() < 0 ? 0 : mapper.getFirstRow() - 1;
            Object zero = this.beanPopulator.initObject(clzz);
            for (int i = init; i <= sh.getLastRowNum(); ++i) {
                Row row = sh.getRow(i);
                Object target = this.beanPopulator.initObject(clzz);
                for (ExcelRule exRule : mapper.getRules()) {
                    this.logger.trace("To rule [{}]", (Object)exRule);
                    CellReference ref = new CellReference(exRule.getColumn());
                    Cell cell = row.getCell((int)ref.getCol());
                    try {
                        if (cell == null || cell.getCellType() == 3) continue;
                        this.asignaValorObject(exRule, cell, target);
                    }
                    catch (ExcelMapperException e) {
                        rowsWithErrors.add(i);
                        errors.add("In Row[" + (i - 1) + "]:" + e.getMessage());
                    }
                }
                if (zero.equals(target)) continue;
                list.add(target);
            }
            result.setErrorRows(this.calculateRowWithErrors(sh, rowsWithErrors));
        }
        catch (InvalidFormatException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (IOException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Error ", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE + mapper.getClassName());
        }
        result.setResult(list);
        result.setErrors(errors);
        return result;
    }

    public <T> ExcelEntityResult<T> readExcelToObject(String archivo, ExcelMapper mapper) throws ExcelMapperException {
        ExcelEntityResult result = new ExcelEntityResult();
        try {
            int init;
            FileInputStream file = new FileInputStream(new File(archivo));
            ArrayList list = new ArrayList();
            ArrayList errors = new ArrayList();
            HashSet<Integer> rowsWithErrors = new HashSet<Integer>();
            Class<?> claz = Class.forName(mapper.getClassName());
            Workbook wb = WorkbookFactory.create((InputStream)file);
            Sheet sh = wb.getSheetAt(0);
            for (int i = init = mapper.getFirstRow() < 0 ? 0 : mapper.getFirstRow() - 1; i <= sh.getLastRowNum(); ++i) {
                Row row = sh.getRow(i);
                Object zero = this.beanPopulator.initObject(claz);
                Iterator cellIterator = row.cellIterator();
                ArrayList<Cell> celdas = new ArrayList<Cell>();
                for (int cn = 0; cn < row.getLastCellNum(); ++cn) {
                    Cell cell = row.getCell(cn, Row.CREATE_NULL_AS_BLANK);
                    celdas.add(cell);
                }
                this.asignaValorArregloObject((ExcelRule)mapper.getRules().get(0), celdas, zero);
                list.add(zero);
            }
            result.setErrorRows(this.calculateRowWithErrors(sh, rowsWithErrors));
            file.close();
            result.setResult(list);
            result.setErrors(errors);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (InvalidFormatException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (IOException e) {
            this.logger.error("Error", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Error ", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE + mapper.getClassName());
        }
        return result;
    }

    private List<String> calculateRowWithErrors(Sheet sh, Set<Integer> errorIndexes) {
        ArrayList<String> rowsWithErrors = new ArrayList<String>();
        for (Integer i : errorIndexes) {
            Row row = sh.getRow(i.intValue());
            rowsWithErrors.add(this.rowToString(row));
        }
        return rowsWithErrors;
    }

    private String rowToString(Row row) {
        StringBuilder sb = new StringBuilder();
        Iterator cellIterator = row.cellIterator();
        while (cellIterator.hasNext()) {
            Cell cell = (Cell)cellIterator.next();
            cell.setCellType(1);
            sb.append(cell.getStringCellValue());
            sb.append(CELL_SEPARATOR);
        }
        return sb.toString();
    }

    private void asignaValorObject(ExcelRule exRule, Cell cell, Object target) throws ExcelMapperException {
        ExcelMapperDataType type = exRule.getType() == null ? ExcelMapperDataType.string : exRule.getType();
        switch (type) {
            case date: {
                try {
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getDateCellValue());
                }
                catch (Exception e) {
                    cell.setCellType(1);
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getStringCellValue().trim());
                }
                break;
            }
            case numeric: {
                try {
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getNumericCellValue());
                }
                catch (Exception e) {
                    cell.setCellType(1);
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getStringCellValue().trim());
                }
                break;
            }
            case bool: {
                try {
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getBooleanCellValue());
                }
                catch (Exception e) {
                    cell.setCellType(1);
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getStringCellValue().trim());
                }
                break;
            }
            default: {
                cell.setCellType(1);
                this.beanPopulator.setProperty(target, exRule.getAttribute(), cell.getStringCellValue().trim());
            }
        }
    }

    private void asignaValorArregloObject(ExcelRule exRule, List<Cell> cells, Object target) throws ExcelMapperException {
        ExcelMapperDataType type = exRule.getType() == null ? ExcelMapperDataType.string : exRule.getType();
        switch (type) {
            case numeric: {
                try {
                    ArrayList<Double> numeros = new ArrayList<Double>();
                    for (Cell c : cells) {
                        numeros.add(c.getNumericCellValue());
                    }
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), numeros);
                    break;
                }
                catch (Exception e) {
                    ArrayList<String> str = new ArrayList<String>();
                    for (Cell c : cells) {
                        c.setCellType(1);
                        str.add(c.getStringCellValue().trim());
                    }
                    break;
                }
            }
            case string: {
                try {
                    ArrayList<String> cadenas = new ArrayList<String>();
                    this.logger.debug(cells.toString());
                    for (Cell c : cells) {
                        c.setCellType(1);
                        cadenas.add(c.getStringCellValue().trim());
                    }
                    this.beanPopulator.setProperty(target, exRule.getAttribute(), cadenas);
                    break;
                }
                catch (Exception e) {
                    this.logger.error("Error {}", (Throwable)e);
                }
            }
        }
    }

    public <T> byte[] transformObjectToExcel(List<T> elements, Class<T> clase) throws ExcelMapperException, IOException {
        return this.transformObjectToExcel(elements, clase.getName(), clase);
    }

    public <T> byte[] transformObjectToExcel(List<T> elements, String idParse, Class<T> clase) throws ExcelMapperException, IOException {
        this.logger.debug("idParse [{}] class [{}]", (Object)idParse, (Object)clase.getName());
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper(idParse);
        return this.transformObjectToExcel(elements, mapper, clase);
    }

    public <T> byte[] transformObjectToExcel(List<T> elements, ExcelMapper mapper, Class<T> clase) throws ExcelMapperException, IOException {
        this.logger.debug("mapper class [{}]  mapper id[{}]", (Object)mapper.getClassName(), (Object)mapper.getId());
        if (!mapper.getClassName().equals(clase.getName())) {
            throw new ExcelMapperException(ExcelMapperException.ERROR_MAPPER_CLASS, new Object[]{mapper.getClassName(), clase.getName()});
        }
        int size = elements.size() / 3 < 1 ? elements.size() : elements.size() / 3;
        SXSSFWorkbook workbook = new SXSSFWorkbook(size);
        Sheet sheet = workbook.createSheet();
        int r = 0;
        Row row = sheet.createRow(r++);
        for (ExcelRule exRule : mapper.getRules()) {
            Cell cell = row.createCell(CellReference.convertColStringToIndex((String)exRule.getColumn()));
            cell.setCellValue(exRule.getHeader());
        }
        for (Object element : elements) {
            Row rowE = sheet.createRow(r++);
            for (ExcelRule exRule : mapper.getRules()) {
                try {
                    Cell cell = rowE.createCell(CellReference.convertColStringToIndex((String)exRule.getColumn()));
                    cell = this.asignaValorCell(exRule, cell, element);
                    cell = this.asignaStyleCell(exRule, cell, workbook);
                }
                catch (Exception e) {
                    this.logger.error("Error", (Throwable)e);
                }
            }
        }
        sheet.autoSizeColumn(100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        workbook.write((OutputStream)baos);
        return baos.toByteArray();
    }

    private Cell asignaValorCell(ExcelRule exRule, Cell cell, Object target) throws ExcelMapperException {
        ExcelMapperDataType type = exRule.getType() == null ? ExcelMapperDataType.string : exRule.getType();
        Object temp = this.beanPopulator.getProperty(target, exRule.getAttribute());
        this.logger.info("Setting [{}] type [{}] value [{}]", new Object[]{exRule.getAttribute(), type, temp});
        if (temp != null) {
            switch (type) {
                case date: {
                    try {
                        if (temp == null) break;
                        cell.setCellValue((Date)temp);
                    }
                    catch (Exception e) {
                        cell.setCellValue(temp.toString());
                    }
                    break;
                }
                case numeric: {
                    try {
                        if (temp != null) {
                            double d = Double.parseDouble(temp.toString());
                            cell.setCellValue(d);
                            break;
                        }
                        cell.setCellValue(0.0);
                    }
                    catch (Exception e) {
                        cell.setCellValue(temp.toString());
                    }
                    break;
                }
                case bool: {
                    try {
                        if (temp != null) {
                            cell.setCellValue(((Boolean)temp).booleanValue());
                            break;
                        }
                        cell.setCellValue("");
                    }
                    catch (Exception e) {
                        cell.setCellValue(temp.toString());
                    }
                    break;
                }
                default: {
                    cell.setCellValue(temp.toString());
                }
            }
        }
        return cell;
    }

    private Cell asignaStyleCell(ExcelRule exRule, Cell cell, SXSSFWorkbook workbook) throws ExcelMapperException {
        ExcelMapperDataType type = exRule.getType() == null ? ExcelMapperDataType.string : exRule.getType();
        switch (type) {
            case date: {
                CellStyle dateStyle = workbook.createCellStyle();
                DataFormat df = workbook.createDataFormat();
                String dateFormat = this.excelMapperContext.getDateFormat();
                dateFormat = exRule.getDateFormat() != null ? exRule.getDateFormat() : dateFormat;
                dateStyle.setDataFormat(df.getFormat(dateFormat));
                cell.setCellStyle(dateStyle);
                break;
            }
            case numeric: {
                break;
            }
            case bool: {
                break;
            }
        }
        return cell;
    }

    public byte[] transformMapToExcel(List<HashMap> elements) throws ExcelMapperException, IOException {
        byte[] stream = null;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        if (elements != null && !elements.isEmpty()) {
            int r = 0;
            XSSFRow row = sheet.createRow(r);
            HashMap header = elements.get(0);
            int hc = 0;
            for (String key : header.keySet()) {
                Cell cell = row.createCell(hc);
                cell.setCellValue(key);
                ++hc;
            }
            ++r;
            for (HashMap body : elements) {
                row = sheet.createRow(r);
                int bc = 0;
                for (Map.Entry entry : body.entrySet()) {
                    Cell cell = row.createCell(bc);
                    cell.setCellValue(entry.getValue().toString());
                    ++bc;
                }
                ++r;
            }
            for (int i = 0; i < header.size(); ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        workbook.write((OutputStream)baos);
        stream = baos.toByteArray();
        return stream;
    }

    public byte[] transformMapToExcel2(List<List<String>> datos, List<String> encabezados) throws ExcelMapperException, IOException {
        byte[] stream = null;
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFSheet sheet = workbook.createSheet();
        if (datos != null && !datos.isEmpty()) {
            XSSFRow rowE = sheet.createRow(0);
            for (int j = 0; j < encabezados.size(); ++j) {
                rowE.createCell(j).setCellValue(encabezados.get(j));
            }
            for (int i = 0; i < datos.size(); ++i) {
                rowE = sheet.createRow(i + 1);
                for (int j = 0; j < datos.get(i).size(); ++j) {
                    rowE.createCell(j).setCellValue(datos.get(i).get(j));
                }
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        workbook.write((OutputStream)baos);
        stream = baos.toByteArray();
        return stream;
    }

    public boolean validateHeader(File stream, String idParse) throws ExcelMapperException {
        boolean respuesta = true;
        try {
            ExcelMapper mapper = this.excelMapperContext.getExcelMapper(idParse);
            List rules = mapper.getRules();
            Workbook wb = WorkbookFactory.create((InputStream)new FileInputStream(stream));
            Sheet sh = wb.getSheetAt(0);
            Row row = sh.getRow(0);
            this.logger.debug("No. Cells : [{}] No. Rules : [{}]", (Object)row.getLastCellNum(), (Object)rules.size());
            if (row.getLastCellNum() == rules.size()) {
                for (int i = 0; i < row.getLastCellNum(); ++i) {
                    String header;
                    Cell cell = row.getCell(i);
                    String value = cell.getStringCellValue();
                    if (value.equals(header = ((ExcelRule)rules.get(i)).getHeader())) continue;
                    respuesta = false;
                }
            } else {
                respuesta = false;
            }
        }
        catch (InvalidFormatException e) {
            this.logger.error("Error [{}]", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        catch (IOException e) {
            this.logger.error("Error [{}]", (Throwable)e);
            throw new ExcelMapperException(ExcelMapperException.ERROR_READING_EXCEL_FILE);
        }
        return respuesta;
    }

    public <T> byte[] transformObjectToExcel(T[][] elements, ExcelMapper mapper, Class<T> clase) throws ExcelMapperException, IOException {
        this.logger.info("mapper class [{}]  mapper id[{}]", (Object)mapper.getClassName(), (Object)mapper.getId());
        int size = elements[0].length / 3 < 1 ? elements[0].length : elements[0].length / 3;
        SXSSFWorkbook workbook = new SXSSFWorkbook(size);
        Sheet sheet = workbook.createSheet();
        int r = 0;
        int c = 0;
        LinkedList auxiliar = new LinkedList(mapper.getRules());
        ExcelRule first = (ExcelRule)auxiliar.getFirst();
        for (int i = 0; i < first.getHeaders().size(); ++i) {
            Row row = sheet.createRow(r++);
            for (ExcelRule exRule : mapper.getRules()) {
                Cell cell = row.createCell(CellReference.convertColStringToIndex((String)exRule.getColumn()));
                cell.setCellValue((String)exRule.getHeaders().get(i));
            }
        }
        for (T[] element : elements) {
            Row rowE = sheet.createRow(r++);
            for (ExcelRule exRule : mapper.getRules()) {
                try {
                    ExcelMapperDataType type = exRule.getType() == null ? ExcelMapperDataType.string : exRule.getType();
                    Cell cell = rowE.createCell(CellReference.convertColStringToIndex((String)exRule.getColumn()));
                    T temp = element[c++];
                    if (temp == null) {
                        cell.setCellValue("");
                    } else {
                        switch (type) {
                            case date: {
                                try {
                                    if (temp == null) break;
                                    cell.setCellValue((Date)temp);
                                }
                                catch (Exception e) {
                                    cell.setCellValue(temp.toString());
                                }
                                break;
                            }
                            case numeric: {
                                try {
                                    if (temp == null) break;
                                    double d = Double.parseDouble(temp.toString());
                                    cell.setCellValue(d);
                                }
                                catch (Exception e) {
                                    cell.setCellValue(temp.toString());
                                }
                                break;
                            }
                            case bool: {
                                try {
                                    if (temp == null) break;
                                    cell.setCellValue(((Boolean)temp).booleanValue());
                                }
                                catch (Exception e) {
                                    cell.setCellValue(temp.toString());
                                }
                                break;
                            }
                            default: {
                                cell.setCellValue(temp.toString());
                            }
                        }
                    }
                    cell = this.asignaStyleCell(exRule, cell, workbook);
                }
                catch (Exception e) {
                    this.logger.error("Error", (Throwable)e);
                }
            }
            c = 0;
        }
        sheet.autoSizeColumn(100);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        workbook.write((OutputStream)baos);
        return baos.toByteArray();
    }
}

