/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.amortizacion.presupuesto.bo;

import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dao.ReporteAmortVsPptoDAO;
import com.mx.dla.dda.reporte.amortizacion.presupuesto.dto.ReporteAmortizacionVsPresupuestoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteAmortvsPptoBO
extends BaseBO {
    @Autowired
    private ReporteAmortVsPptoDAO reporAmortPptodao;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private BeanPopulator beanPopulator;

    public List<ReporteAmortizacionVsPresupuestoDTO> obtenReporteAmortPpto(Long mes, Long annio) throws Exception {
        List reporteAmortPpto = null;
        try {
            reporteAmortPpto = this.reporAmortPptodao.obtenerReporteAmortPpto(mes, annio);
            this.logger.debug("obtenReporteAmortPpto - [{}]", (Object)reporteAmortPpto);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el Reporte de Amortizacion_Ppto - ", ex);
        }
        return reporteAmortPpto;
    }

    public byte[] descargaArchivoReporte(String mes) throws ExcelMapperException, IOException {
        ArrayList<ReporteAmortizacionVsPresupuestoDTO> rowReporte = new ArrayList<ReporteAmortizacionVsPresupuestoDTO>();
        try {
            if (rowReporte == null || rowReporte.isEmpty()) {
                rowReporte = new ArrayList();
                rowReporte.add(this.beanPopulator.initObject(ReporteAmortizacionVsPresupuestoDTO.class));
            }
            this.logger.debug("Descargar archivo Reporte... se han  obtenido [{}]", (Object)rowReporte.size());
        }
        catch (Exception ex) {
            this.logger.error("Error - descargaArchivoReporte. al buscar contenido para descargar archivo...");
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(rowReporte, "reporteAmortizacion", ReporteAmortizacionVsPresupuestoDTO.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public byte[] descargaObjReporte(List<ReporteAmortizacionVsPresupuestoDTO> inforowReporte) throws TransaccionException {
        for (ReporteAmortizacionVsPresupuestoDTO c : inforowReporte) {
            this.logger.debug("[{}]", (Object)c);
        }
        byte[] barchivo = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("reporteAmortizacionPpto");
        try {
            barchivo = this.excelMapperTransform.transformObjectToExcel(inforowReporte, mapper, ReporteAmortizacionVsPresupuestoDTO.class);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el excel.", ex);
        }
        return barchivo;
    }
}

