$().ready(function() {
	//console.log('Iniciando pantalla');
	$("#loadingDiv").hide();
	$("#labelDiv").hide();
});

function callActionAjax(actionRoute, jsonActionParameter, functionProcessor){
	
	 $.ajax({
	     url: contextPath + actionRoute,
	     type: 'POST',
	     data:  jsonActionParameter, 
		 dataType: "json",
	     success:function(response){ 
	    	 functionProcessor(response);    
	     },
	     error:function(jqXhr, textStatus, errorThrown){
	         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
	     }
	 });
	
}

function procesaDetalleContratos(jsonData) {
	//console.info(JSON.stringify(jsonData));
	
	var contratos = jsonData.detalleContratos;
	
	if(contratos.length > 0){

		$("#campoContrato").prop( "disabled", false);
		$('#campoContrato').find('option').remove();
		$("#campoContrato").append('<option value="">Todos</option>');
		$("#botonConsultar").prop( "disabled", false);
		//$("#botonNotificar").prop( "disabled", false);
		//$("#botonExportar").prop( "disabled", false);
		
		for(var i = 0; i < contratos.length; i++) {
			cnt = contratos[i];
			//console.log('total: ' + contratos.length);
			//console.log(''+cnt.idContrato);
			$("#campoContrato").append('<option value="' + cnt.idContrato + '">' + cnt.numeroContrato + '</option>');
		}
		
		
		
	}else {
		$("#campoContrato").prop( "disabled", true);
		$("#botonConsultar").prop( "disabled", true);
		$("#botonExportar").prop( "disabled", true);
		$("#botonNotificar").prop( "disabled", true);
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:[], colModel:[] ,data: [], datatype: 'local'}).trigger('reloadGrid');
		showError("El estudio seleccionado no tiene contratos asociados");
		console.log('Es nulo');
	}
	
}

function llamaObtenerDetalleContratos() {
	
	
	var jsonString = '{"idEstudio" : "' + $("#campoEstudio").val()+ '", "fechaInicio":"01/01/2021", "fechaFin":"01/01/2022"}';
	//console.log(jsonString);
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/reporte/reportePago/detalleContrato", stringJson, procesaDetalleContratos);
    
}

var infoReporte = [];

function procesaReportePrincipal(jsonData) {

	console.info(JSON.stringify(jsonData));
	
	var colNamesVar = [
		'titulo',
		'idBroadview',
		'fechaInicio',
		'fechaFin',
		'costo',
		'anio',
		'meses'
		];
	var colModelVar= [{name:'titulo',index:'titulo', width:300, align:"left", sortable:false},
					  {name:'idBroadview',index:'idBroadview', width:80, frozen : true, sortable:false},
	                  {name:'fechaInicio',index:'fechaInicio', width:150, align:"right", sortable:false},
	                  {name:'fechaFin',index:'fechaFin', width:150, align:"right", sortable:false},
	                  {name:'costo',index:'costo', width:80, align:"right", sortable:false},
	                  {name:'anio',index:'anio', width:40, align:"right", sortable:false},
	                  {name:'meses',index:'meses', width:40, align:"right", sortable:false}
	                  ];
	
	var colModelNames = [
		'titulo',
		'idBroadview',
		'fechaInicio',
		'fechaFin',
		'costo',
		'anio',
		'meses'];
	
	var datos = jsonData.reporte;
	var header = jsonData.encabezado;
	
	var imarcar = 0;
	var porMarcar = [];
	var patron = /^[A-Z]{4}\d{5}[A-Z]$/;
	
	$("#reporteTableDiv").show();
	if(datos.length > 0) {
		
		/*for(var i = 0; i < datos.length; i++){
			//console.log(datos[i].concepto);
			if(patron.test(datos[i].concepto))
				porMarcar[imarcar++] = (i + 1);
		}*/
		
		//console.log("por marcar : " + porMarcar);
		
		$("#botonExportar").prop( "disabled", false);
		
		$("#botonNotificar").prop( "disabled", false);
		jQuery("#reporteTable").jqGrid({
			datatype: "local",
		   	colNames:colNamesVar,
		   	colModel:colModelVar,
		   	width: '1000',
		    height: '300',
		    rowNum: 999999,
		    autowidth: false,
		    shrinkToFit: false,
		   	multiselect: false,
		   	loadComplete: function(){		   		 		

		   	}
		});
		
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:colNamesVar, colModel:colModelVar ,data: datos, datatype: 'local'}).trigger('reloadGrid');
	
		for(var i = 0; i < colModelNames.length; i++) {
			jQuery("#reporteTable").jqGrid('setLabel', colModelNames[i], header[i]);
		}
		
		jQuery("#reporteTable").jqGrid('setRowData', 1, false, 'totalContratoRowClass');
		
		for(var i = 0; i < porMarcar.length; i++) {
			jQuery("#reporteTable").jqGrid('setRowData', porMarcar[i], false, 'contratoRowClass');
		}
		
		 jQuery( "#reporteTable").jqGrid('setFrozenColumns');
		
		 infoReporte = datos;
		 
	}else {
		showError("El contrato seleccionado no tiene titulos asociados.");
		console.log('Es nulo');
		jQuery('#reporteTable').jqGrid('clearGridData').jqGrid('setGridParam', {colNames:colNamesVar, colModel:colModelVar ,data: datos, datatype: 'local'}).trigger('reloadGrid');
		$("#botonExportar").prop( "disabled", true);
		$("#botonNotificar").prop( "disabled", true);
		$("#labelDiv").hide();
	}
	$("#loadingDiv").hide();

}

function colocaFechaFin(){
	
	var fechaInicio = new Date($("#campoFechaInicio").val());
	
	var cdia = '';
	var cmes = '';
	
	if(fechaInicio != null) {
		cmes = fechaInicio.getMonth() < 10 ? '0' : '';
		cdia = fechaInicio.getDate() < 10 ? '0' : '';
	}
	
	$("#campoFechaFin").val( cmes + (fechaInicio.getMonth() + 1) + '/'+ cdia + fechaInicio.getDate() + '/' + (fechaInicio.getFullYear() + 1));
}

function llamaReporteInfoAction(){ //Funcion de boton Consultar
	$("#loadingDiv").show();
	textoLabel();
	$("#labelDiv").show();
	$("#reporteTableDiv").hide();
	var jsonString = '{"idCon" : "' + $("#campoContrato").val() + '", "fechaInicio":"01/01/2021", "fechaFin":"01/01/2022", "idEstudio":"'+ $("#campoEstudio").val() +'"}'; 
	var stringJson = JSON.parse(jsonString);
    callActionAjax( "/admin/reporteContingencia/reporteContInf", stringJson, procesaReportePrincipal);
}

function descargarReporteEnExcel() {
	
	//console.log(JSON.stringify(infoReporte));
	
	//var url = contextPath +'/contrato/reportePago/reportePagoExcel.action?idCon=' + $("#campoContrato").val() + '&infoReporte=' + infoReporte;
	var url = contextPath +'/admin/reporteContingencia/reporteContingenciaExcel.action?idCon=' + $("#campoContrato").val() + '&idEstudio=' + $("#campoEstudio").val() + '&fechaInicio=01/01/2000';
   	window.open(url);
}

function textoLabel(){
	const str2 = $("#campoContrato option:selected").text();
	console.log("hola" + str2)
	if(str2.endsWith('A')){
		$("#tipoContrato").text("Contrato Addendum");	
	} else {
		if(str2.endsWith('O')){
			$("#tipoContrato").text("Contrato Original");
		} else {
			if(str2.endsWith('V')){
				$("#tipoContrato").text("Contrato Virtual");
			} else {
				$("#tipoContrato").text("Contrato Enmienda");
			}
		}
	}
	
}

function notificarSAP(){
	var jsonString = '{"idCon" : "' + $("#campoContrato").val() + '", "fechaInicio":"01/01/2021", "fechaFin":"01/01/2022", "idEstudio":"'+ $("#campoEstudio").val() +'"}'; 
	var stringJson = JSON.parse(jsonString);
	const str2 = $("#campoContrato option:selected").text();
	if(str2.endsWith('A') || str2.endsWith('O') || str2.endsWith('V')){
	    $.ajax({
		     url: 'http://localhost:5000/DDA_CRN_Exhibicion/servicio',
		     type: 'GET',
			 dataType: "json",
		     success:function(response){ 
		    	 console.log("Servicio ejecutado correctamente "); 
		     },
		     error:function(jqXhr, textStatus, errorThrown){
		         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
		     }
		 });
	} else {
		$.ajax({
		     url: 'http://localhost:5000/DDA_CRN_ClienteSAP/servicioEnmienda',
		     type: 'GET',
			 dataType: "json",
		     success:function(response){ 
		    	 console.log("Servicio ejecutado correctamente "); 
		     },
		     error:function(jqXhr, textStatus, errorThrown){
		         console.error("Error: " + textStatus + " ::: " + errorThrown + " ::: " + jqXhr);
		     }
		 });
	}
 	showMessage("Se a ejecutado el prodeso de Notificacion SAP");
}

