package com.mx.dla.dda.reporte.cpreview;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.testng.annotations.Test;

import com.mx.dla.dda.common.test.BaseDaoTest;
import com.mx.dla.dda.reporte.cpview.daos.ReporteCostPerViewDAO;
import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesDetalleDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CargaVisualizacionesPrincipalDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioAnualDatosDTO;
import com.mx.dla.dda.reporte.cpview.dtos.CostPerViewEstudioMensualDatosDTO;

public class ReporteCPreview extends BaseDaoTest {

	@Autowired
	private ReporteCostPerViewDAO reporteCostPeerReviewDAO;

	@Test(enabled = false)
	public void obtenerCostPeerReviewMensualDatosTest() throws IllegalArgumentException, IllegalAccessException {
		List<CostPerViewEstudioMensualDatosDTO> response = reporteCostPeerReviewDAO.obtenerCostPerViewMensualDatosEstudioNivel(6L, 2017L);

		for (CostPerViewEstudioMensualDatosDTO item : response) {
			String[] row = item.getFieldsAsRow();
			for (String value : row)
				logger.info("{}", value);
		}

		logger.info("{}", response);
	}
	
	@Test(enabled = false)
	public void obtenerCostPerViewDiciembreDatosTest() throws IllegalArgumentException, IllegalAccessException {
		List<CostPerViewEstudioMensualDatosDTO> response = reporteCostPeerReviewDAO.obtenerCostPerViewDiciembreDatosEstudioNivel(2017L); 

		for (CostPerViewEstudioMensualDatosDTO item : response) {
			String[] row = item.getFieldsAsRow();
			for (String value : row)
				logger.info("{}", value);
		}

		logger.info("{}", response);
	}

	@Test(enabled = false)
	public void obtenerCostPeerReviewAnualDatosTest() throws IllegalArgumentException, IllegalAccessException {
		List<CostPerViewEstudioAnualDatosDTO> responses = reporteCostPeerReviewDAO.obtenerCostPerViewAnualDatosEstudioNivel(2013L, 2017L, 6L,
		        "2013 AS ANIO_0 , 2014 AS ANIO_1 , 2015 AS ANIO_2 , 2016 AS ANIO_3 , 2017 AS ANIO_4");

		for (CostPerViewEstudioAnualDatosDTO item : responses) {
			String[] row = item.getFieldsAsRow();
			for (String value : row)
				logger.info("{}", value);
		}
		logger.info("{}", responses);
	}

	@Test(enabled = false)
	public void obtenerVisualizacionesPrincipalTest() throws IllegalArgumentException, IllegalAccessException {
		List<CargaVisualizacionesPrincipalDTO> responses = reporteCostPeerReviewDAO.obtenerVisualizacionesPrincipal(7L, 2017L);

		for (CargaVisualizacionesPrincipalDTO item : responses) {
			logger.info("{}", item);
		}
	}

	@Test(enabled = false)
	public void obtenerVisualizacionesDetalleTest() throws IllegalArgumentException, IllegalAccessException {
		List<CargaVisualizacionesDetalleDTO> responses = reporteCostPeerReviewDAO.obtenerVisualizacionesDetalle(7L, 2017L);

		for (CargaVisualizacionesDetalleDTO item : responses) {
			logger.info("{}", item);
		}
	}

}
