/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.ng.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.StrutsStatics;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.dispatcher.ng.ExecuteOperations;
import org.apache.struts2.dispatcher.ng.InitOperations;
import org.apache.struts2.dispatcher.ng.PrepareOperations;
import org.apache.struts2.dispatcher.ng.filter.FilterHostConfig;
import org.apache.struts2.dispatcher.ng.filter.StrutsPrepareFilter;

public class StrutsExecuteFilter
implements StrutsStatics,
Filter {
    protected PrepareOperations prepare;
    protected ExecuteOperations execute;
    protected FilterConfig filterConfig;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    protected synchronized void lazyInit() {
        if (this.execute == null) {
            InitOperations init = new InitOperations();
            Dispatcher dispatcher = init.findDispatcherOnThread();
            init.initStaticContentLoader(new FilterHostConfig(this.filterConfig), dispatcher);
            this.prepare = new PrepareOperations(dispatcher);
            this.execute = new ExecuteOperations(dispatcher);
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.excludeUrl(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.execute == null) {
            this.lazyInit();
        }
        ActionMapping mapping = this.prepare.findActionMapping(request, response);
        Integer recursionCounter = (Integer)request.getAttribute("__cleanup_recursion_counter");
        if (mapping == null || recursionCounter > 1) {
            boolean handled = this.execute.executeStaticResourceRequest(request, response);
            if (!handled) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            this.execute.executeAction(request, response, mapping);
        }
    }

    private boolean excludeUrl(HttpServletRequest request) {
        return request.getAttribute(StrutsPrepareFilter.REQUEST_EXCLUDED_FROM_ACTION_MAPPING) != null;
    }

    public void destroy() {
        this.prepare = null;
        this.execute = null;
        this.filterConfig = null;
    }
}

