/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContextException;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.mapping.AbstractEndpointMapping;

public abstract class AbstractMapBasedEndpointMapping
extends AbstractEndpointMapping {
    private boolean lazyInitEndpoints = false;
    private boolean registerBeanNames = false;
    private final Map<String, Object> endpointMap = new HashMap<String, Object>();
    private Map<String, Object> temporaryEndpointMap = new HashMap<String, Object>();

    public void setLazyInitEndpoints(boolean lazyInitEndpoints) {
        this.lazyInitEndpoints = lazyInitEndpoints;
    }

    public final void setRegisterBeanNames(boolean registerBeanNames) {
        this.registerBeanNames = registerBeanNames;
    }

    public final void setEndpointMap(Map<String, Object> endpointMap) {
        this.temporaryEndpointMap.putAll(endpointMap);
    }

    public void setMappings(Properties mappings) {
        for (Map.Entry<Object, Object> entry : mappings.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            this.temporaryEndpointMap.put((String)entry.getKey(), entry.getValue());
        }
    }

    protected abstract boolean validateLookupKey(String var1);

    protected abstract String getLookupKeyForMessage(MessageContext var1) throws Exception;

    @Override
    protected final Object getEndpointInternal(MessageContext messageContext) throws Exception {
        String key = this.getLookupKeyForMessage(messageContext);
        if (!StringUtils.hasLength((String)key)) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up endpoint for [" + key + "]"));
        }
        return this.lookupEndpoint(key);
    }

    protected Object lookupEndpoint(String key) {
        return this.endpointMap.get(key);
    }

    protected void registerEndpoint(String key, Object endpoint) throws BeansException {
        Object mappedEndpoint = this.endpointMap.get(key);
        if (mappedEndpoint != null) {
            throw new ApplicationContextException("Cannot map endpoint [" + endpoint + "] on registration key [" + key + "]: there's already endpoint [" + mappedEndpoint + "] mapped");
        }
        if (!this.lazyInitEndpoints && endpoint instanceof String) {
            String endpointName = (String)endpoint;
            endpoint = this.resolveStringEndpoint(endpointName);
        }
        if (endpoint == null) {
            throw new ApplicationContextException("Could not find endpoint for key [" + key + "]");
        }
        this.endpointMap.put(key, endpoint);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Mapped key [" + key + "] onto endpoint [" + endpoint + "]"));
        }
    }

    @Override
    protected final void initApplicationContext() throws BeansException {
        super.initApplicationContext();
        for (String key : this.temporaryEndpointMap.keySet()) {
            Object endpoint = this.temporaryEndpointMap.get(key);
            if (!this.validateLookupKey(key)) {
                throw new ApplicationContextException("Invalid key [" + key + "] for endpoint [" + endpoint + "]");
            }
            this.registerEndpoint(key, endpoint);
        }
        this.temporaryEndpointMap = null;
        if (this.registerBeanNames) {
            String[] beanNames;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Looking for endpoint mappings in application context: [" + this.getApplicationContext() + "]"));
            }
            for (String beanName : beanNames = this.getApplicationContext().getBeanDefinitionNames()) {
                String[] aliases;
                if (this.validateLookupKey(beanName)) {
                    this.registerEndpoint(beanName, beanName);
                }
                for (String aliase : aliases = this.getApplicationContext().getAliases(beanName)) {
                    if (!this.validateLookupKey(aliase)) continue;
                    this.registerEndpoint(aliase, beanName);
                }
            }
        }
    }
}

