/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.transport.http.AbstractHttpSenderConnection;

public class HttpUrlConnection
extends AbstractHttpSenderConnection {
    private final HttpURLConnection connection;

    protected HttpUrlConnection(HttpURLConnection connection) {
        Assert.notNull((Object)connection, (String)"connection must not be null");
        this.connection = connection;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    @Override
    public void onClose() {
        this.connection.disconnect();
    }

    @Override
    public URI getUri() throws URISyntaxException {
        return new URI(StringUtils.replace((String)this.connection.getURL().toString(), (String)" ", (String)"%20"));
    }

    @Override
    public void addRequestHeader(String name, String value) throws IOException {
        this.connection.addRequestProperty(name, value);
    }

    @Override
    protected OutputStream getRequestOutputStream() throws IOException {
        return this.connection.getOutputStream();
    }

    @Override
    protected void onSendAfterWrite(WebServiceMessage message) throws IOException {
        this.connection.connect();
    }

    @Override
    protected long getResponseContentLength() throws IOException {
        return this.connection.getContentLength();
    }

    @Override
    public Iterator<String> getResponseHeaderNames() throws IOException {
        String headerName;
        HashSet<String> headerNames = new HashSet<String>();
        int i = 1;
        while (StringUtils.hasLength((String)(headerName = this.connection.getHeaderFieldKey(i)))) {
            headerNames.add(headerName);
            ++i;
        }
        return headerNames.iterator();
    }

    @Override
    public Iterator<String> getResponseHeaders(String name) throws IOException {
        Map<String, List<String>> mapHeader = this.connection.getHeaderFields();
        List<String> listHeaderValues = mapHeader.get(name);
        if (listHeaderValues == null) {
            return Collections.emptyList().iterator();
        }
        return listHeaderValues.iterator();
    }

    @Override
    protected int getResponseCode() throws IOException {
        return this.connection.getResponseCode();
    }

    @Override
    protected String getResponseMessage() throws IOException {
        return this.connection.getResponseMessage();
    }

    @Override
    protected InputStream getRawResponseInputStream() throws IOException {
        if (this.connection.getResponseCode() / 100 != 2) {
            return this.connection.getErrorStream();
        }
        return this.connection.getInputStream();
    }
}

