/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.amortizacion.bos;

import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TituloGridBO;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ParamCalcAmortCntDTO;
import com.mx.dla.dda.contrato.ws.amortizacioncontrato.ResponseCalcAmortCntDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AmortizacionBO
extends BaseBO {
    @Autowired
    private AmortizacionDAO amortizacionDAO;
    @Autowired
    private TituloGridBO tituloGridBO;
    @Autowired
    protected ListaDAO listaDAO;
    @Autowired
    private TituloDmDAO tituloDmDAO;
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;

    public Lista buscarListaActual(ContratoDTO c) {
        return this.listaDAO.buscarListaActual(c.getIdContrato(), "T");
    }

    public List<Titulo> busqueda(ContratoDTO c, Lista lista, Titulo t) throws TituloException {
        Integer oc = this.amortizacionDAO.getContratoProceso(c.getIdContrato());
        this.logger.debug("Recarga amortizacion {}", (Object)oc);
        if (oc != null && oc != 0) {
            this.calculaAmortizacionTodosLosTitulos(c.getIdContrato(), lista.getIdLista(), false, new ArrayList<Long>(), "T");
            this.amortizacionDAO.updateContratoProceso(c.getIdContrato(), Integer.valueOf(0));
        }
        return this.tituloGridBO.busqueda(t, true, "T");
    }

    public List<Titulo> busquedaDetalle(Titulo t) throws TituloException {
        return this.tituloGridBO.busquedaDetalle(t, true, "T");
    }

    public void calculaAmortizacionTodosLosTitulos(Long idContrato, Long idLista, boolean parcial, List<Long> idTitulos, String prefix) {
        try {
            Long totalT = this.tituloDmDAO.cuentaTitulosPorListaYDescTitulo(idLista, null, prefix);
            this.logger.debug("Total Titulos [{}]", (Object)totalT);
            if (totalT != 0L) {
                ParamCalcAmortCntDTO req = new ParamCalcAmortCntDTO();
                req.setIdContrato(idContrato.toString());
                this.logger.debug("Request Calculo de amortizacion [{}]", (Object)req);
                DLARestClient cleinteGeneraAmortizacion = this.dlaRestClientFactory.getClient(DLARestServices.GENERA_AMORTIZACION2);
                ResponseCalcAmortCntDTO resp = cleinteGeneraAmortizacion.get(req, ResponseCalcAmortCntDTO.class);
                this.logger.debug("Response Calculo de amortizacion [{}]", (Object)resp);
            }
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
        }
    }
}

