/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.common.bos;

import com.mx.dla.dda.contrato.common.daos.DocumentoDAO;
import com.mx.dla.dda.contrato.common.dtos.DocumentoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DocumentoBO
extends BaseBO {
    @Autowired
    private DocumentoDAO documentoDAO;
    @Value(value="${uri.file.store}")
    private String uri;

    public DocumentoDTO insertarDocumento(File file, String name, String expediente, Long idContrato) throws IOException {
        DocumentoDTO doc = new DocumentoDTO();
        doc.setExpediente(expediente);
        doc.setIdContrato(idContrato);
        doc.setNombre(name);
        doc.setRutaServidor(this.uri);
        this.logger.debug("URI file system {}", (Object)this.uri);
        this.logger.debug("Doc  to insert {}", (Object)doc);
        this.documentoDAO.insertarDocumento(doc);
        File destFile = new File(this.uri + doc.getIdContratoDocto());
        FileUtils.copyFile((File)file, (File)destFile);
        this.logger.debug("file save correctly {}", (Object)name);
        return doc;
    }

    public DocumentoDTO remplazarDocumento(File file, String name, String expediente, Long idContrato, Long idDoc) throws IOException {
        this.logger.debug("Remplzar {}", (Object)idDoc);
        DocumentoDTO doc = new DocumentoDTO();
        doc.setExpediente(expediente);
        doc.setIdContrato(idContrato);
        doc.setNombre(name);
        doc.setRutaServidor(this.uri);
        doc.setIdContratoDocto(idDoc);
        this.logger.debug("URI file system {}", (Object)this.uri);
        this.logger.debug("Doc  to insert {}", (Object)doc);
        this.documentoDAO.updateDocumento(doc);
        File destFile = new File(this.uri + doc.getIdContratoDocto());
        FileUtils.copyFile((File)file, (File)destFile);
        this.logger.debug("file save correctly {}", (Object)name);
        return doc;
    }

    public void borrarDocumento(Long idContratoDocto) {
        this.documentoDAO.borrarDocumento(idContratoDocto);
    }

    public DocumentoDTO buscarDocumento(Long idContratoDocto) {
        return this.documentoDAO.buscarDocumento(idContratoDocto);
    }

    public List<DocumentoDTO> buscarDocumentos(Long idContrato) {
        return this.documentoDAO.buscarDocumentos(idContrato);
    }

    public DocumentoDTO obtenerUltimoDocumento(Long idContrato) {
        DocumentoDTO documento = null;
        try {
            documento = this.documentoDAO.obtenerUltimoDocumento(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return documento;
    }
}

