/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.facturas.bos;

import com.mx.dla.dda.contrato.facturas.daos.FacturasDAO;
import com.mx.dla.dda.contrato.facturas.dtos.FacturaDbDTO;
import com.mx.dla.dda.contrato.facturas.dtos.FacturaViewDTO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FacturasBO
extends BaseBO {
    @Autowired
    private FacturasDAO facturasDAO;
    @Autowired
    private GeneralesDAO generalesDAO;

    public List<FacturaViewDTO> buscarFacturas(Long idContrato) {
        ArrayList<FacturaDbDTO> source = new ArrayList();
        ContratoDTO contrato = this.generalesDAO.obtenerContrato(idContrato);
        source = this.facturasDAO.buscarFacturas(contrato.getIdContratoOriginal());
        return this.transformBdToViewFactura(source);
    }

    public List<FacturaViewDTO> transformBdToViewFactura(List<FacturaDbDTO> source) {
        ArrayList<FacturaViewDTO> target = new ArrayList<FacturaViewDTO>();
        try {
            for (FacturaDbDTO itemSource : source) {
                FacturaViewDTO itemTarget = new FacturaViewDTO();
                BeanUtils.copyProperties((Object)itemTarget, (Object)itemSource);
                target.add(itemTarget);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            this.logger.debug("Error en transform de factura: {}", (Throwable)e);
        }
        return target;
    }
}

