/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.fees.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoBonoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoCostoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeesBonoBO
extends BaseBO {
    @Autowired
    private FeesContratoDAO feesContratoDAO;

    public FeesPagoBonoDTO getBono(Long idContrato) {
        List pagoBonos = this.feesContratoDAO.getRangosBono(idContrato);
        FeesPagoBonoDTO bono = new FeesPagoBonoDTO();
        bono.setRangos(pagoBonos);
        return bono;
    }

    public void guardarBono(String bonoRequest, Long idContrato) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper;
        FeesPagoBonoDTO bono;
        this.eliminarBono(idContrato);
        this.logger.debug("eliminar bono");
        if (bonoRequest != null && !bonoRequest.equals("") && (bono = (FeesPagoBonoDTO)(mapper = new ObjectMapper()).readValue(bonoRequest, FeesPagoBonoDTO.class)).getRangos() != null) {
            this.feesContratoDAO.guardarRangoBonoFlatALL(bono.getRangos(), idContrato);
            this.logger.debug("guardar bono");
        }
    }

    public void eliminarBono(Long idContrato) {
        this.feesContratoDAO.eliminarBono(idContrato);
    }

    public void eliminarRangoBono(FeesContratoPagoDTO categoria) {
        this.feesContratoDAO.eliminarRangoFlatBonoByRango(categoria.getIdContrato(), ((FeesPagoCostoDTO)categoria.getCategorias().get(0)).getIdCategoria());
    }
}

