/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.fees.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoCostoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoRangoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeesSuscriptorBO
extends BaseBO {
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    @Autowired
    private MinimoSeleccionBO minimoSeleccionBO;

    public FeesContratoPagoDTO crearSuscriptor(FeesContratoPagoBD pagoBD, List<FeesSuscriptorBD> feeBD) {
        FeesContratoPagoDTO fee = null;
        int numRangos = 1;
        if (feeBD == null) {
            ArrayList<FeesPagoCostoDTO> pagos = new ArrayList<FeesPagoCostoDTO>();
            FeesPagoCostoDTO pago = new FeesPagoCostoDTO(Long.valueOf(0L), "", Integer.valueOf(numRangos));
            pagos.add(pago);
            fee = new FeesContratoPagoDTO(Long.valueOf(0L), Long.valueOf(0L), Long.valueOf(0L), "", "", "", "", "nuevo", pagos, null);
            fee.setMaxRangos(Integer.valueOf(numRangos));
        } else {
            this.logger.debug(feeBD.toString());
            ArrayList<FeesPagoCostoDTO> pagos = new ArrayList<FeesPagoCostoDTO>();
            for (FeesSuscriptorBD itemBD : feeBD) {
                boolean existente = false;
                for (FeesPagoCostoDTO item : pagos) {
                    if (item.getIdCategoria().longValue() != itemBD.getIdCategoria().longValue()) continue;
                    item.getRangos().add(new FeesPagoRangoDTO(itemBD.getIdPagoRango(), itemBD.getDesde(), itemBD.getHasta(), itemBD.getCosto()));
                    existente = true;
                }
                if (existente) continue;
                FeesPagoCostoDTO pago = new FeesPagoCostoDTO(itemBD.getIdCategoria(), itemBD.getDesCategoria(), Integer.valueOf(0));
                pago.getRangos().add(new FeesPagoRangoDTO(itemBD.getIdPagoRango(), itemBD.getDesde(), itemBD.getHasta(), itemBD.getCosto()));
                pagos.add(pago);
            }
            numRangos = ((FeesPagoCostoDTO)pagos.get(0)).getRangos().size();
            fee = new FeesContratoPagoDTO(pagoBD.getIdContratoPago(), pagoBD.getIdContrato(), pagoBD.getIdTipoSuscriptor(), this.getFecha(pagoBD.getFechaInicio()), this.getFecha(pagoBD.getFechaFin()), pagoBD.getTipoAnio(), pagoBD.getTipoPago(), "editar", pagos, null);
            fee.setAnioContrato(pagoBD.getAnioContrato());
            fee.setMaxRangos(Integer.valueOf(numRangos));
        }
        return fee;
    }

    public void guardarSuscriptor(FeesContratoPagoDTO periodo, Long idContrato) throws ParseException, Exception {
        ArrayList<FeesSuscriptorBD> minSelCat = new ArrayList<FeesSuscriptorBD>();
        Integer str = null;
        this.logger.debug("periodo a guardar." + periodo.toString());
        FeesContratoPagoBD contratoPago = new FeesContratoPagoBD(Long.valueOf(0L), idContrato, periodo.getIdSuscriptor(), periodo.getTipoPago(), periodo.getTipoAnio(), this.crearFecha(periodo.getFechaInicio()), this.crearFecha(periodo.getFechaFin()));
        contratoPago.setAnioContrato(periodo.getAnioContrato());
        this.feesContratoDAO.guardarContratoPago(contratoPago);
        this.minimoSeleccionBO.guardarMinSeleccion(contratoPago.getIdContratoPago(), null, null);
        this.guardarRangoPagoCosto(periodo, contratoPago);
        for (FeesPagoCostoDTO categoria : periodo.getCategorias()) {
            minSelCat.add(new FeesSuscriptorBD(contratoPago.getIdContratoPago(), str, categoria.getIdCategoria()));
        }
        this.minimoSeleccionBO.guardarMinSeleccionXCatAnio(minSelCat);
        this.logger.debug("guardar msle. " + ((Object)minSelCat).toString());
    }

    public void guardarRangoPagoCosto(FeesContratoPagoDTO periodo, FeesContratoPagoBD contratoPago) {
        ArrayList<Long> idRangos = new ArrayList<Long>();
        ArrayList<FeesSuscriptorBD> costos = new ArrayList<FeesSuscriptorBD>();
        for (FeesPagoRangoDTO rango : ((FeesPagoCostoDTO)periodo.getCategorias().get(0)).getRangos()) {
            this.feesContratoDAO.guardarPagoRango(rango, contratoPago.getIdContratoPago());
            idRangos.add(rango.getIdRango());
        }
        for (FeesPagoCostoDTO categoria : periodo.getCategorias()) {
            for (int i = 0; i < categoria.getRangos().size(); ++i) {
                costos.add(new FeesSuscriptorBD((Long)idRangos.get(i), ((FeesPagoRangoDTO)categoria.getRangos().get(i)).getMonto(), categoria.getIdCategoria()));
            }
        }
        this.feesContratoDAO.guardarPagoCostoALL(costos);
        this.logger.info("Se guarda los costos. " + ((Object)costos).toString() + "del periodo " + periodo.getIdContratoPago());
    }

    public void editarSuscriptor(FeesContratoPagoDTO periodo) throws ParseException, Exception {
        this.logger.info("periodo a actualizar." + periodo.toString());
        FeesContratoPagoBD contratoPago = new FeesContratoPagoBD(periodo.getIdContratoPago(), periodo.getIdContrato(), periodo.getIdSuscriptor(), periodo.getTipoPago(), periodo.getTipoAnio(), this.crearFecha(periodo.getFechaInicio()), this.crearFecha(periodo.getFechaFin()));
        contratoPago.setAnioContrato(periodo.getAnioContrato());
        this.feesContratoDAO.actualizarContratoPago(contratoPago);
        this.guardarRangoPagoCosto(periodo, contratoPago);
        this.logger.info("Se ha terminado de editar el periodo. id[" + periodo.getIdContratoPago() + "]");
    }

    public void eliminarSuscriptores(Long idContrato) throws ParseException, Exception {
        this.minimoSeleccionBO.eliminarMinSeleccionXCto(idContrato);
        this.eliminarRangosCostoSuscriptor(idContrato);
        this.feesContratoDAO.eliminarContratoPagoXCto(idContrato);
    }

    public void eliminarSuscriptor(FeesContratoPagoDTO periodo) {
        this.minimoSeleccionBO.eliminarMinSeleccion(periodo.getIdContratoPago(), null);
        for (FeesPagoCostoDTO categoria : periodo.getCategorias()) {
            for (FeesPagoRangoDTO rango : categoria.getRangos()) {
                this.feesContratoDAO.eliminarPagoCosto(categoria.getIdCategoria(), rango.getIdRango());
            }
        }
        this.feesContratoDAO.eliminarPagoRango(periodo.getIdContratoPago());
        this.feesContratoDAO.eliminarContratoPago(periodo.getIdContratoPago());
    }

    public void eliminarRangosCostoSuscriptor(Long idContrato) throws ParseException, Exception {
        this.feesContratoDAO.eliminarPagoCostoXCto(idContrato);
        this.feesContratoDAO.eliminarPagoRangoXCto(idContrato);
        this.logger.info("Se han eliminado los rangos y valores de los rangos");
    }

    public List<FeesContratoPagoDTO> eliminarCategoriaSuscriptor(Long idCategoria, List<FeesContratoPagoDTO> periodos) {
        this.feesContratoDAO.eliminarPagoCostoXCategoria(idCategoria);
        for (FeesContratoPagoDTO periodo : periodos) {
            this.minimoSeleccionBO.eliminarMinSeleccion(periodo.getIdContratoPago(), idCategoria);
            int index = -1;
            for (int i = 0; i < periodo.getCategorias().size(); ++i) {
                if (((FeesPagoCostoDTO)periodo.getCategorias().get(i)).getIdCategoria().longValue() != idCategoria.longValue()) continue;
                index = i;
            }
            if (index == -1) continue;
            periodo.getCategorias().remove(index);
        }
        this.feesContratoDAO.actualizarTitulosTCateg(idCategoria);
        this.feesContratoDAO.actualizarTitulosMCateg(idCategoria);
        this.feesContratoDAO.eliminarPagoCategoria(idCategoria);
        return periodos;
    }

    public Date crearFecha(String valor) throws ParseException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy");
        Date fecha = formatter1.parse(valor);
        return fecha;
    }

    public String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }
}

