/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.license.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.license.titulo.bos.TituloFeeBussinesBO;
import com.mx.dla.dda.contrato.license.titulo.bos.TituloFeeGridBO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeChunkDAO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDAO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDmDAO;
import com.mx.dla.dda.contrato.license.titulo.rules.TituloFeeRules;
import com.mx.dla.dda.contrato.titulo.constants.TipoCargaDocumento;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloErrores;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.RespuestaCargaExcel;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamCargaTitulosLFDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseCargaTitulosDTO;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TituloFeeBO
extends BaseBO {
    @Autowired
    private BeanPopulator beanPopulator;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Autowired
    protected ListaDAO listaDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    protected TituloErrores tituloErrores;
    @Autowired
    private AmortizacionDAO amortizacionDAO;
    @Autowired
    protected TituloFeeDAO tituloDAO;
    @Autowired
    protected TituloFeeDmDAO tituloDummyDAO;
    @Autowired
    protected TituloFeeGridBO titulogridBO;
    @Autowired
    private TituloFeeChunkDAO tituloChunkDAO;
    @Autowired
    protected TituloFeeRules tituloRules;
    @Autowired
    private TituloFeeBussinesBO tituloFeeBussinesBO;
    @Value(value="${uri.file.titulos}")
    protected String uriErrores;
    @Value(value="${uri.file.carga.titulosLF}")
    protected String uriCargaTitulos;
    protected static final int CHUNK = 1000;

    public Lista init(ContratoDTO c) {
        Date a = new Date();
        Lista lista = this.listaDAO.buscarListaActual(c.getIdContrato(), "T");
        if (lista == null) {
            lista = this.crearListaNueva(c.getIdContrato(), c.getFechaInicio(), "T");
        }
        this.createMirrorEntities(c);
        lista = this.listaDAO.buscarListaActual(c.getIdContrato(), "M");
        lista.setFechaInicioPlusOneDay(this.calculaFechaMasUnDia(lista.getFechaInicio()));
        this.logger.debug("Total time ms [{}]", (Object)(new Date().getTime() - a.getTime()));
        return lista;
    }

    public Lista crearListaNueva(Long idContrato, Date fechaInicio, String prefix) {
        Lista l = new Lista(idContrato, fechaInicio, prefix);
        this.listaDAO.insertarLista(l);
        return l;
    }

    public void guardarCambiosPermanente(ContratoDTO c) {
        this.tituloDAO.borrarTitulosPorContrato(c.getIdContrato());
        this.listaDAO.borrarListaPorIdContrato(c.getIdContrato(), "T");
        this.tituloChunkDAO.aListaRealPorCorato(c.getIdContrato());
        List lreal = this.listaDAO.buscarListas(c.getIdContrato(), "T");
        List lespejo = this.listaDAO.buscarListas(c.getIdContrato(), "M");
        for (int i = 0; i < lreal.size(); ++i) {
            this.tituloChunkDAO.aTituloRealPorLista(((Lista)lespejo.get(i)).getIdLista(), ((Lista)lreal.get(i)).getIdLista());
        }
        this.amortizacionDAO.updateContratoProceso(c.getIdContrato(), Integer.valueOf(1));
    }

    public void createMirrorEntities(ContratoDTO c) {
        this.tituloDummyDAO.borrarTitulosPorContrato(c.getIdContrato());
        this.listaDAO.borrarListaPorIdContrato(c.getIdContrato(), "M");
        this.tituloChunkDAO.aListaEspejoPorCorato(c.getIdContrato());
        List lreal = this.listaDAO.buscarListas(c.getIdContrato(), "T");
        List lespejo = this.listaDAO.buscarListas(c.getIdContrato(), "M");
        for (int i = 0; i < lreal.size(); ++i) {
            this.tituloChunkDAO.aTituloEspejoPorLista(((Lista)lreal.get(i)).getIdLista(), ((Lista)lespejo.get(i)).getIdLista());
        }
    }

    public byte[] generateExcelReport(Titulo titulo) throws ExcelMapperException, IOException {
        this.logger.debug("Descargar archivo de excel [{}]", (Object)titulo);
        List<Titulo> lista = new ArrayList();
        try {
            lista = this.tituloDummyDAO.buscarTituloFiltroPaginado(titulo);
            if (lista == null || lista.isEmpty()) {
                lista = new ArrayList();
                lista.add(this.beanPopulator.initObject(Titulo.class));
            }
            this.logger.debug("Descargar archivo, se han  obtenido [{}]", (Object)lista.size());
        }
        catch (Exception e) {
            this.logger.error("Error al buscar contenido de titulos");
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(lista, "tituloLicense", Titulo.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public byte[] buscarArchivoDeErrores(ContratoDTO ct) throws IOException {
        File file = new File(this.uriErrores + ct.getIdContrato());
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        byte[] errores = FileUtils.readFileToByteArray((File)file);
        return errores;
    }

    public RespuestaCargaExcel cargaMasivaDeTitulos2(Titulo titulo, ContratoDTO contrato, TipoCargaDocumento tc, File fileUpload, String fileName, Lista listaActual, String expediente) throws TituloException {
        this.logger.debug("Inicio proceso remoto");
        RespuestaCargaExcel r = new RespuestaCargaExcel();
        Double costo = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
        costo = costo != null ? costo : 0.0;
        try {
            byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
            File d = new File(this.uriCargaTitulos + contrato.getIdContrato() + expediente + fileName);
            d.setExecutable(true, false);
            d.setReadable(true, false);
            d.setWritable(true, false);
            this.logger.info("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
            FileUtils.writeByteArrayToFile((File)d, (byte[])f);
            DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.CARGA_TITULOS_LICENSE);
            this.logger.info("LLamando al Rest {}", (Object)c.getUri());
            ParamCargaTitulosLFDTO request = new ParamCargaTitulosLFDTO();
            request.setNombreArchivo(FilenameUtils.getName((String)d.getCanonicalPath()));
            request.setIdContrato(contrato.getIdContrato().toString());
            request.setIdListaActual(listaActual.getIdLista().toString());
            request.setTipoLista(TipoCargaDocumento.NUEVA.equals((Object)tc) ? "NUEVA" : "ACTUAL");
            request.setTipoCarga(TipoCargaDocumento.ANEXAR.equals((Object)tc) ? "AGREGAR" : "REEMPLAZAR");
            request.setExpediente(expediente);
            Calendar cal = Calendar.getInstance();
            cal.setTime(contrato.getFechaInicio());
            cal.set(2, cal.get(2) - 1);
            cal.set(5, 1);
            SimpleDateFormat fecha = new SimpleDateFormat("dd/MM/yyyy");
            request.setFechaInicioListaNueva(titulo.getFechaInicio() != null ? fecha.format(titulo.getFechaInicio()) : "");
            this.logger.debug("Request carga titulos [{}]", (Object)request);
            ResponseCargaTitulosDTO response = c.get(request, ResponseCargaTitulosDTO.class);
            this.logger.debug("Response carga titulos [{}]", (Object)response);
            if (!response.isResultado()) {
                throw new TituloException(response.getMensaje());
            }
            r.setResponse(response);
            if (!response.getDatosCarga().getTOTAL_ERROR().equals("0")) {
                this.logger.debug("Inicio Creaci\u00f3n Excel.");
                List a = new ArrayList();
                Date d1 = new Date();
                a = this.tituloErrores.buscarErroresTitulo(Long.valueOf(Long.parseLong(response.getDatosCarga().getID_CARGA())));
                this.logger.debug("Tiempo de busqueda [{}] total Errors[{}]", (Object)(new Date().getTime() - d1.getTime()), (Object)a.size());
                d1 = new Date();
                byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(a, "tituloLicense", Titulo.class);
                this.logger.debug("Tiempo de transformacion [{}] ", (Object)(new Date().getTime() - d1.getTime()));
                File destFile = new File(this.uriErrores + contrato.getIdContrato());
                FileUtils.writeByteArrayToFile((File)destFile, (byte[])fileExcel);
                d1 = new Date();
                this.logger.debug("Tiempo de escritura [{}] ", (Object)(new Date().getTime() - d1.getTime()));
                this.logger.debug("Fin Creaci\u00f3n Excel.");
            }
        }
        catch (ExcelMapperException e) {
            this.logger.error("Errores [{}]", (Object)e.getSErrors());
            this.logger.error("Error al leer el archivo", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.debug("Error ", (Throwable)e);
            throw new TituloException("Ocurrio un error al subir el documento");
        }
        this.logger.debug("Inicio Busqueda.");
        Lista listaA = this.listaDAO.buscarListaActual(contrato.getIdContrato(), "M");
        this.logger.debug("Fin Busqueda.");
        if (!TipoCargaDocumento.ANEXAR.equals((Object)tc)) {
            costo = 0.0;
        }
        this.tituloFeeBussinesBO.actualizaCostoTituloExcel(contrato.getIdContrato());
        this.logger.debug("Inicio Busqueda Costo.");
        Double costoFinal = this.tituloDummyDAO.buscarTotalCostoTitulos(contrato.getIdContrato(), "M");
        costoFinal = costoFinal != null ? costoFinal : 0.0;
        this.logger.debug("Costo anterior [{}] costo final[{}]", (Object)costo, (Object)costoFinal);
        r.setMonto(Double.valueOf(costoFinal - costo));
        r.setLista(listaA);
        return r;
    }

    public List<TipoCargaDocumento> buscaTipoCargaDocumento(ContratoDTO ct) {
        ArrayList<TipoCargaDocumento> r = new ArrayList<TipoCargaDocumento>();
        r.add(TipoCargaDocumento.ANEXAR);
        r.add(TipoCargaDocumento.REEMPLAZAR);
        List l = this.listaDAO.buscarListasPorContratoCreacion(ct.getIdContrato(), "M");
        if (l.size() == 0) {
            r.add(TipoCargaDocumento.NUEVA);
        }
        return r;
    }

    public Date calculaFechaMasUnDia(Date in) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.set(6, cal.get(6) + 1);
        return cal.getTime();
    }

    public String getUriCarga() {
        return this.uriCargaTitulos;
    }
}

