/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.license.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.license.titulo.bos.TituloFeeBussinesBO;
import com.mx.dla.dda.contrato.license.titulo.bos.TituloFeeUtilBO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDAO;
import com.mx.dla.dda.contrato.license.titulo.daos.TituloFeeDmDAO;
import com.mx.dla.dda.contrato.license.titulo.rules.TituloFeeRules;
import com.mx.dla.dda.contrato.titulo.constants.TipoCambioTitulo;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.titulos.dtos.CatTitulo;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloFeeGridBO
extends BaseBO {
    @Autowired
    protected CommonRestBO commonRestBO;
    @Autowired
    protected ListaDAO listaDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected TituloFeeRules tituloRules;
    @Autowired
    protected TituloFeeBussinesBO titulosBussinesBO;
    @Autowired
    private TituloFeeDmDAO tituloDmDAO;
    @Autowired
    protected TituloFeeDAO tituloDAO;
    @Autowired
    protected TituloFeeUtilBO tituloFeeUtilBO;

    public String alta(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.debug("Alta. Titulo [{}]", (Object)t);
        String serie = null;
        if (this.tituloRules.verificarSerieNueva(t)) {
            serie = "El sistema generar\u00e1 autom\u00e1ticamente" + t.getEpisodio() + " los episodios de " + t.getDescTitulo();
        } else {
            this.guardaTitulo(c, l, t);
            this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
        }
        return serie;
    }

    public Titulo guardaTitulo(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        t.setIdLista(l.getIdLista());
        this.tituloRules.validaEntrada(t, this.titulosBussinesBO.calculaFechasInicioFinValidacion(c));
        CatTitulo cat = this.titulosBussinesBO.actualizaCatalogoTitulos(t.getDescTitulo(), c);
        t = this.tituloFeeUtilBO.getTituloGuardar(cat, t, c);
        t.setCosto(this.titulosBussinesBO.obtieneCostoTitulo(c.getIdContrato()));
        this.tituloDmDAO.insertarTitulo(t);
        return t;
    }

    public void cambio(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.debug("Cambio. Titulo [{}]", (Object)t);
        this.tituloRules.validaEntrada(t, this.titulosBussinesBO.calculaFechasInicioFinValidacion(c));
        Titulo destino = this.tituloDmDAO.buscarTitulo(t.getIdTituloCnt());
        destino = !destino.getDescTitulo().equals(t.getDescTitulo()) ? this.llenaCambioTitulo(t, destino, c) : this.guardarEdicionTitulo(t, destino, c);
        this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
        this.titulosBussinesBO.actualizarBanderasContratosAnteriores(destino, "M");
    }

    public void cambioMultiple(ContratoDTO c, Lista l, Titulo origen, String tipoCambio, String idsTipoCambio) throws TituloException {
        String[] indexes;
        this.logger.debug("cambioMultiple. Titulo [{}]", (Object)origen);
        this.logger.debug("Contrato [{}]", (Object)c);
        this.logger.debug("tipocambio [{}]", (Object)tipoCambio);
        this.logger.debug("Contrato [{}]", (Object)idsTipoCambio);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String index : indexes = idsTipoCambio.split(",")) {
            CatalogoDTO cat;
            if ("".equals(index)) continue;
            origen.setIdTituloCnt(Long.valueOf(Long.parseLong(index)));
            Titulo destino = this.tituloDmDAO.buscarTitulo(origen.getIdTituloCnt());
            if (TipoCambioTitulo.CATEGORIA.name().equals(tipoCambio)) {
                cat = null;
                if (origen.getPagoCateg() != null) {
                    cat = this.catalogosDAO.buscarCategoriaPagoPorDesc(c.getIdContrato(), origen.getPagoCateg().getDesc());
                }
                destino.setPagoCateg(cat);
                destino.setPrecioAnual(null);
            } else {
                destino.setFechaInicio(origen.getFechaInicio());
                destino.setFechaFin(origen.getFechaFin());
                destino.setVidaUtil(this.tituloFeeUtilBO.calcularVidaUtil(origen.getFechaInicio(), origen.getFechaFin()));
                destino.setMesesvu(this.tituloFeeUtilBO.calculaMesesVidaUtil(origen.getFechaInicio(), origen.getFechaFin()));
                cat = null;
                if (destino.getPagoCateg() != null) {
                    cat = this.catalogosDAO.buscarCategoriaPagoPorDesc(c.getIdContrato(), destino.getPagoCateg().getDesc());
                }
                destino.setPagoCateg(cat);
            }
            this.tituloDmDAO.actualizarTitulo(destino);
            this.titulosBussinesBO.actualizarBanderasContratosAnteriores(destino, "M");
            ids.add(origen.getIdTituloCnt());
        }
        this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
    }

    public Titulo llenaCambioTitulo(Titulo origen, Titulo bd, ContratoDTO contrato) throws TituloException {
        if (bd.getIdSap() != null) {
            if (bd.getFechaNotifsap() != null) {
                origen.setEstatus("ACTIVO");
                origen.setIdSap("PDTE");
                origen.setAjustoTitulo(Long.valueOf(1L));
                origen.setFechaNotifsap(bd.getFechaNotifsap());
                origen.setIdContrato(contrato.getIdContrato());
                CatTitulo c = this.titulosBussinesBO.actualizaCatalogoTitulos(origen.getDescTitulo(), contrato);
                origen.setIdTitulo(c.getIdTitulo());
                origen.setVidaUtil(this.tituloFeeUtilBO.calcularVidaUtil(origen.getFechaInicio(), origen.getFechaFin()));
                origen.setMesesvu(this.tituloFeeUtilBO.calculaMesesVidaUtil(origen.getFechaInicio(), origen.getFechaFin()));
                origen.setEstatus("ACTIVO");
                this.tituloDmDAO.insertarTitulo(origen);
                Titulo nuevo = this.tituloDmDAO.buscarTitulo(origen.getIdTituloCnt());
                if (bd.getIdSapAnt() != null) {
                    nuevo.setIdSapAnt(bd.getIdSapAnt());
                    nuevo.setIdTituloCntant(bd.getIdTituloCntant());
                    nuevo.setIdTituloCntorig(bd.getIdTituloCntorig());
                    this.tituloDmDAO.actualizarTitulo(nuevo);
                    this.tituloDmDAO.borrarTitulo(bd.getIdTituloCnt());
                } else {
                    nuevo.setIdSapAnt(bd.getIdSap());
                    nuevo.setIdTituloCntant(bd.getIdTituloCnt());
                    nuevo.setIdTituloCntorig(bd.getIdTituloCntorig());
                    this.tituloDmDAO.actualizarTitulo(nuevo);
                    bd.setEstatus("ELIMINADO");
                    bd.setIdTituloCntnvo(nuevo.getIdTituloCnt());
                    this.tituloDmDAO.actualizarTitulo(bd);
                }
                bd = nuevo;
            } else {
                bd.setAjustoTitulo(Long.valueOf(1L));
                bd = this.guardarEdicionTitulo(origen, bd, contrato);
            }
        } else {
            bd = this.guardarEdicionTitulo(origen, bd, contrato);
        }
        return bd;
    }

    public Titulo guardarEdicionTitulo(Titulo origen, Titulo bd, ContratoDTO contrato) throws TituloException {
        bd = this.tituloFeeUtilBO.getTituloByTitulo(origen, bd);
        CatTitulo c = this.titulosBussinesBO.actualizaCatalogoTitulos(origen.getDescTitulo(), contrato);
        bd.setIdTitulo(c.getIdTitulo());
        this.tituloDmDAO.actualizarTitulo(bd);
        return bd;
    }

    public void altaSeriesAuto(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.debug("Alta Serie. Titulo [{}]", (Object)t);
        int numEpisodios = Integer.parseInt(t.getEpisodio());
        String nombre = t.getDescTitulo() + ": Episodio # ";
        for (int i = 1; i <= numEpisodios; ++i) {
            String name = nombre + i;
            this.guardaTitulo(c, l, TituloFeeUtilBO.getTituloSerieAuto(t, name, String.valueOf(i)));
        }
        this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
    }

    public void baja(ContratoDTO c, Titulo t) {
        this.logger.debug("baja. Titulo [{}]", (Object)t);
        Titulo tbd = this.tituloDmDAO.buscarTitulo(t.getIdTituloCnt());
        if (tbd.getIdSap() == null || "".equals(tbd.getIdSap())) {
            this.tituloDmDAO.borrarTitulo(t.getIdTituloCnt());
        } else {
            tbd.setEstatus("ELIMINADO");
            if (tbd.getFechaNotifsap() != null) {
                tbd.setBajaPerdida(t.getBajaPerdida());
                if (t.getBajaPerdida() == 0L) {
                    tbd.setNotaCredito(Integer.valueOf(1));
                }
            } else {
                tbd.setBajaPerdida(Long.valueOf(0L));
            }
            this.tituloDmDAO.actualizarTitulo(tbd);
        }
    }

    public List<Titulo> busqueda(Titulo t, boolean calculaAmortizacion, String prefix) throws TituloException {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        titulos.addAll(this.tituloDmDAO.buscaTotalesLista(t.getIdLista(), prefix));
        titulos.addAll(this.tituloDmDAO.buscaDetallePeliculas(t.getIdLista(), prefix));
        List nombresUnicos = this.tituloDmDAO.buscaSerie1Capitulo(t.getIdLista(), prefix);
        List series = this.tituloDmDAO.buscaTotalesSerie(t.getIdLista(), t.getNombreUnico(), prefix);
        block0: for (Titulo s : nombresUnicos) {
            int i = 0;
            for (Titulo tt : series) {
                if (tt.getNombreUnico().equals(s.getNombreUnico())) {
                    series.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        titulos.addAll(nombresUnicos);
        titulos.addAll(series);
        if (calculaAmortizacion) {
            for (Titulo tam : titulos) {
                HashMap<String, String> h = new HashMap<String, String>();
                if (tam.getAmortizaciones() != null) {
                    for (CatalogoDTO cat : tam.getAmortizaciones()) {
                        h.put(cat.getValue(), cat.getDesc());
                    }
                }
                tam.setAmortizacionesH(h);
            }
        }
        return titulos;
    }

    public List<Titulo> busquedaDetalle(Titulo t, boolean calcularAmort, String prefix) throws TituloException {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        titulos.addAll(this.tituloDmDAO.buscaTotalesSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        titulos.addAll(this.tituloDmDAO.buscaDetalleSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        ((Titulo)titulos.get(0)).setAgrupable(Integer.valueOf(0));
        if (calcularAmort) {
            for (Titulo tam : titulos) {
                HashMap<String, String> h = new HashMap<String, String>();
                if (tam.getAmortizaciones() != null) {
                    for (CatalogoDTO cat : tam.getAmortizaciones()) {
                        h.put(cat.getValue(), cat.getDesc());
                    }
                }
                tam.setAmortizacionesH(h);
            }
        }
        return titulos;
    }
}

