/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.promociones.bos;

import com.mx.dla.dda.contrato.promociones.daos.PromocionesDAO;
import com.mx.dla.dda.contrato.promociones.dtos.EstudiosPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PaisesPromocionesDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionDTO;
import com.mx.dla.dda.contrato.promociones.dtos.PromocionTitulosDTO;
import com.mx.dla.dda.contrato.promociones.dtos.TitulosPromocionesDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.global.bos.BaseBO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PromocionesBO
extends BaseBO {
    @Autowired
    private PromocionesDAO promocionesdao;

    public List<PromocionDTO> obtenPromociones() throws Exception {
        List promociones = null;
        try {
            promociones = this.promocionesdao.obtenerPromociones();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Promociones.", ex);
        }
        return promociones;
    }

    public List<PromocionDTO> obtenPromocionesVigentes() throws Exception {
        List promociones = null;
        try {
            promociones = this.promocionesdao.obtenerPromocionesVigentes();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Promociones.", ex);
        }
        return promociones;
    }

    public void eliminarPromocion(Long id_promocion) throws Exception {
        try {
            System.out.println("se eliminara la promocion: " + id_promocion);
            this.promocionesdao.eliminaPromocion(id_promocion);
        }
        catch (Exception e) {
            throw new TransaccionException("ERROR - Promociones.PromocionesBO.eliminarPromocion ::: ", e);
        }
    }

    public void eliminaTitulosPromocion(Long id_promocion) throws Exception {
        try {
            System.out.println("se eliminaran los Titulos de la Promo: " + id_promocion);
            this.promocionesdao.eliminaTitulosPromocion(id_promocion);
        }
        catch (Exception e) {
            throw new TransaccionException("ERROR - Promociones.PromocionesBO.eliminaTitulosPromocion ::: ", e);
        }
    }

    public List<EstudiosPromocionesDTO> obtenerEstudios() throws Exception {
        List listaestudios = null;
        try {
            listaestudios = this.promocionesdao.obtenerEstudios();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Estudios.", ex);
        }
        return listaestudios;
    }

    public List<PaisesPromocionesDTO> obtenerPaises() throws Exception {
        List listapaises = null;
        try {
            listapaises = this.promocionesdao.obtenerPaises();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Paises.", ex);
        }
        return listapaises;
    }

    public List<TitulosPromocionesDTO> obtenerTitulos(Long id_pais, Long id_estudio) throws Exception {
        List listatitulos = null;
        try {
            listatitulos = this.promocionesdao.obtenerTitulos(id_pais, id_estudio);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Titulos.", ex);
        }
        return listatitulos;
    }

    public List<TitulosPromocionesDTO> obtenerTitulosTodos(Long id_estudio) throws Exception {
        List listatitulostodos = null;
        try {
            listatitulostodos = this.promocionesdao.obtenerTitulosTodos(id_estudio);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Titulos de todos los paises.", ex);
        }
        return listatitulostodos;
    }

    public List<PromocionTitulosDTO> obtenerPromocionTitulos(Long id_promocion) throws Exception {
        List promociontitulos = null;
        try {
            promociontitulos = this.promocionesdao.obtenerTitulosPromocion(id_promocion);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener el listado de Titulos de la Promocion.", ex);
        }
        return promociontitulos;
    }

    public PromocionDTO creaPromocion(Long id_estudio, Long id_pais, String nombre_promocion, String fecha_inicio, String fecha_fin, String tipo_descuento, String descuento) throws Exception {
        PromocionDTO promocion = new PromocionDTO();
        try {
            promocion.setId_estudio(id_estudio);
            promocion.setId_pais(id_pais);
            promocion.setNombre_promocion(nombre_promocion);
            promocion.setFecha_inicio(fecha_inicio);
            promocion.setFecha_fin(fecha_fin);
            promocion.setTipo_descuento(tipo_descuento);
            promocion.setDescuento(descuento);
            System.out.println("Se creara la promocion: " + promocion);
            this.promocionesdao.crearPromocion(promocion);
        }
        catch (Exception e) {
            throw new TransaccionException("ERROR - Promociones.PromocionesBO.creaPromocion ::: ", e);
        }
        return promocion;
    }

    public PromocionDTO actualizaPromocion(Long id_promocion, Long id_pais, String nombre_promocion, String fecha_inicio, String fecha_fin, String tipo_descuento, String descuento) throws Exception {
        PromocionDTO promocion = new PromocionDTO();
        try {
            promocion.setId_promocion(id_promocion);
            promocion.setId_pais(id_pais);
            promocion.setNombre_promocion(nombre_promocion);
            promocion.setFecha_inicio(fecha_inicio);
            promocion.setFecha_fin(fecha_fin);
            promocion.setTipo_descuento(tipo_descuento);
            promocion.setDescuento(descuento);
            System.out.println("Se actualizara la promocion: " + promocion);
            this.promocionesdao.actualizaPromocion(promocion);
        }
        catch (Exception e) {
            throw new TransaccionException("ERROR - Promociones.PromocionesBO.actualizaPromocion ::: ", e);
        }
        return promocion;
    }

    public void registraPromocionTitulos(Long id_promocion, Long id_bv) throws Exception {
        try {
            PromocionTitulosDTO promociontitulos = new PromocionTitulosDTO();
            promociontitulos.setId_bv(id_bv);
            promociontitulos.setId_promocion(id_promocion);
            this.promocionesdao.registraTitulosPromocion(promociontitulos);
        }
        catch (Exception e) {
            throw new TransaccionException("Error al insertar los titulos de la promocion." + e);
        }
    }
}

