/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.terminos.bos;

import com.mx.dla.dda.contrato.materiales.daos.MaterialesDAO;
import com.mx.dla.dda.contrato.terminos.daos.TerminosDAO;
import com.mx.dla.dda.contrato.terminos.dtos.ContratoConsultaDTO;
import com.mx.dla.dda.contrato.terminos.dtos.PagoTerminoDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoBD;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoDTO;
import com.mx.dla.dda.contrato.terminos.dtos.TerminoServicioBD;
import com.mx.dla.dda.contrato.terminos.dtos.TituloTerminoDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.global.bos.BaseBO;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TerminosBO
extends BaseBO {
    @Autowired
    private TerminosDAO terminosDAO;
    @Autowired
    private MaterialesDAO materialesDAO;
    @Autowired
    private TituloDAO tituloDAO;

    public TerminoDTO getTerminos(Long idContrato) {
        TerminoDTO termino = new TerminoDTO();
        TerminoBD term = this.terminosDAO.getTermino(idContrato);
        if (term == null) {
            termino.setVacio(Boolean.valueOf(true));
        } else {
            if (term.getAnticipoMonto() != null) {
                PagoTerminoDTO pago = new PagoTerminoDTO(Double.valueOf(Double.parseDouble(term.getAnticipoMonto())), term.getAnticipoComentario(), this.getFecha(term.getAnticipoFecha()));
                termino.setPagoAnticipado(pago);
            }
            if (term.getTipoPago() != null && term.getTipoPago().compareTo("MENSUAL") == 0) {
                termino.setPagoMensual(Boolean.valueOf(true));
            }
            if (term.getTipoPago() != null && term.getTipoPago().compareTo("PREDEFINIDO") == 0 && term.getTipoPredefinido().compareTo("EXHIBICION") == 0) {
                termino.setPagoInicioExhibicion(Boolean.valueOf(true));
            }
            if (term.getTipoPago() != null && term.getTipoPago().compareTo("PREDEFINIDO") == 0 && term.getTipoPredefinido().compareTo("PERIODICO") == 0) {
                List periodicos = this.terminosDAO.getTerminoPeriodicos(idContrato);
                ArrayList<PagoTerminoDTO> pagoPeriodicos = new ArrayList<PagoTerminoDTO>();
                for (TerminoBD pago : periodicos) {
                    PagoTerminoDTO pagoT = new PagoTerminoDTO(Double.valueOf(Double.parseDouble(pago.getMonto())), pago.getComentario(), this.getFecha(pago.getFecha()));
                    pagoPeriodicos.add(pagoT);
                }
                termino.setPagoPeriodicos(pagoPeriodicos);
            }
            termino.setComentario(term.getComentarioGeneral());
        }
        termino.setNumeroTitulos(this.terminosDAO.getNumTitulos(idContrato));
        List<TituloTerminoDTO> serviTitulos = this.getServiciosTitulos(idContrato);
        termino.setTitulos(serviTitulos);
        return termino;
    }

    private List<TituloTerminoDTO> getServiciosTitulos(Long idContrato) {
        ArrayList<TituloTerminoDTO> serviTitulos = new ArrayList<TituloTerminoDTO>();
        List terminoServicio = this.terminosDAO.getTerminoTitulos(idContrato);
        for (TerminoServicioBD servicio : terminoServicio) {
            this.logger.debug(servicio.toString());
            Double cantidad = servicio.getCantidadTitulos() != null ? Double.valueOf(Double.parseDouble(servicio.getCantidadTitulos())) : null;
            Integer porcentaje = servicio.getPorcentajeTitulos() != null ? Integer.valueOf(Integer.parseInt(servicio.getPorcentajeTitulos())) : null;
            TituloTerminoDTO tituloServicio = new TituloTerminoDTO(servicio.getIdServicio(), cantidad, porcentaje, servicio.getDescripcion());
            serviTitulos.add(tituloServicio);
        }
        return serviTitulos;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarTerminos(TerminoDTO termino, Long idContrato) throws ParseException, IOException {
        this.logger.debug("termino:" + termino.toString());
        TerminoBD terminobd = new TerminoBD();
        terminobd.setIdContrato(idContrato);
        this.eliminarTerminos(idContrato);
        if (termino.getPagoAnticipado() != null) {
            terminobd.setAnticipoComentario(URLDecoder.decode(termino.getPagoAnticipado().getDescripcion(), "UTF-8"));
            terminobd.setAnticipoFecha(this.crearFecha(termino.getPagoAnticipado().getFecha()));
            terminobd.setAnticipoMonto(String.valueOf(termino.getPagoAnticipado().getMonto()));
        }
        if (termino.getPagoMensual() != null && termino.getPagoMensual().booleanValue()) {
            terminobd.setTipoPago("MENSUAL");
        }
        if (termino.getPagoInicioExhibicion() != null && termino.getPagoInicioExhibicion().booleanValue()) {
            terminobd.setTipoPago("PREDEFINIDO");
            terminobd.setTipoPredefinido("EXHIBICION");
        }
        if (termino.getPagoPeriodicos() != null) {
            terminobd.setTipoPago("PREDEFINIDO");
            terminobd.setTipoPredefinido("PERIODICO");
        }
        terminobd.setComentarioGeneral(URLDecoder.decode(termino.getComentario(), "UTF-8"));
        String numTitulos = termino.getNumeroTitulos() == null ? null : String.valueOf(termino.getNumeroTitulos());
        terminobd.setTotalTitulos(numTitulos);
        this.terminosDAO.guardarTermino(terminobd);
        if (termino.getPagoPeriodicos() != null) {
            ArrayList<TerminoBD> pagoPeriodicos = new ArrayList<TerminoBD>();
            for (PagoTerminoDTO pago : termino.getPagoPeriodicos()) {
                TerminoBD pagoT = new TerminoBD();
                pagoT.setMonto(String.valueOf(pago.getMonto()));
                pagoT.setFecha(this.crearFecha(pago.getFecha()));
                pagoT.setComentario(URLDecoder.decode(pago.getDescripcion(), "UTF-8"));
                pagoT.setIdContrato(idContrato);
                pagoPeriodicos.add(pagoT);
            }
            this.terminosDAO.guardarTerminoPago(pagoPeriodicos);
        }
        ArrayList<TerminoServicioBD> serviTitulos = new ArrayList<TerminoServicioBD>();
        for (TituloTerminoDTO servicio : termino.getTitulos()) {
            this.logger.debug(servicio.toString());
            TerminoServicioBD tituloServicio = new TerminoServicioBD();
            tituloServicio.setIdServicio(servicio.getId());
            String ser = servicio.getCantidad() == -1.0 ? null : String.valueOf(servicio.getCantidad());
            tituloServicio.setCantidadTitulos(ser);
            String por = (double)servicio.getPorcentaje().intValue() == -1.0 ? null : String.valueOf(servicio.getPorcentaje());
            tituloServicio.setPorcentajeTitulos(por);
            serviTitulos.add(tituloServicio);
        }
        this.terminosDAO.guardarServicioTitulo(serviTitulos, idContrato);
    }

    private void eliminarTerminos(Long idContrato) {
        this.terminosDAO.eliminarTerminoPago(idContrato);
        this.terminosDAO.eliminarTermino(idContrato);
        this.terminosDAO.eliminarServicio(idContrato);
    }

    public ContratoConsultaDTO getInformacionContrato(Long idContrato, TerminoDTO termino) {
        Double costoLicencia = this.tituloDAO.buscarTotalCostoTitulos(idContrato);
        Double materialesCosto = this.materialesDAO.buscarCostoTotalMateriales(idContrato);
        ContratoConsultaDTO contrato = this.terminosDAO.consultaContrato(new ContratoConsultaDTO(idContrato));
        termino.setCostoContrato(costoLicencia);
        termino.setCostoMateriales(materialesCosto);
        return contrato;
    }

    private Date crearFecha(String valor) throws ParseException {
        SimpleDateFormat formatter1 = new SimpleDateFormat("MM/dd/yyyy");
        Date fecha = formatter1.parse(valor);
        return fecha;
    }

    private String getFecha(Date fecha) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        return sdf.format(fecha);
    }
}

