/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.titulos.bos;

import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.dda.contrato.titulo.constants.TipoCargaDocumento;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.RespuestaCargaExcel;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.titulos.daos.TituloLoteTransDAO;
import com.mx.dla.dda.contrato.transaccion.titulos.daos.TituloTransDAO;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloTransaccionExcel;
import com.mx.dla.dda.contrato.transaccion.titulos.dtos.TituloValidaEstatusDTO;
import com.mx.dla.dda.contrato.transaccion.ws.titulos.dtos.ParamCargaTitulosTRDTO;
import com.mx.dla.dda.contrato.transaccion.ws.titulos.dtos.ParamInventarioTitulosDTO;
import com.mx.dla.dda.contrato.transaccion.ws.titulos.dtos.ResponseCargaTitulosTRDTO;
import com.mx.dla.dda.contrato.transaccion.ws.titulos.dtos.ResponseNotificarInventarioTitulosDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ParamCargaTitulosDTO;
import com.mx.dla.dda.contrato.ws.cargaTitulos.ResponseCargaTitulosDTO;
import com.mx.dla.dda.excelMapper.bos.BeanPopulator;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TituloTranBO
extends BaseBO {
    @Autowired
    private GeneralesDAO generalesDAO;
    @Autowired
    private TituloLoteTransDAO tituloLoteDAO;
    @Autowired
    private TituloTransDAO tituloDAO;
    @Autowired
    private BeanPopulator beanPopulator;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    @Value(value="${uri.file.titulos}")
    protected String uriErrores;
    @Value(value="${uri.file.carga.titulosTR}")
    protected String uriCarga;

    public void init(Long idContrato, Date fechaInicio, boolean isAuto) {
        Lista lista = this.tituloDAO.buscarListaActual(idContrato, "T");
        if (lista == null) {
            lista = this.crearListaNueva(idContrato, fechaInicio, "T");
        }
        if (!isAuto) {
            this.createMirrorEntities(idContrato);
        }
    }

    public Lista crearListaNueva(Long idContrato, Date fechaInicio, String prefix) {
        Lista l = new Lista(idContrato, fechaInicio, prefix);
        this.tituloDAO.insertarLista(l, prefix, idContrato, fechaInicio);
        return l;
    }

    public Lista buscarListaActual(Long idContrato, String prefix) {
        Lista lista = this.tituloDAO.buscarListaActual(idContrato, prefix);
        return lista;
    }

    public void createMirrorEntities(Long idContrato) {
        this.tituloLoteDAO.borrarTitulosPorContratoTran("M", idContrato);
        this.tituloLoteDAO.borrarListaPorIdContrato("M", idContrato);
        this.tituloLoteDAO.moverLista("T", "M", idContrato);
        this.tituloLoteDAO.moverTitulos("T", "M", idContrato);
    }

    public void guardarCambiosPermanente(Long idContrato) {
        TituloValidaEstatusDTO estatus = null;
        ResponseNotificarInventarioTitulosDTO responsenotificainventario = null;
        this.tituloLoteDAO.borrarTitulosPorContratoTran("T", idContrato);
        this.tituloLoteDAO.borrarListaPorIdContrato("T", idContrato);
        this.tituloLoteDAO.moverLista("M", "T", idContrato);
        this.tituloLoteDAO.moverTitulos("M", "T", idContrato);
        try {
            this.tituloLoteDAO.calcularMG(idContrato);
            estatus = this.validaEstatusContrato(idContrato);
            Long idEstatus = estatus.getEstatus();
            if (idEstatus == 5L) {
                responsenotificainventario = this.notificarInventarioTitulos(idContrato);
            } else {
                this.logger.info("notificarInventarioTitulos. No se Notifico, el contrato no esta vigente: " + idContrato);
            }
        }
        catch (Exception e) {
            this.logger.error("Error.calcularMG - al notificar el contrato:__" + e);
        }
    }

    public TituloValidaEstatusDTO validaEstatusContrato(Long idContrato) throws TransaccionException {
        TituloValidaEstatusDTO estatuscontrato = null;
        try {
            estatuscontrato = this.tituloLoteDAO.validaEstatusContrato(idContrato);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error.TituloTranBO - al validar el estatus del Contrato.", ex);
        }
        return estatuscontrato;
    }

    public ResponseNotificarInventarioTitulosDTO notificarInventarioTitulos(Long idContrato) throws TransaccionException {
        ResponseNotificarInventarioTitulosDTO response = null;
        ParamInventarioTitulosDTO request = new ParamInventarioTitulosDTO();
        DLARestClient client = null;
        try {
            Long idContratoTrans = idContrato;
            client = this.dlaRestClientFactory.getClient(DLARestServices.WS_TRANSACCIONTITULOS_NOTIFICAR_INVENTARIOS);
            request.setIdContrato(idContratoTrans.toString());
            this.logger.debug("REQUEST - WS_TRANSACCIONTITULOS_NOTIFICAR_INVENTARIOS : [{}]", (Object)request);
            response = client.get(request, ResponseNotificarInventarioTitulosDTO.class);
            this.logger.debug("RESPONSE . WS_TRANSACCIONTITULOS_NOTIFICAR_INVENTARIOS : [{}]", (Object)response);
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al ejecutar el recalculo de pago.", ex);
        }
        return response;
    }

    public byte[] generateExcelReport(Long idLista) throws ExcelMapperException, IOException {
        this.logger.debug("Descargar archivo de excel [{}]", (Object)idLista);
        List<TituloTransaccionExcel> lista = new ArrayList();
        try {
            lista = this.tituloDAO.obtenerTitulosExcel(idLista);
            if (lista == null || lista.isEmpty()) {
                lista = new ArrayList();
                lista.add(this.beanPopulator.initObject(TituloTransaccionExcel.class));
            }
            this.logger.debug("Descargar archivo, se han  obtenido [{}]", (Object)lista.size());
        }
        catch (Exception e) {
            this.logger.error("Error al buscar contenido de titulos");
        }
        byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(lista, "tituloTransaccionExportarLista", TituloTransaccionExcel.class);
        this.logger.debug("Descargar archivo, se ha generado binario.");
        return fileExcel;
    }

    public String generaNombreDescarga() {
        Date a = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        String fileFileName = "plantilla-" + sdf.format(a) + ".xlsx";
        return fileFileName;
    }

    public RespuestaCargaExcel cargaMasivaTitulos(String inicioLista, Long idContrato, String tc, File fileUpload, String fileName, Long idLista, String expediente) throws TituloException, Exception {
        RespuestaCargaExcel r = new RespuestaCargaExcel();
        idLista = this.ajustarListaEnmiendas(tc, inicioLista, idContrato, idLista);
        File archivo = this.guardarArchivoSistema(idContrato, expediente, fileName, fileUpload);
        ParamCargaTitulosTRDTO request = this.generaObjRequestWs(idContrato, expediente, idLista, tc, archivo.getCanonicalPath(), inicioLista);
        ResponseCargaTitulosTRDTO response = this.llamadaRestCargaTransaccionesTitulos(request, idContrato);
        r = this.actualizaLista(idContrato);
        r.setResponseTR(response);
        return r;
    }

    public Long ajustarListaEnmiendas(String tc, String inicioLista, Long idContrato, Long idLista) throws ParseException {
        if (tc.compareTo(TipoCargaDocumento.NUEVA.getValue()) == 0) {
            SimpleDateFormat formatter = new SimpleDateFormat("MM-dd-yyyy");
            Date fecha = formatter.parse(inicioLista);
            Lista listaA = this.tituloDAO.buscarListaActual(idContrato, "M");
            this.tituloDAO.actualizarFechaFinLista(listaA.getIdLista(), "M", this.calculaFechaMenosUnDia(fecha));
            Lista nueva = this.crearListaNueva(idContrato, fecha, "M");
            idLista = nueva.getIdLista();
        }
        return idLista;
    }

    public File guardarArchivoSistema(Long idContrato, String expediente, String fileName, File fileUpload) throws IOException {
        byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
        File d = new File(this.uriCarga + idContrato + expediente + fileName);
        d.setExecutable(true, false);
        d.setReadable(true, false);
        d.setWritable(true, false);
        this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
        FileUtils.writeByteArrayToFile((File)d, (byte[])f);
        return d;
    }

    public ParamCargaTitulosDTO generaObjetoRequestRest(Long idContrato, String expediente, Long idLista, String tipoCambio, String archivo, String fechaInicioLista) {
        ParamCargaTitulosDTO request = new ParamCargaTitulosDTO();
        request.setNombreArchivo(FilenameUtils.getName((String)archivo));
        request.setIdContrato(idContrato.toString());
        request.setIdListaActual(idLista.toString());
        request.setTipoLista(TipoCargaDocumento.NUEVA.getValue().equals(tipoCambio) ? "NUEVA" : "ACTUAL");
        request.setTipoCarga(TipoCargaDocumento.ANEXAR.getValue().equals(tipoCambio) ? "AGREGAR" : "REEMPLAZAR");
        request.setExpediente(expediente);
        request.setFechaInicioListaNueva(fechaInicioLista != null ? fechaInicioLista : "");
        this.logger.debug("Request carga titulos [{}]", (Object)request);
        return request;
    }

    public ParamCargaTitulosTRDTO generaObjRequestWs(Long idContrato, String expediente, Long idLista, String tipoCambio, String archivo, String fechaInicioLista) {
        ParamCargaTitulosTRDTO request = new ParamCargaTitulosTRDTO();
        request.setNombreArchivo(FilenameUtils.getName((String)archivo));
        request.setIdContrato(idContrato.toString());
        request.setIdListaActual(idLista.toString());
        request.setTipoLista(TipoCargaDocumento.NUEVA.getValue().equals(tipoCambio) ? "NUEVA" : "ACTUAL");
        request.setTipoCarga(TipoCargaDocumento.ANEXAR.getValue().equals(tipoCambio) ? "AGREGAR" : "REEMPLAZAR");
        request.setExpediente(expediente);
        request.setFechaInicioListaNueva(fechaInicioLista != null ? fechaInicioLista : "");
        this.logger.debug("Request carga transacciones titulos [{}]", (Object)request);
        return request;
    }

    public ResponseCargaTitulosDTO llamarRestCargaTitulos(ParamCargaTitulosDTO request, Long idContrato) throws TituloException {
        DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.CARGA_TITULOS);
        ResponseCargaTitulosDTO response = c.get(request, ResponseCargaTitulosDTO.class);
        this.logger.info("Response carga titulos [{}]", (Object)response);
        this.generaArchivoErrores(response, idContrato);
        return response;
    }

    public ResponseCargaTitulosTRDTO llamadaRestCargaTransaccionesTitulos(ParamCargaTitulosTRDTO request, Long idContrato) throws TituloException {
        DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.WS_TRANSACCION_TITULOS_CARGA);
        ResponseCargaTitulosTRDTO response = c.get(request, ResponseCargaTitulosTRDTO.class);
        this.logger.info("Response carga titulos [{}]", (Object)response);
        this.generaExcelErrores(response, idContrato);
        return response;
    }

    public void generaExcelErrores(ResponseCargaTitulosTRDTO response, Long idContrato) throws TituloException {
        try {
            if (!response.getDatosCarga().getTOTAL_ERROR().equals("0")) {
                List a = new ArrayList();
                a = this.tituloDAO.obtenerTitulosExcelError(Long.valueOf(Long.parseLong(response.getDatosCarga().getID_CARGA())));
                this.logger.debug("{}", (Object)a.toString());
                byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(a, "tituloTransaccionExcel", TituloTransaccionExcel.class);
                File destFile = new File(this.uriErrores + idContrato + ".xlsx");
                FileUtils.writeByteArrayToFile((File)destFile, (byte[])fileExcel);
            }
        }
        catch (ExcelMapperException e) {
            this.logger.error("Errores [{}]", (Object)e.getSErrors());
            this.logger.error("Error al leer el archivo", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new TituloException("Ocurrio un error al subir el documento transacciones.Titulo");
        }
    }

    public void generaArchivoErrores(ResponseCargaTitulosDTO response, Long idContrato) throws TituloException {
        try {
            if (!response.getDatosCarga().getTOTAL_ERROR().equals("0")) {
                List a = new ArrayList();
                a = this.tituloDAO.obtenerTitulosExcelError(Long.valueOf(Long.parseLong(response.getDatosCarga().getID_CARGA())));
                this.logger.debug("{}", (Object)a.toString());
                byte[] fileExcel = this.excelMapperTransform.transformObjectToExcel(a, "tituloTransaccionExcel", TituloTransaccionExcel.class);
                File destFile = new File(this.uriErrores + idContrato + ".xlsx");
                FileUtils.writeByteArrayToFile((File)destFile, (byte[])fileExcel);
            }
        }
        catch (ExcelMapperException e) {
            this.logger.error("Errores [{}]", (Object)e.getSErrors());
            this.logger.error("Error al leer el archivo", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new TituloException("Ocurrio un error al subir el documento");
        }
    }

    public RespuestaCargaExcel actualizaLista(Long idContrato) {
        RespuestaCargaExcel r = new RespuestaCargaExcel();
        Lista listaA = this.tituloDAO.buscarListaActual(idContrato, "T");
        r.setLista(listaA);
        return r;
    }

    public List<TipoCargaDocumento> buscaTipoCargaDocumento(Long idContrato) {
        ArrayList<TipoCargaDocumento> r = new ArrayList<TipoCargaDocumento>();
        r.add(TipoCargaDocumento.ANEXAR);
        r.add(TipoCargaDocumento.REEMPLAZAR);
        ContratoDTO contrato = this.generalesDAO.obtenerContrato(idContrato);
        if (contrato.getIdTipoMovimiento().intValue() == Movimiento.Enmienda.getValor().intValue()) {
            r.add(TipoCargaDocumento.NUEVA);
        }
        return r;
    }

    public List<CatalogoDTO> buscaListas(Long idContrato) {
        return this.tituloDAO.buscarCatListaByContrato(idContrato, "T");
    }

    public List<Long> buscaListasValidas(Long idContrato) {
        return this.tituloDAO.buscarListaValidas(idContrato, "T");
    }

    public byte[] buscarArchivoDeErrores(Long idContrato) throws IOException {
        File file = new File(this.uriErrores + idContrato + ".xlsx");
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        byte[] errores = FileUtils.readFileToByteArray((File)file);
        return errores;
    }

    public Integer buscarNumTitulosContratados(Long idContrato) throws IOException {
        return this.tituloDAO.obtenerNumTitulos(idContrato);
    }

    public Date calculaFechaMenosUnDia(Date in) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(in);
        cal.set(6, cal.get(6) - 1);
        return cal.getTime();
    }
}

