/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.factura.general.bos;

import com.mx.dla.dda.factura.general.dtos.ContratoFacturaDTO;
import com.mx.dla.dda.factura.general.dtos.FacturaGeneralDTO;
import com.mx.dla.dda.factura.ws.dtos.DTFactura;
import com.mx.dla.dda.factura.ws.dtos.DTMovimientoFinalPO;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ConvertidordDto2Rest
extends BaseBO {
    @Value(value="${factura.header.sociedad}")
    protected String sociedad;
    @Value(value="${factura.header.indicador}")
    protected String indicador;
    @Value(value="${factura.header.tipoDocumento}")
    protected String tipoDocumento;
    @Value(value="${factura.header.moneda}")
    protected String moneda;
    @Value(value="${factura.detalle.impuesto}")
    protected String impuesto;
    @Value(value="${factura.detalle.cantidad}")
    protected String cantidad;
    @Value(value="${envMov.indEntregaFinal}")
    protected String indEntregaFinal;
    @Value(value="${envMov.indFacturaFinal}")
    protected String indFacturaFinal;
    @Value(value="${envMov.noItem}")
    protected String noItem;

    public DTFactura generaFacturaWS(FacturaGeneralDTO facturaDTO, String estudio, String monedaEstudio, String iso) {
        DTFactura message = new DTFactura();
        DTFactura.Factura factura = this.generaFactura(facturaDTO, estudio, monedaEstudio);
        factura.setgetPosicion(this.generaPosiciones(facturaDTO.getContratos(), iso, facturaDTO.getIndicadorIva()));
        message.setFactura(factura);
        this.print(factura);
        return message;
    }

    public DTFactura.Factura generaFactura(FacturaGeneralDTO facturaDTO, String estudio, String monedaEstudio) {
        SimpleDateFormat ft = new SimpleDateFormat("dd.MM.yyyy");
        DTFactura.Factura factura = new DTFactura.Factura();
        factura.setSociedad(this.sociedad);
        factura.setIndicador(this.indicador);
        factura.setTipoDoc(this.tipoDocumento);
        factura.setMoneda(monedaEstudio);
        factura.setTexto(estudio);
        factura.setMonto(facturaDTO.getMonto());
        factura.setReferencia(facturaDTO.getNumeroFactura());
        factura.setFechaFactura(ft.format(facturaDTO.getFechaFactura()));
        factura.setFechaContabilizacion(ft.format(new Date()));
        return factura;
    }

    public List<DTFactura.Factura.Posicion> generaPosiciones(List<ContratoFacturaDTO> facturaDetalles, String iso, String indicador) {
        ArrayList<DTFactura.Factura.Posicion> pocisiones = new ArrayList<DTFactura.Factura.Posicion>();
        Integer posicionNum = 10;
        for (int i = 0; i < facturaDetalles.size(); ++i) {
            String posicionStr = "000" + posicionNum;
            DTFactura.Factura.Posicion posicion = new DTFactura.Factura.Posicion();
            posicion.setCantidad(this.cantidad);
            posicion.setIndImpuesto(indicador);
            posicion.setUnMedidaISO(iso);
            posicion.setPosicion(posicionStr);
            posicion.setPosicionPO("00010");
            posicion.setImporte(facturaDetalles.get(i).getTotal().toString());
            posicion.setPedido(facturaDetalles.get(i).getIdSapCto());
            pocisiones.add(posicion);
            posicionNum = posicionNum + 10;
        }
        return pocisiones;
    }

    public DTMovimientoFinalPO generaRegistro(String idSap) {
        DTMovimientoFinalPO message = new DTMovimientoFinalPO();
        DTMovimientoFinalPO.Registro registro = new DTMovimientoFinalPO.Registro();
        DTMovimientoFinalPO.Registro.Item item = new DTMovimientoFinalPO.Registro.Item();
        item.setIndEntregaFin(this.indEntregaFinal);
        item.setIndFacturaFinal(this.indFacturaFinal);
        item.setNumItem(this.noItem);
        registro.getItem().add(item);
        registro.setNumDoc(idSap);
        message.setRegistro(registro);
        this.print(registro);
        return message;
    }

    public void print(DTMovimientoFinalPO.Registro registro) {
        this.logger.debug("numdov: " + registro.getNumDoc());
        if (registro.getItem() != null) {
            for (DTMovimientoFinalPO.Registro.Item reg : registro.getItem()) {
                this.logger.debug("num: " + reg.getNumItem());
            }
        }
    }

    public void print(DTFactura.Factura factura) {
        this.logger.debug("Sociedad: " + factura.getSociedad());
        this.logger.debug("Referencia: " + factura.getReferencia());
        this.logger.debug("Indicador: " + factura.getIndicador());
        this.logger.debug("TipoDoc: " + factura.getTipoDoc());
        this.logger.debug("FechaContabilizacion: " + factura.getFechaContabilizacion());
        this.logger.debug("FechaFactura: " + factura.getFechaFactura());
        this.logger.debug("Moneda: " + factura.getMoneda());
        this.logger.debug("Texto: " + factura.getTexto());
        this.logger.debug("Monto: " + factura.getMonto());
        this.logger.debug("**Posiciones**");
        if (factura.getPosicion() != null) {
            for (DTFactura.Factura.Posicion posicion : factura.getPosicion()) {
                this.logger.debug("Cantidad: " + posicion.getCantidad());
                this.logger.debug("Importe: " + posicion.getImporte());
                this.logger.debug("IndImpuesto: " + posicion.getIndImpuesto());
                this.logger.debug("Pedido: " + posicion.getPedido());
                this.logger.debug("Posicion: " + posicion.getPosicion());
                this.logger.debug("PosicionPO: " + posicion.getPosicionPO());
                this.logger.debug("UnMedidaISO: " + posicion.getUnMedidaISO());
            }
        }
    }
}

