/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.factura.listado.bos;

import com.mx.dla.dda.factura.listado.daos.FacturaListadoDAO;
import com.mx.dla.dda.factura.listado.dtos.FacturaListadoDTO;
import com.mx.dla.dda.factura.listado.dtos.FacturaListadoPantalla;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FacturaListadoBO
extends BaseBO {
    @Autowired
    private FacturaListadoDAO facturaListadoDAO;

    public List<FacturaListadoPantalla> getListadoFacturas(List<Integer> estudios, String numeroFact) {
        ArrayList<FacturaListadoPantalla> listado = new ArrayList<FacturaListadoPantalla>();
        if (numeroFact != null) {
            numeroFact = numeroFact + "%";
        }
        this.logger.debug("num:" + numeroFact);
        List listadoBd = this.facturaListadoDAO.getListadoFacturas(estudios, numeroFact);
        for (FacturaListadoDTO item : listadoBd) {
            FacturaListadoPantalla pantalla = this.dto2pantallaListadoFactura(item);
            listado.add(pantalla);
        }
        return listado;
    }

    public void eliminarListadoFactura(Long idFactura) {
        this.facturaListadoDAO.eliminarListadoFacturaDetalle(idFactura);
        this.facturaListadoDAO.eliminarListadoFactura(idFactura);
    }

    private FacturaListadoPantalla dto2pantallaListadoFactura(FacturaListadoDTO factura) {
        FacturaListadoPantalla pantallaItem = new FacturaListadoPantalla();
        pantallaItem.setNumero(factura.getNumero());
        pantallaItem.setEstudio(factura.getEstudio());
        pantallaItem.setFacturaSap(factura.getFacturaSap());
        pantallaItem.setDocumentoSap(factura.getDocumentoSap());
        Calendar cal = Calendar.getInstance();
        cal.setTime(factura.getFecha());
        int anio = cal.get(1);
        int mes = cal.get(2);
        int dia = cal.get(5);
        String fecha = "" + (mes + 1) + "/" + dia + "/" + anio;
        pantallaItem.setFecha(fecha);
        pantallaItem.setApproved(String.valueOf(factura.getApproved()));
        pantallaItem.setSap(String.valueOf(factura.getSap()));
        pantallaItem.setAmount(factura.getAmount());
        if (pantallaItem.getApproved().compareTo("1") == 0) {
            pantallaItem.setAcciones("1");
        } else {
            pantallaItem.setAcciones("2");
        }
        pantallaItem.setIdFactura(String.valueOf(factura.getIdFactura()));
        return pantallaItem;
    }
}

