/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.amortizacion.baseActivos.bos;

import com.mx.dla.dda.reporte.ws.dtos.ParamGeneraReporteDTO;
import com.mx.dla.dda.reporte.ws.dtos.ResponseGeneraReporteDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BaseActivosBO
extends BaseBO {
    @Value(value="${uri.file.reporte.baseActivosSQL}")
    protected String uriSQL;
    @Value(value="${uri.file.reporte.txtcpv}")
    protected String uriTXT;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;
    ArrayList<String> textoSQLReporte = new ArrayList();
    ResponseGeneraReporteDTO responseDTO = null;

    public ResponseGeneraReporteDTO generaReporteBaseActivos(String fileName, Long anio, Long anioFin) throws IOException {
        String fecha = anio.toString();
        String fechaFin = anioFin.toString();
        this.textoSQLReporte.clear();
        this.textoSQLReporte.add("SET trimspool ON;");
        this.textoSQLReporte.add("SET heading OFF;");
        this.textoSQLReporte.add("SET headsep OFF;");
        this.textoSQLReporte.add("SET linesize 20000;");
        this.textoSQLReporte.add("SET pagesize 0;");
        this.textoSQLReporte.add("SET TERMOUT OFF;");
        this.textoSQLReporte.add("SET NEWPAGE 0;");
        this.textoSQLReporte.add("SET SPACE 0;");
        this.textoSQLReporte.add("SET ECHO OFF;");
        this.textoSQLReporte.add("SET FEEDBACK OFF;");
        this.textoSQLReporte.add("SET MARKUP HTML OFF SPOOL OFF;");
        this.textoSQLReporte.add("SET VERIFY OFF;");
        this.textoSQLReporte.add("SET DEFINE OFF;");
        this.textoSQLReporte.add("SET serveroutput on size 1000000;");
        this.textoSQLReporte.add("spool " + this.uriTXT + fileName + ".txt;");
        this.textoSQLReporte.add("--[BEGIN]");
        this.textoSQLReporte.add("select 'GRUPO|APARTADO|ID_SAP|ESTUDIO|CONTRATO|CONT_INICIO|CONT_FIN|ID|ID_BV|TITULO|NOMBRE_UNICO|TEMPORADA|EPISODIO|FECHA_INICIO|FECHA_FIN|COSTO|ANNIO|ENERO|FEBRERO|MARZO|ABRIL|MAYO|JUNIO|JULIO|AGOSTO|SEPTIEMBRE|OCTUBRE|NOVIEMBRE|DICIEMBRE|TOTAL|' as X from dual;");
        this.textoSQLReporte.add("--[END_HEADER]");
        this.textoSQLReporte.add("select GRUPO||'|'||APARTADO||'|'||ID_SAP||'|'||ESTUDIO||'|'||NUMERO_CONTRATO||'|'||C_FECHA_INICIO||'|'||C_FECHA_FIN||'|'||ID||'|'||ID_BV||'|'||TITULO||'|'||NOMBRE_UNICO||'|'||TEMPORADA||'|'||EPISODIO||'|'||FECHA_INICIO||'|'||FECHA_FIN||'|'||COSTO||'|'|| ");
        this.textoSQLReporte.add(" ANNIO||'|'||MES_1||'|'||MES_2||'|'||MES_3||'|'||MES_4||'|'||MES_5||'|'||MES_6||'|'||MES_7||'|'||MES_8||'|'||MES_9||'|'||MES_10||'|'||MES_11||'|'||MES_12||'|'||(MES_1 + MES_2 + MES_3 + MES_4 + MES_5 + MES_6 + MES_7 + MES_8 + MES_9 + MES_10 + MES_11 + MES_12)||'|' as X");
        this.textoSQLReporte.add(" from ( select NVL( GRUPO, '' ) as GRUPO, APARTADO, ID_SAP, NVL( ESTUDIO, 'Total' ) as ESTUDIO, NUMERO_CONTRATO, C_FECHA_INICIO, C_FECHA_FIN, ID_TITULO_CNTORIG as ID, ID_BV, TITULO,nombre_unico, TEMPORADA, EPISODIO, FECHA_INICIO, FECHA_FIN, COSTO, ANNIO, ");
        this.textoSQLReporte.add(" ROUND( SUM(MES_1), 4 ) as MES_1, ROUND( SUM(MES_2), 4 ) as MES_2, ROUND( SUM(MES_3), 4 ) as MES_3, ROUND( SUM(MES_4), 4 ) as MES_4, ROUND( SUM(MES_5), 4 ) as MES_5, ROUND( SUM(MES_6), 4 ) as MES_6, ROUND( SUM(MES_7), 4 ) as MES_7, ");
        this.textoSQLReporte.add(" ROUND( SUM(MES_8), 4 ) as MES_8, ROUND( SUM(MES_9), 4 ) as MES_9, ROUND( SUM(MES_10), 4 ) as MES_10, ROUND( SUM(MES_11), 4 ) as MES_11, ROUND( SUM(MES_12), 4 ) as MES_12 ");
        this.textoSQLReporte.add(" from ( select grp.DESC_GRUPO as GRUPO, ado.DESC_APARTADO as APARTADO, est.ID_SAP, est.DESC_ESTUDIO as ESTUDIO, sub.ID_CONTRATO_ORIGINAL, cnt.NUMERO_CONTRATO, to_char( cnt.FECHA_INICIO, 'dd/mm/yyyy' ) as C_FECHA_INICIO, to_char( cnt.FECHA_FIN, 'dd/mm/yyyy' ) as C_FECHA_FIN, ");
        this.textoSQLReporte.add(" sub.ID_TITULO_CNTORIG, tit.TITULO,tit.nombre_unico, tit.TEMPORADA, tit.EPISODIO, tit.ID_BV, tit.COSTO, to_char( tit.FECHA_INICIO, 'dd/mm/yyyy' ) as FECHA_INICIO, to_char( tit.FECHA_FIN, 'dd/mm/yyyy' ) as FECHA_FIN, sub.ANNIO, sub.MES_1, sub.MES_2, sub.MES_3, sub.MES_4, sub.MES_5, sub.MES_6, sub.MES_7, sub.MES_8, sub.MES_9, sub.MES_10, sub.MES_11, sub.MES_12 ");
        this.textoSQLReporte.add(" from ( select ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO, SUM( MES_1 ) as MES_1, SUM( MES_2 ) as MES_2, SUM( MES_3 ) as MES_3, SUM( MES_4 ) as MES_4, SUM( MES_5 ) as MES_5, SUM( MES_6 ) as MES_6, SUM( MES_7 ) as MES_7, SUM( MES_8 ) as MES_8, SUM( MES_9 ) as MES_9, SUM( MES_10 ) as MES_10, SUM( MES_11 ) as MES_11, SUM( MES_12 ) as MES_12 ");
        this.textoSQLReporte.add(" from ( select ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO, NVL( MES_1, 0 ) as MES_1, NVL( MES_2, 0 ) as MES_2, NVL( MES_3, 0 ) as MES_3, NVL( MES_4, 0 ) as MES_4, NVL( MES_5, 0 ) as MES_5, NVL( MES_6, 0 ) as MES_6, NVL( MES_7, 0 ) as MES_7, NVL( MES_8, 0 ) as MES_8, NVL( MES_9, 0 ) as MES_9, NVL( MES_10, 0 ) as MES_10, NVL( MES_11, 0 ) as MES_11, NVL( MES_12, 0 ) as MES_12 ");
        this.textoSQLReporte.add(" from ( select distinct amor.ID_CONTRATO_ORIGINAL, amor.ID_TITULO_CNTORIG, TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) as ANNIO, TO_NUMBER( TO_CHAR( amor.MES, 'mm' ) ) as MESES, amor.MES, TO_NUMBER( amor.MONTO ) as MONTO from DDA_T_AMORTIZACION amor where TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) >= ");
        this.textoSQLReporte.add(fecha + " and TO_NUMBER( TO_CHAR( amor.MES, 'yyyy' ) ) <= " + fechaFin);
        this.textoSQLReporte.add(" ) PIVOT( SUM( MONTO ) FOR MESES in ( 1 as MES_1, 2 as MES_2, 3 as MES_3, 4 as MES_4, 5 as MES_5, 6 as MES_6, 7 as MES_7, 8 as MES_8, 9 as MES_9, 10 as MES_10, 11 as MES_11, 12 as MES_12 ) ) ) group by  ID_CONTRATO_ORIGINAL, ID_TITULO_CNTORIG, ANNIO ) sub, ");
        this.textoSQLReporte.add(" ( SELECT scnt.ID_CONTRATO_ORIGINAL as ID_CONTRATO, ct.ID_TITULO_CNTORIG, ct.ID_BV, ct.DESC_TITULO AS TITULO,ct.nombre_unico, ct.TEMPORADA, ct.EPISODIO, ct.FECHA_INICIO, ct.FECHA_FIN, ct.COSTO FROM DDA_T_CONTRATO_TITULO ct, ( SELECT ID_CONTRATO_ORIGINAL, MAX( ID_CONTRATO ) AS ID_CONTRATO FROM DDA_T_CONTRATO WHERE ID_TIPO_CONTRATO = 1 GROUP BY ID_CONTRATO_ORIGINAL ) scnt WHERE ct.ID_CONTRATO = scnt.ID_CONTRATO ) tit, ");
        this.textoSQLReporte.add(" DDA_T_CONTRATO cnt, DDA_C_ESTUDIO est, DDA_C_ESTUDIO_GRUPO grp, DDA_T_APARTADO ado where sub.ID_CONTRATO_ORIGINAL = cnt.ID_CONTRATO and cnt.ID_ESTUDIO = est.ID_ESTUDIO and est.ID_GRUPO = grp.ID_GRUPO and sub.ID_TITULO_CNTORIG = tit.ID_TITULO_CNTORIG and cnt.ID_CONTRATO = tit.ID_CONTRATO ");
        this.textoSQLReporte.add(" and cnt.ID_APARTADO = ado.ID_APARTADO and cnt.ID_ESTATUS in ( 4, 5, 6 ) ) group by grouping sets ( ( ANNIO ), ( GRUPO, APARTADO, ID_SAP, ESTUDIO, NUMERO_CONTRATO, C_FECHA_INICIO, C_FECHA_FIN, ID_TITULO_CNTORIG, ID_BV, TITULO,nombre_unico, TEMPORADA, EPISODIO, FECHA_INICIO, FECHA_FIN, COSTO, ANNIO ) ) ORDER BY ANNIO, GRUPO nulls last, ESTUDIO nulls last, TITULO );");
        this.textoSQLReporte.add("--[END]");
        this.textoSQLReporte.add("quit");
        this.logger.info("Archivo: [{}]", (Object)fileName);
        File file = new File(this.uriSQL + fileName + ".sql");
        FileUtils.writeLines((File)file, this.textoSQLReporte);
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        if (file.exists()) {
            try {
                this.logger.info("se envia el WS generaReporteWS.");
                this.responseDTO = this.generaReporteWS(fileName);
            }
            catch (Exception e) {
                this.logger.debug(e.toString());
            }
        }
        return this.responseDTO;
    }

    public ResponseGeneraReporteDTO generaReporteBaseActivos(String fileName, String anio, String anioFin, Boolean estatus) throws IOException {
        String fecha = anio.toString();
        String fechaFin = anioFin.toString();
        this.textoSQLReporte.clear();
        this.textoSQLReporte.add("SET trimspool ON;");
        this.textoSQLReporte.add("SET heading OFF;");
        this.textoSQLReporte.add("SET headsep OFF;");
        this.textoSQLReporte.add("SET linesize 20000;");
        this.textoSQLReporte.add("SET pagesize 0;");
        this.textoSQLReporte.add("SET TERMOUT OFF;");
        this.textoSQLReporte.add("SET NEWPAGE 0;");
        this.textoSQLReporte.add("SET SPACE 0;");
        this.textoSQLReporte.add("SET ECHO OFF;");
        this.textoSQLReporte.add("SET FEEDBACK OFF;");
        this.textoSQLReporte.add("SET MARKUP HTML OFF SPOOL OFF;");
        this.textoSQLReporte.add("SET VERIFY OFF;");
        this.textoSQLReporte.add("SET DEFINE OFF;");
        this.textoSQLReporte.add("SET serveroutput on size 1000000;");
        this.textoSQLReporte.add("spool " + this.uriTXT + fileName + ".txt;");
        this.textoSQLReporte.add("select 'Estudio|Contrato|Nombre \u00fanico|Nombre est\u00e1ndar|Id Broadview|Temporada|Episodio|Inicio vigencia|Fin vigencia|VU|Categor\u00eda|Costo' from dual;");
        this.textoSQLReporte.add("--[BEGIN]");
        this.textoSQLReporte.add("select");
        this.textoSQLReporte.add("est.DESC_ESTUDIO||'|'||");
        this.textoSQLReporte.add("cnt.numero_contrato||'|'||");
        this.textoSQLReporte.add("tit.nombre_unico||'|'||");
        this.textoSQLReporte.add("tit.desc_titulo||'|'||");
        this.textoSQLReporte.add("tit.ID_BV||'|'||");
        this.textoSQLReporte.add("tit.Temporada||'|'||");
        this.textoSQLReporte.add("tit.Episodio||'|'||");
        this.textoSQLReporte.add("TO_CHAR(tit.fecha_inicio,'dd/mm/yyyy')||'|'||");
        this.textoSQLReporte.add("TO_CHAR(tit.fecha_fin,'dd/mm/yyyy')||'|'||");
        this.textoSQLReporte.add("tit.VIDA_UTIL||'|'||");
        this.textoSQLReporte.add("cat.desc_categoria||'|'||");
        this.textoSQLReporte.add("tit.Costo");
        this.textoSQLReporte.add("from ");
        this.textoSQLReporte.add("dda_t_contrato_titulo tit right join dda_t_contrato cnt on cnt.id_contrato = tit.id_contrato right join dda_c_estudio est on cnt.id_estudio = est.id_estudio,");
        this.textoSQLReporte.add("dda_c_categoria cat");
        this.textoSQLReporte.add("where ");
        this.textoSQLReporte.add("tit.fecha_inicio >= to_date('" + anio + "','dd/MM/yyyy')");
        this.textoSQLReporte.add("and tit.fecha_fin <= to_date('" + anioFin + "','dd/MM/yyyy')");
        this.textoSQLReporte.add("and tit.ID_CATEGORIA_TIT = cat.id_categoria");
        if (estatus.booleanValue()) {
            this.textoSQLReporte.add("and tit.estatus = 'ACTIVO'");
        }
        this.textoSQLReporte.add("order by tit.fecha_inicio;");
        this.textoSQLReporte.add("--[END]");
        this.textoSQLReporte.add("quit");
        this.logger.info("Archivo: [{}]", (Object)fileName);
        File file = new File(this.uriSQL + fileName + ".sql");
        FileUtils.writeLines((File)file, this.textoSQLReporte);
        this.logger.debug("busca archivo en [{}]", (Object)file.getAbsolutePath());
        if (file.exists()) {
            try {
                this.logger.info("se envia el WS generaReporteWS.");
                this.responseDTO = this.generaReporteWS(fileName);
            }
            catch (Exception e) {
                this.logger.debug(e.toString());
            }
        }
        return this.responseDTO;
    }

    public ResponseGeneraReporteDTO generaReporteWS(String archivo) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.GENERA_REPORTE_AMORTIZACION_BA);
        ParamGeneraReporteDTO request = new ParamGeneraReporteDTO();
        this.logger.info("Antes de configurar par\u00e1metros.");
        request.setNombreArchivo(archivo);
        request.setFormato("txt");
        request.setComprimir("y");
        this.logger.info("Despues de configurar par\u00e1metros.");
        this.logger.info("Request rest ReporteAmortBaseActivos [{}]", (Object)request);
        ResponseGeneraReporteDTO response = client.get(request, ResponseGeneraReporteDTO.class);
        this.logger.info("Response rest ReporteAmortBaseActivos [{}]", (Object)response);
        return response;
    }
}

