/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.amortizacion.bos;

import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.reporte.amortizacion.daos.ReporteAmortizacionDAO;
import com.mx.dla.dda.reporte.amortizacion.dtos.MesesAmortizacionDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReporteExcelAmortizacionBO
extends BaseBO {
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    private ReporteAmortizacionDAO reporteAmortizacionDAO;
    private final String[] smeses = new String[]{"ENE", "FEB", "MAR", "ABR", "MAY", "JUN", "JUL", "AGO", "SEP", "OCT", "NOV", "DIC"};

    public byte[] generaReporteAmortizacion(Long idEstudio, String fecha) {
        List reporte = null;
        byte[] fileExcel = null;
        try {
            reporte = this.reporteAmortizacionDAO.obtenerMesesAmortizacion(idEstudio, fecha);
            if (reporte.isEmpty()) {
                reporte.add(this.getVacio());
            }
            this.logger.debug("{}", (Object)reporte);
        }
        catch (Exception e) {
            this.logger.error("Error: " + e);
        }
        fileExcel = this.generarExcel(fecha, reporte);
        return fileExcel;
    }

    public byte[] generaReporteAmortizacionSAP(Long idEstudio, String fecha) {
        List reporte = null;
        byte[] fileExcel = null;
        try {
            reporte = this.reporteAmortizacionDAO.obtenerMesesAmortizacionSAP(idEstudio, fecha);
            if (reporte.isEmpty()) {
                reporte.add(this.getVacio());
            }
            this.logger.debug("{}", (Object)reporte);
        }
        catch (Exception e) {
            this.logger.error("Error: " + e);
        }
        fileExcel = this.generarExcel(fecha, reporte);
        return fileExcel;
    }

    public byte[] generaReporteAmortizacionSAPDLA(Long idEstudio, String fecha) {
        ByteArrayOutputStream baos = null;
        try {
            Integer year = Integer.parseInt(fecha.substring(3));
            Integer month = Integer.parseInt(fecha.substring(0, 2));
            String day = "01/";
            Map<String, List<MesesAmortizacionDTO>> reporte = this.getResults(idEstudio, day.concat(year.toString()));
            Map<String, List<MesesAmortizacionDTO>> reporteAnt = this.getResults(idEstudio, day + (year - 1));
            Map<String, List<MesesAmortizacionDTO>> reporteSig = this.getResults(idEstudio, day + (year + 1));
            XSSFWorkbook workbook = new XSSFWorkbook();
            Sheet sheet = workbook.createSheet("Conciliacion DDA vs SAP");
            this.addHeaders(sheet, (Workbook)workbook, year);
            int row = 1;
            for (Map.Entry<String, List<MesesAmortizacionDTO>> rep : reporte.entrySet()) {
                if (rep.getValue().size() < 2) {
                    MesesAmortizacionDTO emptyValue = new MesesAmortizacionDTO(Double.valueOf(0.0));
                    emptyValue.setSistema(rep.getValue().get(0).getSistema().equals("DDA") ? "SAP" : "DDA");
                    emptyValue.setDescripcion(rep.getValue().get(0).getDescripcion());
                    emptyValue.setTemporada(rep.getValue().get(0).getTemporada());
                    emptyValue.setIdContrato(rep.getValue().get(0).getIdContrato());
                    rep.getValue().add(emptyValue);
                }
                int i = 0;
                for (MesesAmortizacionDTO line : rep.getValue()) {
                    if (Objects.nonNull(reporteAnt.get(rep.getKey())) && reporteAnt.get(rep.getKey()).size() > i) {
                        if (Objects.nonNull(reporteAnt.get(rep.getKey()))) {
                            line.setAcumuladoAnt(reporteAnt.get(rep.getKey()).get(i).getAcumulado());
                        } else {
                            line.setAcumuladoAnt(Double.valueOf(0.0));
                        }
                        if (Objects.nonNull(reporteSig.get(rep.getKey()))) {
                            line.setAcumuladoSig(reporteSig.get(rep.getKey()).get(i).getAcumulado());
                        } else {
                            line.setAcumuladoSig(Double.valueOf(0.0));
                        }
                    } else {
                        line.setAcumuladoAnt(Double.valueOf(0.0));
                        line.setAcumuladoSig(Double.valueOf(0.0));
                    }
                    line.calculaRemanente(month);
                    int cell = 0;
                    CellStyle headerStyle = row == 1 || row == 2 ? this.getStyle((Workbook)workbook, IndexedColors.LIGHT_ORANGE.getIndex(), (short)1, Short.parseShort("10"), false) : (Objects.nonNull(line.getIdContrato()) ? this.getStyle((Workbook)workbook, IndexedColors.LIGHT_GREEN.getIndex(), (short)1, Short.parseShort("10"), false) : this.getStyle((Workbook)workbook, IndexedColors.LIGHT_YELLOW.getIndex(), (short)1, Short.parseShort("10"), false));
                    Row header = sheet.createRow(row++);
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getDescripcion());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getTemporada());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getSistema());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getAcumuladoAnt());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes1());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes2());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes3());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes4());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes5());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes6());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes7());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes8());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes9());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes10());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes11());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getMes12());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getAcumulado());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getAcumuladoSig());
                    this.fillCell(header, header.createCell(cell++), headerStyle, line.getRemanente());
                    ++i;
                }
                sheet.addMergedRegion(new CellRangeAddress(row - 2, row - 1, 0, 0));
            }
            baos = new ByteArrayOutputStream();
            workbook.write((OutputStream)baos);
        }
        catch (Exception e) {
            this.logger.error("Error: " + e);
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public void addHeaders(Sheet sheet, Workbook workbook, Integer year) {
        CellStyle headerStyle = this.getStyle(workbook, IndexedColors.RED.getIndex(), (short)1, Short.parseShort("12"), true);
        Row header = sheet.createRow(0);
        this.fillCell(header, header.createCell(0), headerStyle, "Descripci\u00f3n");
        this.fillCell(header, header.createCell(1), headerStyle, "Temporada");
        this.fillCell(header, header.createCell(2), headerStyle, "Sistema");
        this.fillCell(header, header.createCell(3), headerStyle, "Acumulado " + (year - 1));
        this.fillCell(header, header.createCell(4), headerStyle, "ENE");
        this.fillCell(header, header.createCell(5), headerStyle, "FEB");
        this.fillCell(header, header.createCell(6), headerStyle, "MAR");
        this.fillCell(header, header.createCell(7), headerStyle, "ABR");
        this.fillCell(header, header.createCell(8), headerStyle, "MAY");
        this.fillCell(header, header.createCell(9), headerStyle, "JUN");
        this.fillCell(header, header.createCell(10), headerStyle, "JUL");
        this.fillCell(header, header.createCell(11), headerStyle, "AGO");
        this.fillCell(header, header.createCell(12), headerStyle, "SEP");
        this.fillCell(header, header.createCell(13), headerStyle, "OCT");
        this.fillCell(header, header.createCell(14), headerStyle, "NOV");
        this.fillCell(header, header.createCell(15), headerStyle, "DIC");
        this.fillCell(header, header.createCell(16), headerStyle, "Acumulado");
        this.fillCell(header, header.createCell(17), headerStyle, "Acumulado " + (year + 1));
        this.fillCell(header, header.createCell(18), headerStyle, "Remanente");
    }

    public Map<String, List<MesesAmortizacionDTO>> getResults(Long idEstudio, String fecha) {
        LinkedHashMap<String, List<MesesAmortizacionDTO>> reporte = new LinkedHashMap<String, List<MesesAmortizacionDTO>>();
        LinkedList registros = new LinkedList();
        registros.addAll(this.reporteAmortizacionDAO.obtenerMesesAmortizacion(idEstudio, fecha));
        registros.addAll(this.reporteAmortizacionDAO.obtenerMesesAmortizacionSAP(idEstudio, fecha));
        for (MesesAmortizacionDTO registro : registros) {
            String numContrato;
            String temporada = Objects.nonNull(registro.getTemporada()) ? registro.getTemporada() : "";
            String string = numContrato = Objects.nonNull(registro.getNumContrato()) ? registro.getNumContrato() : "";
            if (!reporte.containsKey(registro.getDescripcion() + temporada + numContrato)) {
                reporte.put(registro.getDescripcion() + temporada + numContrato, new ArrayList());
            }
            ((List)reporte.get(registro.getDescripcion() + temporada + numContrato)).add(registro);
        }
        return reporte;
    }

    private void fillCell(Row header, Cell headerCell, CellStyle headerStyle, Double data) {
        headerCell.setCellValue(data.doubleValue());
        headerCell.setCellStyle(headerStyle);
    }

    private void fillCell(Row header, Cell headerCell, CellStyle headerStyle, String data) {
        headerCell.setCellValue(data);
        headerCell.setCellStyle(headerStyle);
    }

    private CellStyle getStyle(Workbook workbook, short color, short pattern, short size, boolean isBold) {
        CellStyle headerStyle = workbook.createCellStyle();
        headerStyle.setFillForegroundColor(color);
        headerStyle.setFillPattern(pattern);
        XSSFFont font = ((XSSFWorkbook)workbook).createFont();
        font.setFontName("Arial");
        font.setFontHeightInPoints(size);
        font.setBold(isBold);
        headerStyle.setFont((Font)font);
        return headerStyle;
    }

    private MesesAmortizacionDTO getVacio() {
        MesesAmortizacionDTO v = new MesesAmortizacionDTO();
        v.setDescripcion("");
        v.setMes1(Double.valueOf(0.0));
        v.setMes2(Double.valueOf(0.0));
        v.setMes3(Double.valueOf(0.0));
        v.setMes4(Double.valueOf(0.0));
        v.setMes5(Double.valueOf(0.0));
        v.setMes6(Double.valueOf(0.0));
        v.setMes7(Double.valueOf(0.0));
        v.setMes8(Double.valueOf(0.0));
        v.setMes9(Double.valueOf(0.0));
        v.setMes10(Double.valueOf(0.0));
        v.setMes11(Double.valueOf(0.0));
        v.setMes12(Double.valueOf(0.0));
        v.setAcumulado(Double.valueOf(0.0));
        return v;
    }

    public byte[] generarExcel(String fecha, List<MesesAmortizacionDTO> reporte) {
        byte[] fileExcel = null;
        String[] mesAnnio = fecha.split("/");
        int mes = Integer.parseInt(mesAnnio[0]);
        int annio = Integer.parseInt(mesAnnio[1]);
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("mesesAmortizacion");
        for (int i = 1; i <= 12; ++i) {
            String headerFormated = String.format(((ExcelRule)mapper.getRules().get(i)).getHeader(), this.smeses[mes - 1], annio);
            ((ExcelRule)mapper.getRules().get(i)).setHeader(headerFormated);
            if (++mes <= 12) continue;
            ++annio;
            mes = 1;
        }
        try {
            fileExcel = this.excelMapperTransform.transformObjectToExcel(reporte, mapper, MesesAmortizacionDTO.class);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return fileExcel;
    }

    public byte[] generaReporteAmortizacion_old() {
        ArrayList<Titulo> reporte = new ArrayList<Titulo>();
        Titulo titulo = new Titulo();
        byte[] fileExcel = null;
        titulo.setTipoTitulo("tipo");
        titulo.setNombreUnico("Nombre Unico");
        titulo.setEpisodio("Episodio");
        reporte.add(titulo);
        try {
            fileExcel = this.excelMapperTransform.transformObjectToExcel(reporte, "titulo", Titulo.class);
            this.logger.debug("" + fileExcel.length);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return fileExcel;
    }

    public byte[] generaReporteAmortizacionOK() {
        byte[] fileExcel = null;
        ArrayList<MesesAmortizacionDTO> reporte = new ArrayList<MesesAmortizacionDTO>();
        MesesAmortizacionDTO meses = new MesesAmortizacionDTO();
        meses.setAcumulado(Double.valueOf(100.0));
        meses.setDescripcion("Descripcion");
        meses.setIdContrato(Long.valueOf(1L));
        meses.setMes1(Double.valueOf(1.0));
        meses.setMes2(Double.valueOf(2.0));
        meses.setMes3(Double.valueOf(3.0));
        meses.setMes4(Double.valueOf(4.0));
        meses.setMes5(Double.valueOf(5.0));
        reporte.add(meses);
        try {
            fileExcel = this.excelMapperTransform.transformObjectToExcel(reporte, "mesesAmortizacion", MesesAmortizacionDTO.class);
            this.logger.debug("" + fileExcel.length);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return fileExcel;
    }

    public byte[] generaReporteAmortizacionOK2(Integer anio) {
        byte[] fileExcel = null;
        ArrayList<MesesAmortizacionDTO> reporte = new ArrayList<MesesAmortizacionDTO>();
        MesesAmortizacionDTO meses = new MesesAmortizacionDTO();
        meses.setAcumulado(Double.valueOf(100.0));
        meses.setDescripcion("Descripcion");
        meses.setIdContrato(Long.valueOf(1L));
        meses.setMes1(Double.valueOf(1.0));
        meses.setMes2(Double.valueOf(2.0));
        meses.setMes3(Double.valueOf(3.0));
        meses.setMes4(Double.valueOf(4.0));
        meses.setMes5(Double.valueOf(5.0));
        reporte.add(meses);
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("mesesAmortizacion");
        for (int i = 1; i <= 12; ++i) {
            String s = String.format(((ExcelRule)mapper.getRules().get(i)).getHeader(), anio + i - 1);
            ((ExcelRule)mapper.getRules().get(i)).setHeader(s);
        }
        try {
            fileExcel = this.excelMapperTransform.transformObjectToExcel(reporte, mapper, MesesAmortizacionDTO.class);
            this.logger.debug("" + fileExcel.length);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return fileExcel;
    }
}

