/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.pago.bos;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.ReporteAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.reporte.pago.daos.ReportePagoAlternoDAO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteAddOnRowDTO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteCRowDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReporteSuscriptoresBO
extends BaseBO {
    @Autowired
    private ReportePagoAlternoDAO reportePagoAlterno;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private CatalogoEstudiosDAO estudiosDao;

    public String[] obtenerLlaves() {
        String[] llaves = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19"};
        return llaves;
    }

    public String[] obtenerEncabezado() {
        String[] encabezado = this.obtenerLlaves();
        return encabezado;
    }

    public String[] obtenerEncabezadoCA() {
        String[] encabezado = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13", "M14", "M15", "M16", "M17", "M18", "M19", "Total"};
        return encabezado;
    }

    public Map<String, String> obtenerParametrosQuery() {
        HashMap<String, String> parametros = new HashMap<String, String>();
        Calendar calendar = Calendar.getInstance();
        String cad = "";
        int mes = calendar.get(2) + 1;
        int annio = calendar.get(1);
        cad = mes < 10 ? "0" : "";
        String fI = "'01-" + cad + mes + "-" + annio + "'";
        String fF = "'01-" + cad + mes + "-" + (annio + 1) + "'";
        String[] llaves = new String[]{"M1", "M2", "M3", "M4", "M5", "M6", "M7", "M8", "M9", "M10", "M11", "M12", "M13"};
        String[] valores = new String[llaves.length];
        parametros.put("fechaInicio", fI);
        parametros.put("fechaFin", fF);
        for (int i = 0; i < llaves.length; ++i) {
            cad = mes < 10 ? "0" : "";
            valores[i] = "'" + cad + mes + "-" + annio + "'";
            parametros.put(llaves[i], "'" + cad + mes + "-" + annio + "'");
            if (mes == 12) {
                mes = 1;
                ++annio;
                continue;
            }
            ++mes;
        }
        this.logger.debug("parametros : [{}]", parametros);
        return parametros;
    }

    public List<ReporteCRowDTO> obteneReporteS(Date fechaInicio) {
        List reporte = null;
        try {
            this.logger.debug("antes de reporte");
            reporte = this.reportePagoAlterno.obtenerReporteRowsS(fechaInicio);
            System.out.print("Action  ...obtenerReport");
            this.logger.debug("Regresando reporte");
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
            this.logger.debug("No regresa reporte reporte");
        }
        return reporte;
    }

    public void agrupaEnHistorico(String agrupado, Calendar fecha, Long idEstudio) {
        if (agrupado.equals("SI")) {
            this.estudiosDao.guardarHistorico(idEstudio, Integer.valueOf(fecha.get(1)), Integer.valueOf(fecha.get(2) + 1), Integer.valueOf(1));
            this.estudiosDao.guardarHistorico(idEstudio, Integer.valueOf(fecha.get(1)), Integer.valueOf(fecha.get(2) + 1), Integer.valueOf(2));
        } else {
            this.estudiosDao.guardarHistorico(idEstudio, Integer.valueOf(fecha.get(1)), Integer.valueOf(fecha.get(2) + 1), Integer.valueOf(0));
        }
    }

    public List<ReporteAddOnRowDTO> obteneReporteCA(Date fechaInicio, Long idEstudio) {
        List reporte = null;
        Calendar fecha = Calendar.getInstance();
        fecha.setTime(fechaInicio);
        try {
            EstudioAddonDTO estudio = this.estudiosDao.catalogoEstudiosAddOnById(idEstudio);
            this.logger.info("Estudio Recuperado: " + estudio.getNombre());
            ReporteAddonDTO report = this.estudiosDao.getTiposReporteById(estudio.getIdReporte());
            this.logger.info("Reporte Recuperado de BD : " + report.getDescFormula());
            switch (report.getFormula()) {
                case "A": {
                    this.agrupaEnHistorico(estudio.getAgrupado(), fecha, idEstudio);
                    reporte = this.reportePagoAlterno.obtenerReporteGeneral(fechaInicio, idEstudio, "'MEXICO'");
                    reporte.addAll(this.reportePagoAlterno.obtenerReporteGeneralMexico(fechaInicio, idEstudio));
                    this.agregarTotales(reporte);
                    break;
                }
                case "B": 
                case "C": {
                    this.agrupaEnHistorico(estudio.getAgrupado(), fecha, idEstudio);
                    reporte = this.reportePagoAlterno.obtenerReporteGeneral(fechaInicio, idEstudio, "'TODOS'");
                    this.agregarTotales(reporte);
                    break;
                }
                case "D": {
                    this.estudiosDao.guardarHistorico(idEstudio, Integer.valueOf(fecha.get(1)), Integer.valueOf(fecha.get(2) + 1), Integer.valueOf(3));
                    reporte = this.reportePagoAlterno.obtenerReporteFoxGeneral(fechaInicio, idEstudio);
                    this.agregarTotales(reporte);
                    break;
                }
                case "E": {
                    this.agrupaEnHistorico(estudio.getAgrupado(), fecha, idEstudio);
                    reporte = this.reportePagoAlterno.obtenerReporteKaraokeQello(fechaInicio, idEstudio, "'TODOS'");
                    this.agregarTotales(reporte);
                    break;
                }
                default: {
                    this.logger.error("Reporte no reconocido: " + report.getDescFormula());
                }
            }
            this.logger.info("Regresando reporte numero de filas" + reporte.size());
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
            this.logger.info("No regresa reporte reporte");
        }
        return reporte;
    }

    public void agregarTotales(List<ReporteAddOnRowDTO> reporte) {
        ReporteAddOnRowDTO totales = new ReporteAddOnRowDTO();
        Double f2 = 0.0;
        Double fd1 = 0.0;
        Double m19 = 0.0;
        this.logger.info("Antes de for");
        for (ReporteAddOnRowDTO r : reporte) {
            this.logger.info("Agregando f2 " + r.getF2());
            f2 = f2 + Double.parseDouble(r.getF2());
            this.logger.info("Agregando fd1 " + r.getFd1());
            fd1 = r.getFd1() == null ? Double.valueOf(fd1 + Double.parseDouble("0")) : Double.valueOf(fd1 + Double.parseDouble(r.getFd1()));
            this.logger.info("Agregando m19 " + r.getM19());
            m19 = m19 + Double.parseDouble(r.getM19());
        }
        this.logger.info("totales listos");
        totales.setF2(BigDecimal.valueOf(f2).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setFd1(BigDecimal.valueOf(fd1).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setM19(BigDecimal.valueOf(m19).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setM5("Totales: ");
        this.logger.info("totales listos: " + reporte.size());
        reporte.add(totales);
        this.logger.info("totales listos: " + reporte.size());
    }

    public InputStream obtenerReporteEnExcel(Date fechaInicio, Long idEstudio) {
        System.out.print("Action Excel ...obtenerReporteEnExcel");
        byte[] info = null;
        ByteArrayInputStream reporte = null;
        ExcelMapper mapper = this.excelMapperContext.getExcelMapper("reporteContingencia");
        this.logger.info("{}", (Object)mapper);
        String[] encabezado = this.obtenerEncabezado();
        List reporteInfo = null;
        System.out.print("Action Excel ...obtenerEncabezado");
        try {
            for (int i = 0; i < encabezado.length; ++i) {
                String s = String.format(((ExcelRule)mapper.getRules().get(i)).getHeader(), encabezado[i]);
                ((ExcelRule)mapper.getRules().get(i)).setHeader(s);
            }
            reporteInfo = this.reportePagoAlterno.obtenerReporteRowsS(fechaInicio);
            System.out.print("Action Excel ...obtenerReporteRowsC");
            this.logger.info("{}", (Object)mapper);
            info = this.excelMapperTransform.transformObjectToExcel(reporteInfo, mapper, ReporteCRowDTO.class);
            reporte = new ByteArrayInputStream(info);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return reporte;
    }

    public void cerrarHistorico(Date dateFormat, Long idEstudio) {
        Calendar fecha = Calendar.getInstance();
        fecha.setTime(dateFormat);
        this.estudiosDao.cerrarHistorico(idEstudio, Integer.valueOf(fecha.get(1)), Integer.valueOf(fecha.get(2) + 1));
    }
}

