/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reporte.pagosTransaccion.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.reporte.pagosTransaccion.daos.PagoTransacionDAO;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.DetalleHistorico;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccion;
import com.mx.dla.dda.reporte.pagosTransaccion.dtos.PagoTransaccionFiltros;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PagoTransaccionHistoricoBO
extends BaseBO {
    @Autowired
    private CatalogosDAO catalogosDAO;
    @Autowired
    private PagoTransacionDAO pagoTransacionDAO;
    private static final SimpleDateFormat format = new SimpleDateFormat("MM-yyyy");

    public List<PagoTransaccion> buscarPagos(PagoTransaccionFiltros filtros) {
        filtros = this.acondicionaFiltros(filtros);
        List pagos = this.pagoTransacionDAO.buscarPagosTransaccionHistorico(filtros);
        for (PagoTransaccion p : pagos) {
            Long total = 0L;
            int count = 0;
            p.setDetallesMesCosto(new HashMap());
            if (p.getDetallesMes() != null) {
                for (DetalleHistorico d : p.getDetallesMes()) {
                    total = total + d.getCosto();
                    if (count < filtros.getNumMesesHistorico()) {
                        p.getDetallesMesCosto().put(format.format(d.getMes()), d.getCosto());
                    }
                    ++count;
                }
            }
            p.setAcumulado(total.toString());
            p.setOverage(Long.valueOf(total - Long.parseLong(p.getMinimo())));
        }
        return pagos;
    }

    private PagoTransaccionFiltros acondicionaFiltros(PagoTransaccionFiltros filtros) {
        if (filtros.getMes() == null || "".equals(filtros.getMes())) {
            Calendar c = Calendar.getInstance();
            c.set(2, c.get(2) - 1);
            Date d = c.getTime();
            filtros.setMes(format.format(d));
        }
        if ("".equals(filtros.getTipoTitulo())) {
            filtros.setTipoTitulo(null);
        }
        return filtros;
    }

    public List<CatalogoDTO> buscarEstudios() {
        return this.catalogosDAO.buscarEstudios();
    }

    public List<String> calculaColumnaMeses(PagoTransaccionFiltros filtros) {
        Object[] meses = new String[filtros.getNumMesesHistorico()];
        int dec = 0;
        for (int i = filtros.getNumMesesHistorico(); i > 0; --i) {
            Calendar c = Calendar.getInstance();
            c.setTime(filtros.getFecha());
            c.set(2, c.get(2) - dec);
            meses[dec++] = format.format(c.getTime());
        }
        if (filtros.getAsc().booleanValue()) {
            CollectionUtils.reverseArray((Object[])meses);
        }
        return Arrays.asList(meses);
    }
}

