/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.reportes.generaxml;

import com.mx.dla.global.bos.BaseBO;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class generaXMLimpl
extends BaseBO {
    private static final long serialVersionUID = 4698989047503278255L;
    @Value(value="${excel.process.source.path}")
    private String uriXML;
    ArrayList<String> xml = new ArrayList();

    public String generaXML(List<Map<String, String>> response, String fileFileName, String tituloReporte) throws IOException {
        boolean createHead = false;
        this.xml.clear();
        String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
        String endFileXml = "</Tabla></Archivo>";
        String title = "<Fila id='' visible='true'><Celda><width>0</width><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>" + tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
        String startFila = "<Fila id='' visible='true'>";
        String endFila = "</Fila>";
        String startCelda = "<Celda><width>0</width><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
        String celdaClaseEncabezado = "<cellClass>celda_encabezado_general</cellClass>";
        String celdaClaseNormal = "<cellClass>celda_normal</cellClass>";
        String startTextoCelda = "<text>";
        String endTextoCelda = "</text>";
        String endCelda = "</Celda>";
        this.xml.add(headFileXml);
        this.xml.add(title);
        for (Map<String, String> item : response) {
            if (!createHead) {
                this.xml.add(startFila);
            }
            for (Map.Entry<String, String> pair : item.entrySet()) {
                if (createHead) continue;
                this.xml.add(startCelda);
                this.xml.add(celdaClaseEncabezado);
                this.xml.add(startTextoCelda);
                this.xml.add(pair.getKey());
                this.xml.add(endTextoCelda);
                this.xml.add(endCelda);
            }
            if (!createHead) {
                this.xml.add(endFila);
            }
            createHead = true;
        }
        for (Map<String, String> item : response) {
            this.xml.add(startFila);
            for (Map.Entry<String, String> pair : item.entrySet()) {
                this.xml.add(startCelda);
                this.xml.add(celdaClaseNormal);
                this.xml.add(startTextoCelda);
                this.xml.add(pair.getValue());
                this.xml.add(endTextoCelda);
                this.xml.add(endCelda);
            }
            this.xml.add(endFila);
        }
        this.xml.add(endFileXml);
        File file = new File(this.uriXML + "/" + fileFileName);
        FileUtils.writeLines((File)file, this.xml);
        this.logger.debug("busca XML en [{}]", (Object)file.getAbsolutePath());
        this.logger.debug("XML [{}]", this.xml);
        if (file.exists()) {
            this.logger.info("se genero xml {}", (Object)fileFileName);
        }
        return file.getAbsolutePath();
    }

    public String generaXMLvp(List<Map<String, String>> response, String fileFileName, String tituloReporte) throws IOException {
        boolean createHead = false;
        this.xml.clear();
        String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
        String endFileXml = "</Tabla></Archivo>";
        String title = "<Fila id='' visible='true'><Celda><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>" + tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
        String startFila = "<Fila id='' visible='true'>";
        String endFila = "</Fila>";
        String startCelda = "<Celda><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
        String celdaClaseEncabezado = "<cellClass>celda_encabezado_general</cellClass>";
        String celdaClaseTotales = "<cellClass>celda_totales</cellClass>";
        String celdaClaseNormal = "<cellClass>celda_normal</cellClass>";
        String startTextoCelda = "<text>";
        String endTextoCelda = "</text>";
        String endCelda = "</Celda>";
        String DatatypeNumeric = "<datatype>decimal2</datatype>";
        String celdaMoreWidth = "<width>200</width>";
        String celdaWidth = "<width>0</width>";
        this.xml.add(headFileXml);
        this.xml.add(title);
        for (Map<String, String> item : response) {
            if (!createHead) {
                this.xml.add(startFila);
            }
            for (Map.Entry<String, String> pair : item.entrySet()) {
                if (createHead) continue;
                this.xml.add(startCelda);
                this.xml.add(celdaWidth);
                this.xml.add(celdaClaseEncabezado);
                this.xml.add(startTextoCelda);
                if (pair.getKey().equals("COSTA_RICA")) {
                    this.xml.add("COSTA RICA");
                } else if (pair.getKey().equals("EL_SALVADOR")) {
                    this.xml.add("EL SALVADOR");
                } else if (pair.getKey().equals("R_DOMINICANA")) {
                    this.xml.add("R DOMINICANA");
                } else {
                    this.xml.add(pair.getKey());
                }
                this.xml.add(endTextoCelda);
                this.xml.add(endCelda);
            }
            if (!createHead) {
                this.xml.add(endFila);
            }
            createHead = true;
        }
        for (Map<String, String> item : response) {
            this.xml.add(startFila);
            for (Map.Entry<String, String> pair : item.entrySet()) {
                if (pair.getKey().equals("CONCEPTO")) {
                    this.xml.add(startCelda);
                    this.xml.add(celdaMoreWidth);
                    this.xml.add(celdaClaseNormal);
                    this.xml.add(startTextoCelda);
                    this.xml.add(pair.getValue());
                    this.xml.add(endTextoCelda);
                    this.xml.add(endCelda);
                    continue;
                }
                if (pair.getKey().equals("TOTAL")) {
                    this.xml.add(startCelda);
                    this.xml.add(celdaWidth);
                    this.xml.add(celdaClaseTotales);
                    this.xml.add(startTextoCelda);
                    this.xml.add(pair.getValue());
                    this.xml.add(endTextoCelda);
                    this.xml.add(DatatypeNumeric);
                    this.xml.add(endCelda);
                    continue;
                }
                this.xml.add(startCelda);
                this.xml.add(celdaWidth);
                this.xml.add(celdaClaseNormal);
                this.xml.add(startTextoCelda);
                this.xml.add(pair.getValue());
                this.xml.add(endTextoCelda);
                this.xml.add(DatatypeNumeric);
                this.xml.add(endCelda);
            }
            this.xml.add(endFila);
        }
        this.xml.add(endFileXml);
        File file = new File(this.uriXML + "/" + fileFileName);
        FileUtils.writeLines((File)file, this.xml);
        this.logger.debug("busca XML en [{}]", (Object)file.getAbsolutePath());
        this.logger.debug("XML [{}]", this.xml);
        if (file.exists()) {
            this.logger.info("se genero xml {}", (Object)fileFileName);
        }
        return file.getAbsolutePath();
    }

    public String generaXMLabuys(List<LinkedHashMap<String, String>> response, String fileFileName, String tituloReporte) throws IOException {
        boolean createHead = false;
        this.xml.clear();
        String headFileXml = "<?xml version='1.0' encoding ='UTF-8'?> <Archivo> <Tabla id='Hoja 1'>";
        String endFileXml = "</Tabla></Archivo>";
        String title = "<Fila id='' visible='true'><Celda><height>0</height><colspan>13</colspan><rowspan>1</rowspan><align>center</align><valign>middle</valign><cellClass>titulo_modulo</cellClass><value>" + tituloReporte + "</value><text>" + tituloReporte + "</text><datatype></datatype></Celda></Fila>";
        String startFila = "<Fila id='' visible='true'>";
        String endFila = "</Fila>";
        String startCelda = "<Celda><height>0</height><colspan>1</colspan><rowspan>1</rowspan><align>left</align><valign></valign>";
        String celdaClaseEncabezado = "<cellClass>celda_encabezado_general</cellClass>";
        String celdaClaseTotales = "<cellClass>celda_totales</cellClass>";
        String celdaClaseNormal = "<cellClass>celda_normal</cellClass>";
        String startTextoCelda = "<text>";
        String endTextoCelda = "</text>";
        String endCelda = "</Celda>";
        String DatatypeNumeric = "<datatype>THOUSANDS</datatype>";
        String celdaMoreWidth = "<width>200</width>";
        String celdaWidth = "<width>0</width>";
        this.xml.add(headFileXml);
        this.xml.add(title);
        for (Map map : response) {
            if (!createHead) {
                this.xml.add(startFila);
            }
            for (Map.Entry pair : map.entrySet()) {
                if (createHead) continue;
                this.xml.add(startCelda);
                this.xml.add(celdaWidth);
                this.xml.add(celdaClaseEncabezado);
                this.xml.add(startTextoCelda);
                if (((String)pair.getKey()).equals("AASSET_NAME")) {
                    this.xml.add("ASSET NAME");
                } else {
                    this.xml.add((String)pair.getKey());
                }
                this.xml.add(endTextoCelda);
                this.xml.add(endCelda);
            }
            if (!createHead) {
                this.xml.add(endFila);
            }
            createHead = true;
        }
        for (Map map : response) {
            this.xml.add(startFila);
            for (Map.Entry pair : map.entrySet()) {
                if (((String)pair.getKey()).equals("AASSET_NAME")) {
                    this.xml.add(startCelda);
                    this.xml.add(celdaMoreWidth);
                    this.xml.add(celdaClaseNormal);
                    this.xml.add(startTextoCelda);
                    this.xml.add((String)pair.getValue());
                    this.xml.add(endTextoCelda);
                    this.xml.add(endCelda);
                    continue;
                }
                if (((String)pair.getKey()).equals("TOTAL")) {
                    this.xml.add(startCelda);
                    this.xml.add(celdaWidth);
                    this.xml.add(celdaClaseNormal);
                    this.xml.add(startTextoCelda);
                    this.xml.add((String)pair.getValue());
                    this.xml.add(endTextoCelda);
                    this.xml.add(DatatypeNumeric);
                    this.xml.add(endCelda);
                    continue;
                }
                this.xml.add(startCelda);
                this.xml.add(celdaWidth);
                this.xml.add(celdaClaseNormal);
                this.xml.add(startTextoCelda);
                this.xml.add((String)pair.getValue());
                this.xml.add(endTextoCelda);
                this.xml.add(DatatypeNumeric);
                this.xml.add(endCelda);
            }
            this.xml.add(endFila);
        }
        this.xml.add(endFileXml);
        File file = new File(this.uriXML + "/" + fileFileName);
        FileUtils.writeLines((File)file, this.xml);
        this.logger.debug("busca XML en [{}]", (Object)file.getAbsolutePath());
        this.logger.debug("XML [{}]", this.xml);
        if (file.exists()) {
            this.logger.info("se genero xml {}", (Object)fileFileName);
        }
        return file.getAbsolutePath();
    }
}

