/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.restClient.bos;

import com.mx.dla.dda.restClient.bos.HeaderRequestInterceptor;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class DLARestClient {
    private RestTemplate template;
    private String uri;

    public DLARestClient(String uri) {
        try {
            HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
            client.setReadTimeout(600000);
            client.setConnectTimeout(600000);
            this.template = new RestTemplate((ClientHttpRequestFactory)client);
            this.template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
            this.template.getMessageConverters().add(new StringHttpMessageConverter());
            this.template.getInterceptors().add(new HeaderRequestInterceptor("Accept", "application/json"));
            this.template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", "application/json"));
            this.uri = uri;
        }
        catch (Exception e) {
            System.out.println("error: " + e.getMessage());
        }
    }

    public <T> T get(Class<T> responseType) {
        HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
        client.setReadTimeout(600000);
        client.setConnectTimeout(600000);
        this.template = new RestTemplate((ClientHttpRequestFactory)client);
        this.template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
        this.template.getMessageConverters().add(new StringHttpMessageConverter());
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Accept", "application/json"));
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        Object r = this.template.postForObject(this.uri, (Object)"", responseType, new Object[0]);
        client.destroy();
        return (T)r;
    }

    public <T> T get(Object request, Class<T> responseType) {
        HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
        client.setReadTimeout(600000);
        client.setConnectTimeout(600000);
        this.template = new RestTemplate((ClientHttpRequestFactory)client);
        this.template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
        this.template.getMessageConverters().add(new StringHttpMessageConverter());
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Accept", "application/json"));
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        Object r = this.template.postForObject(this.uri, request, responseType, new Object[0]);
        client.destroy();
        return (T)r;
    }

    public <T> T get(String request, Class<T> responseType) {
        HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
        client.setReadTimeout(600000);
        client.setConnectTimeout(600000);
        this.template = new RestTemplate((ClientHttpRequestFactory)client);
        this.template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
        this.template.getMessageConverters().add(new StringHttpMessageConverter());
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Accept", "application/json"));
        System.out.println("URL: " + this.uri.concat(request));
        Object r = this.template.getForObject(this.uri.concat(request), responseType, new Object[0]);
        client.destroy();
        return (T)r;
    }

    public void get(Object request) {
        HttpComponentsClientHttpRequestFactory client = new HttpComponentsClientHttpRequestFactory();
        client.setReadTimeout(300000);
        client.setConnectTimeout(300000);
        this.template = new RestTemplate((ClientHttpRequestFactory)client);
        this.template.getMessageConverters().add(new MappingJacksonHttpMessageConverter());
        this.template.getMessageConverters().add(new StringHttpMessageConverter());
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Accept", "application/json"));
        this.template.getInterceptors().add(new HeaderRequestInterceptor("Content-Type", "application/json"));
        this.template.postForObject(this.uri, request, Void.class, new Object[0]);
        client.destroy();
    }

    public String getUri() {
        return this.uri;
    }
}

