/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.restClient.bos;

import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;

public class DLARestClientFactory
extends BaseBO {
    private Map<String, String> services;
    private Map<String, DLARestClient> clients;

    @PostConstruct
    private void init() {
        this.clients = new HashMap<String, DLARestClient>();
        for (Map.Entry<String, String> entry : this.services.entrySet()) {
            String uri = entry.getValue();
            System.out.println("No existe el servicio: " + uri);
            DLARestClient rc = new DLARestClient(uri);
            this.clients.put(entry.getKey(), rc);
        }
    }

    public DLARestClient getClient(String service) {
        DLARestClient client = this.clients.get(service);
        if (client == null) {
            throw new IllegalArgumentException("No existe el servicio: " + service);
        }
        return client;
    }

    public DLARestClient getClient(DLARestServices service) {
        return this.getClient(service.name());
    }

    public void setServices(Map<String, String> services) {
        this.services = services;
    }
}

