/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.addons.bos;

import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.ReporteAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.reporte.pago.daos.ReportePagoAlternoDAO;
import com.mx.dla.dda.reporte.pago.dtos.ReporteAddOnRowDTO;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReporteAddOnsBO
extends BaseBO {
    @Autowired
    private ReportePagoAlternoDAO reportePagoAlterno;
    @Autowired
    private CatalogoEstudiosDAO estudiosDao;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    private ExcelMapperContext excelMapperContext;

    public InputStream obtenerReporteEnExcel(String estudioName, String mes) {
        byte[] info = null;
        ByteArrayInputStream reporte = null;
        List lReporte = null;
        Long idEstudio = Long.parseLong(estudioName);
        String tipoReporte = "";
        SimpleDateFormat formato = new SimpleDateFormat("dd/MM/yyyy");
        Date fechaInicio = null;
        try {
            fechaInicio = formato.parse("01/" + mes);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            this.logger.debug("antes de reporte");
            EstudioAddonDTO estudio = this.estudiosDao.catalogoEstudiosAddOnById(idEstudio);
            Object report = this.estudiosDao.getTiposReporteById(estudio.getIdReporte());
            this.logger.info("Reporte Recuperado de BD : " + report.getDescFormula());
            switch (report.getFormula()) {
                case "A": {
                    lReporte = this.reportePagoAlterno.obtenerReporteGeneral(fechaInicio, idEstudio, "'MEXICO'");
                    lReporte.addAll(this.reportePagoAlterno.obtenerReporteGeneralMexico(fechaInicio, idEstudio));
                    this.agregarTotales(lReporte);
                    break;
                }
                case "B": 
                case "C": {
                    lReporte = this.reportePagoAlterno.obtenerReporteGeneral(fechaInicio, idEstudio, "'TODOS'");
                    this.agregarTotales(lReporte);
                    break;
                }
                case "D": {
                    lReporte = this.reportePagoAlterno.obtenerReporteFoxGeneral(fechaInicio, idEstudio);
                    this.agregarTotales(lReporte);
                    break;
                }
                case "E": {
                    lReporte = this.reportePagoAlterno.obtenerReporteKaraokeQello(fechaInicio, idEstudio, "'TODOS'");
                    this.agregarTotales(lReporte);
                    break;
                }
                default: {
                    this.logger.error("Reporte no reconocido: " + report.getDescFormula());
                }
            }
            this.logger.debug("Regresando reporte");
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
            this.logger.debug("No regresa reporte ");
        }
        if (!Objects.isNull(lReporte) || !lReporte.isEmpty()) {
            tipoReporte = ((ReporteAddOnRowDTO)lReporte.get(0)).getM2();
        }
        System.out.println("Tipo reporte: " + tipoReporte);
        ExcelMapper mapper = null;
        switch (tipoReporte) {
            case "1": {
                mapper = this.excelMapperContext.getExcelMapper("addonsRepo1");
                break;
            }
            case "2": {
                mapper = this.excelMapperContext.getExcelMapper("addonsRepo2");
                break;
            }
            case "3": {
                mapper = this.excelMapperContext.getExcelMapper("addonsRepo3");
                break;
            }
            case "4": {
                mapper = this.excelMapperContext.getExcelMapper("addonsRepo4");
                break;
            }
            case "5": {
                mapper = this.excelMapperContext.getExcelMapper("addonsRepo5");
                break;
            }
        }
        try {
            info = this.excelMapperTransform.transformObjectToExcel(lReporte, mapper, ReporteAddOnRowDTO.class);
            reporte = new ByteArrayInputStream(info);
        }
        catch (Exception e) {
            this.logger.error("Error : " + e);
        }
        return reporte;
    }

    public void agregarTotales(List<ReporteAddOnRowDTO> reporte) {
        ReporteAddOnRowDTO totales = new ReporteAddOnRowDTO();
        Double f2 = 0.0;
        Double fd1 = 0.0;
        Double m19 = 0.0;
        for (ReporteAddOnRowDTO r : reporte) {
            f2 = f2 + Double.parseDouble(r.getF2());
            fd1 = fd1 + Double.parseDouble(r.getFd1());
            m19 = m19 + Double.parseDouble(r.getM19());
        }
        totales.setF2(BigDecimal.valueOf(f2).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setFd1(BigDecimal.valueOf(fd1).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setM19(BigDecimal.valueOf(m19).setScale(2, RoundingMode.HALF_UP).toString());
        totales.setM5("Totales: ");
        reporte.add(totales);
    }

    public String obtenerNombreEstudio(String idEstudio) {
        EstudioAddonDTO estudio = this.estudiosDao.catalogoEstudiosAddOnById(Long.valueOf(Long.parseLong(idEstudio)));
        return !Objects.isNull(estudio) ? estudio.getNombre() : "";
    }

    public List<ReporteAddonDTO> getTiposReporte(String id) {
        ArrayList<ReporteAddonDTO> reportes = new ArrayList<ReporteAddonDTO>();
        if (id.isEmpty()) {
            return this.estudiosDao.getTiposReporte();
        }
        reportes.add(this.estudiosDao.getTiposReporteById(id));
        return reportes;
    }
}

