/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.bos;

import com.mx.dla.dda.admin.catalogos.addons.daos.CatalogoAddOnsDAO;
import com.mx.dla.dda.admin.catalogos.addons.dtos.EstudioAddonDTO;
import com.mx.dla.dda.admin.catalogos.estudios.daos.CatalogoEstudiosDAO;
import com.mx.dla.dda.admin.catalogos.tipoCambio.dtos.TipoCambioDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.daos.TipoCambioAddOnsDAO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.MesTiposAddOnsCTDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.PaisAddOnsVDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.TipoCambioAddOnsDTO;
import com.mx.dla.dda.admin.catalogos.tipoCambioAddOns.dtos.TipoCambioPaisMesAddOnsDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.general.constants.MesesAnio;
import com.mx.dla.dda.reporte.cpview.dtos.ReporteCostPerViewVistaDTO;
import com.mx.dla.dda.reporte.cpview.exception.ReportCostPerViewException;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TipoCambioAddOnsBO
extends BaseBO {
    @Autowired
    private CatalogoEstudiosDAO catalogoEstudiosDAO;
    @Autowired
    private CatalogoAddOnsDAO catalogoAddOnsDAO;
    @Autowired
    private TipoCambioAddOnsDAO tipoCambioAddOnsDAO;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;

    public static String getExcelColumnName(int number) {
        StringBuilder sb = new StringBuilder();
        int num = number - 1;
        while (num >= 0) {
            int numChar = num % 26 + 65;
            sb.append((char)numChar);
            num = num / 26 - 1;
        }
        return sb.reverse().toString();
    }

    public InputStream obtenerStreamReporte(Long idEstudio, int anio) throws IllegalArgumentException, IllegalAccessException, ParseException, ExcelMapperException, IOException, ReportCostPerViewException {
        ReporteCostPerViewVistaDTO reporte = null;
        ExcelMapper mapper = new ExcelMapper();
        ArrayList<ExcelRule> rules = new ArrayList<ExcelRule>();
        ByteArrayInputStream stream = null;
        byte[] info = null;
        String[][] tabla = null;
        reporte = this.obtenerReporteMensualVista(idEstudio, anio);
        tabla = reporte.getTabla() != null ? reporte.getTabla() : new String[0][0];
        String[] rheader = reporte.getRheader();
        mapper.setClassName(ReporteCostPerViewVistaDTO.class.getName());
        mapper.setFirstRow(1);
        mapper.setId("PlantillaTipoCambioAddOns");
        mapper.setParent(null);
        mapper.setSkipErrors(true);
        mapper.setStartRowIndex(0L);
        for (int i = 0; i < tabla[0].length; ++i) {
            ExcelRule rule = new ExcelRule();
            ArrayList<String> headers = new ArrayList<String>();
            rule.setColumn(TipoCambioAddOnsBO.getExcelColumnName(i + 1));
            headers.add(rheader[i]);
            rule.setHeaders(headers);
            rules.add(rule);
        }
        mapper.setRules(rules);
        info = this.excelMapperTransform.transformObjectToExcel(tabla, mapper, String.class);
        stream = new ByteArrayInputStream(info);
        return stream;
    }

    public ReporteCostPerViewVistaDTO obtenerReporteMensualVista(Long idEstudio, int anio) throws ParseException, IllegalArgumentException, IllegalAccessException {
        ReporteCostPerViewVistaDTO reporte = new ReporteCostPerViewVistaDTO();
        reporte.setTabla(this.obtenReporteMensualTabla(idEstudio, anio));
        reporte.setRheader(this.obtenerHeaderRubro());
        return reporte;
    }

    public String[][] obtenReporteMensualTabla(Long idEstudio, int anio) throws IllegalArgumentException, IllegalAccessException {
        String[][] tabla = null;
        List datos2 = null;
        String pivot_date = "";
        String smes = "";
        if (idEstudio != null) {
            datos2 = this.tipoCambioAddOnsDAO.obtnerPaisMes(idEstudio, Integer.valueOf(anio));
        }
        if (datos2 != null && !datos2.isEmpty()) {
            for (TipoCambioPaisMesAddOnsDTO item : datos2) {
                String[] fila = item.getFieldsAsRow();
                tabla = tabla == null ? new String[1][fila.length] : (String[][])Arrays.copyOf(tabla, tabla.length + 1);
                tabla[tabla.length - 1] = fila;
            }
        }
        return tabla;
    }

    public String[] obtenerHeaderRubro() {
        ArrayList<String> rubros = new ArrayList<String>();
        rubros.add("Pa\u00eds");
        rubros.add("Enero");
        rubros.add("Febrero");
        rubros.add("Marzo");
        rubros.add("Abril");
        rubros.add("Mayo");
        rubros.add("Junio");
        rubros.add("Julio");
        rubros.add("Agosto");
        rubros.add("Septiembre");
        rubros.add("Octubre");
        rubros.add("Noviembre");
        rubros.add("Diciembre");
        String[] rubrosArr = new String[rubros.size()];
        rubrosArr = rubros.toArray(rubrosArr);
        return rubrosArr;
    }

    public List<Integer> obtenerAnnios() {
        ArrayList<Integer> annios = new ArrayList<Integer>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int annio = calendar.get(1) - 2;
        for (int i = 0; i < 4; ++i) {
            annios.add(annio++);
        }
        return annios;
    }

    public List<EstudioAddonDTO> obtenerEstudios() throws TransaccionException {
        List estudios = null;
        try {
            estudios = this.catalogoEstudiosDAO.catalogoEstudiosAddOn();
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener estudios.", ex);
        }
        return estudios;
    }

    public List<TipoCambioDTO> obtenerNombreMeses() throws TransaccionException {
        ArrayList<TipoCambioDTO> nombreMeses = new ArrayList<TipoCambioDTO>();
        nombreMeses.add(new TipoCambioDTO());
        TipoCambioDTO aux = null;
        MesesAnio ma = null;
        for (int i = 1; i <= 12; ++i) {
            aux = new TipoCambioDTO();
            ma = MesesAnio.parse((String)("" + i));
            aux.setIdTipoCambio(Long.valueOf(String.valueOf(i)));
            aux.setDescripcion(ma.getDesc());
            nombreMeses.add(aux);
        }
        return nombreMeses;
    }

    public List<MesTiposAddOnsCTDTO> obtenerMesTipo(Long idEstudio, Integer annio, List<TipoCambioDTO> nombreMeses) throws TransaccionException {
        ArrayList<MesTiposAddOnsCTDTO> mesesTipo = new ArrayList<MesTiposAddOnsCTDTO>();
        MesTiposAddOnsCTDTO aux = null;
        List paises = this.tipoCambioAddOnsDAO.obtenerPaisesAddOnXEstudio(idEstudio);
        EstudioAddonDTO estudio = this.catalogoEstudiosDAO.catalogoEstudiosAddOnById(idEstudio);
        for (PaisAddOnsVDTO pais : paises) {
            aux = new MesTiposAddOnsCTDTO();
            aux.setNombre(pais.getNombre());
            aux.setTipos(this.completaMesTipos(estudio.getIdEstudio(), pais.getIdPaisAddOn(), pais.getIdRelacion(), annio, nombreMeses));
            mesesTipo.add(aux);
        }
        return mesesTipo;
    }

    public List<TipoCambioAddOnsDTO> completaMesTipos(Integer idEstudio, Long idPais, Long idRelacion, Integer annio, List<TipoCambioDTO> nombreMeses) throws TransaccionException {
        HashMap<Long, TipoCambioAddOnsDTO> mesTiposM = new HashMap<Long, TipoCambioAddOnsDTO>();
        ArrayList<TipoCambioAddOnsDTO> mesPaises = null;
        TipoCambioAddOnsDTO tcpDto = null;
        Calendar calendar = Calendar.getInstance();
        String CADENA_VACIA = "";
        try {
            mesPaises = this.tipoCambioAddOnsDAO.obtnerMesTiposXPais(annio, idEstudio, idPais);
            if (mesPaises != null) {
                for (TipoCambioAddOnsDTO mt : mesPaises) {
                    mesTiposM.put(Long.valueOf(mt.getMes().getMonth() + 1), mt);
                }
            }
            mesPaises = new ArrayList<TipoCambioAddOnsDTO>();
            for (TipoCambioDTO mes : nombreMeses) {
                if (mesTiposM.get(mes.getIdTipoCambio()) != null) {
                    tcpDto = (TipoCambioAddOnsDTO)mesTiposM.get(mes.getIdTipoCambio());
                    if ((long)(tcpDto.getMes().getMonth() + 1) != mes.getIdTipoCambio() || tcpDto.getIdTipoCambio() == null) continue;
                    tcpDto.setRecuperado(true);
                    tcpDto.setValor(tcpDto.getValor() != null ? this.numberFormatter(tcpDto.getValor()) : CADENA_VACIA);
                    mesPaises.add((TipoCambioAddOnsDTO)mesTiposM.get(mes.getIdTipoCambio()));
                    continue;
                }
                if (mesTiposM.get(mes.getIdTipoCambio()) != null || mes.getIdTipoCambio() == null) continue;
                calendar.set(1, annio);
                calendar.set(2, Integer.valueOf(String.valueOf(mes.getIdTipoCambio())) - 1);
                calendar.set(5, 1);
                tcpDto = new TipoCambioAddOnsDTO();
                tcpDto.setIdRelacion(idRelacion);
                tcpDto.setIdEstudio(Long.valueOf(String.valueOf(idEstudio)));
                tcpDto.setIdPais(idPais);
                tcpDto.setIdTipoCambio(null);
                tcpDto.setMes(calendar.getTime());
                tcpDto.setRecuperado(false);
                mesPaises.add(tcpDto);
            }
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al obtener los meses por tipo.", ex);
        }
        return mesPaises;
    }

    private String numberFormatter(String numberS) {
        DecimalFormat formatter = new DecimalFormat("#0.00000");
        String numberD = "";
        try {
            numberD = formatter.format(Double.parseDouble(numberS));
        }
        catch (NumberFormatException nfe) {
            numberD = numberS;
        }
        return numberD;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public boolean guardarCambios(List<MesTiposAddOnsCTDTO> mesesTipos) throws TransaccionException {
        boolean respuesta = false;
        try {
            if (mesesTipos != null) {
                for (MesTiposAddOnsCTDTO mt : mesesTipos) {
                    this.logger.info("mes : [{}]", (Object)mt.getNombre());
                    for (TipoCambioAddOnsDTO tcp : mt.getTipos()) {
                        if (tcp.getRecuperado()) {
                            this.tipoCambioAddOnsDAO.actualizaTipoCambio(tcp);
                            continue;
                        }
                        if (tcp.getValor() == null) continue;
                        this.tipoCambioAddOnsDAO.creaTipoCambio(tcp);
                    }
                }
                respuesta = true;
            }
        }
        catch (Exception ex) {
            throw new TransaccionException("Error al actualizar los valores.", ex);
        }
        return respuesta;
    }

    public boolean cargaMasivaTipoCambioAddOn(Long anio, Long idEstudio, File fileUpload, String fileName, List<TipoCambioDTO> meses) throws TransaccionException {
        ArrayList<MesTiposAddOnsCTDTO> pasisesValores = new ArrayList();
        pasisesValores = this.cargarValoresTipoCambioAddOn(anio, idEstudio, fileUpload, fileName, meses);
        this.guardarCambios(pasisesValores);
        return true;
    }

    public List<MesTiposAddOnsCTDTO> cargarValoresTipoCambioAddOn(Long anio, Long idEstudio, File fileUpload, String fileName, List<TipoCambioDTO> meses) {
        TipoCambioAddOnsDTO valor;
        Long idRelacion;
        PaisAddOnsVDTO pais;
        ArrayList<TipoCambioAddOnsDTO> valoresPais;
        FileInputStream file;
        HSSFWorkbook workbook;
        ArrayList<MesTiposAddOnsCTDTO> valores = new ArrayList<MesTiposAddOnsCTDTO>();
        File d = null;
        String sigla = "";
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        boolean existeValor = false;
        try {
            byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
            d = new File(fileName);
            d.setExecutable(true, false);
            d.setReadable(true, false);
            d.setWritable(true, false);
            this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
            FileUtils.writeByteArrayToFile((File)d, (byte[])f);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        if (d.getName().endsWith(".xls")) {
            workbook = null;
            try {
                file = new FileInputStream(d);
                workbook = new HSSFWorkbook((InputStream)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HSSFSheet sheet = workbook.getSheetAt(0);
            int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
            HSSFRow filaCero = sheet.getRow(0);
            if (filaCero.getCell(0).toString().toUpperCase().contains("Pa\u00eds")) {
                for (int xFila = 1; xFila < lnuUltimaFila; ++xFila) {
                    HSSFRow row = sheet.getRow(xFila);
                    MesTiposAddOnsCTDTO tipoCambio = new MesTiposAddOnsCTDTO();
                    valoresPais = new ArrayList();
                    sigla = row.getCell(0).toString();
                    pais = this.tipoCambioAddOnsDAO.obtenerPaisXSigla(sigla);
                    idRelacion = this.catalogoAddOnsDAO.obtenerIdRelacion(idEstudio, pais.getIdPaisAddOn());
                    tipoCambio.setNombre(pais.getNombre());
                    if (row != null) {
                        for (int i = 1; i <= 12; ++i) {
                            if (row.getCell(i).toString() == null || row.getCell(i).toString().trim().equals("")) continue;
                            calendar.set(1, Integer.valueOf(String.valueOf(anio)));
                            calendar.set(2, Integer.valueOf(String.valueOf(i)) - 1);
                            calendar.set(5, 1);
                            existeValor = this.tipoCambioAddOnsDAO.verificarExistenciaTipoCambioAddOn(idRelacion, sdf.format(calendar.getTime())) != 0;
                            valor = new TipoCambioAddOnsDTO();
                            valor.setIdEstudio(idEstudio);
                            valor.setIdPais(pais.getIdPaisAddOn());
                            valor.setIdRelacion(idRelacion);
                            valor.setMes(calendar.getTime());
                            valor.setValor(row.getCell(i).toString());
                            valor.setRecuperado(existeValor);
                            valoresPais.add(valor);
                        }
                        tipoCambio.setTipos(valoresPais);
                    }
                    valores.add(tipoCambio);
                }
            }
        }
        if (d.getName().endsWith(".xlsx")) {
            workbook = null;
            String CADENA_VACIA = "";
            try {
                file = new FileInputStream(d);
                workbook = new XSSFWorkbook((InputStream)file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            XSSFSheet sheet = workbook.getSheetAt(0);
            int lnuUltimaFila = sheet.getPhysicalNumberOfRows();
            XSSFRow filaCero = sheet.getRow(0);
            for (int xFila = 1; xFila < lnuUltimaFila; ++xFila) {
                XSSFRow row = sheet.getRow(xFila);
                MesTiposAddOnsCTDTO tipoCambio = new MesTiposAddOnsCTDTO();
                valoresPais = new ArrayList<TipoCambioAddOnsDTO>();
                sigla = row.getCell(0).toString();
                pais = this.tipoCambioAddOnsDAO.obtenerPaisXSigla(sigla);
                idRelacion = this.catalogoAddOnsDAO.obtenerIdRelacion(idEstudio, pais.getIdPaisAddOn());
                if (row != null) {
                    for (int i = 1; i <= 12; ++i) {
                        Double datoNum = null;
                        try {
                            datoNum = Double.parseDouble(row.getCell(i).toString());
                        }
                        catch (Exception e) {
                            datoNum = null;
                        }
                        if (datoNum == null) continue;
                        calendar.set(1, Integer.valueOf(String.valueOf(anio)));
                        calendar.set(2, Integer.valueOf(String.valueOf(i)) - 1);
                        calendar.set(5, 1);
                        existeValor = this.tipoCambioAddOnsDAO.verificarExistenciaTipoCambioAddOn(idRelacion, sdf.format(calendar.getTime())) != 0;
                        valor = new TipoCambioAddOnsDTO();
                        valor.setIdEstudio(idEstudio);
                        valor.setIdPais(pais.getIdPaisAddOn());
                        valor.setIdRelacion(idRelacion);
                        valor.setMes(calendar.getTime());
                        valor.setValor(datoNum > 0.0 ? datoNum.toString() : CADENA_VACIA);
                        valor.setRecuperado(existeValor);
                        valoresPais.add(valor);
                    }
                    tipoCambio.setTipos(valoresPais);
                }
                valores.add(tipoCambio);
            }
        }
        return valores;
    }
}

