/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.admin.presupuestos.bos;

import com.mx.dla.dda.admin.presupuestos.bos.PresupuestoUtil;
import com.mx.dla.dda.admin.presupuestos.daos.PresupuestoDAO;
import com.mx.dla.dda.admin.presupuestos.dtos.AmortApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.ApartadoPreBD;
import com.mx.dla.dda.admin.presupuestos.dtos.MontoTransferirDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoApartadoDTO;
import com.mx.dla.dda.admin.presupuestos.dtos.PresupuestoDTO;
import com.mx.dla.dda.contrato.ws.dtos.DTPresupuestoOIReq;
import com.mx.dla.dda.ordenesinternas.dtos.PresupuestoOrdenDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PresupuestoBO
extends BaseBO {
    private Boolean amortizable = false;
    @Autowired
    private PresupuestoDAO presupuestoDAO;
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;

    public String almacenaMonto(int anio, double monto) {
        try {
            this.presupuestoDAO.almacenaMonto(Integer.valueOf(anio), Double.valueOf(monto));
            return "APLICADO";
        }
        catch (Exception e) {
            return "Fallo en inserci\u00f3n";
        }
    }

    public List<List<PresupuestoDTO>> getPresupuestos() {
        List presupuestosBD;
        ArrayList<List<PresupuestoDTO>> presupuesto = new ArrayList<List<PresupuestoDTO>>();
        List apartados = this.presupuestoDAO.getApartados();
        ArrayList<PresupuestoApartadoDTO> apartadosA = new ArrayList<PresupuestoApartadoDTO>();
        ArrayList<PresupuestoApartadoDTO> apartadosNA = new ArrayList<PresupuestoApartadoDTO>();
        ArrayList<Long> idsA = new ArrayList<Long>();
        ArrayList<Long> idsNA = new ArrayList<Long>();
        for (PresupuestoApartadoDTO apartado : apartados) {
            if (apartado.getType().compareTo("Amortizable") == 0) {
                apartadosA.add(apartado);
                idsA.add(apartado.getId());
                continue;
            }
            apartadosNA.add(apartado);
            idsNA.add(apartado.getId());
        }
        if (!apartadosA.isEmpty()) {
            this.amortizable = true;
            presupuestosBD = this.presupuestoDAO.getPresupuestos(idsA);
            presupuesto.add(this.calcularPresupuestos(apartadosA, presupuestosBD));
        }
        if (!apartadosNA.isEmpty()) {
            presupuestosBD = this.presupuestoDAO.getPresupuestos(idsNA);
            presupuesto.add(this.calcularPresupuestos(apartadosNA, presupuestosBD));
        }
        return presupuesto;
    }

    public List<List<PresupuestoDTO>> getPresupuestosSinComprometido() {
        List presupuestosBD;
        ArrayList<List<PresupuestoDTO>> presupuesto = new ArrayList<List<PresupuestoDTO>>();
        List apartados = this.presupuestoDAO.getApartados();
        ArrayList<PresupuestoApartadoDTO> apartadosA = new ArrayList<PresupuestoApartadoDTO>();
        ArrayList<PresupuestoApartadoDTO> apartadosNA = new ArrayList<PresupuestoApartadoDTO>();
        ArrayList<Long> idsA = new ArrayList<Long>();
        ArrayList<Long> idsNA = new ArrayList<Long>();
        for (PresupuestoApartadoDTO apartado : apartados) {
            if (apartado.getType().compareTo("Amortizable") == 0) {
                apartadosA.add(apartado);
                idsA.add(apartado.getId());
                continue;
            }
            apartadosNA.add(apartado);
            idsNA.add(apartado.getId());
        }
        if (!apartadosA.isEmpty()) {
            this.amortizable = true;
            presupuestosBD = this.presupuestoDAO.getPresupuestos(idsA);
            presupuesto.add(this.calcularPresupuestosSinComprometido(apartadosA, presupuestosBD));
        }
        if (!apartadosNA.isEmpty()) {
            presupuestosBD = this.presupuestoDAO.getPresupuestos(idsNA);
            presupuesto.add(this.calcularPresupuestosSinComprometido(apartadosNA, presupuestosBD));
        }
        return presupuesto;
    }

    private List<PresupuestoDTO> calcularPresupuestos(List<PresupuestoApartadoDTO> apartados, List<PresupuestoDTO> presBD) {
        ArrayList<Object> idApartados = new ArrayList();
        HashMap<Long, Long> idTemp = new HashMap<Long, Long>();
        Map<Integer, List<PresupuestoApartadoDTO>> mapPre = PresupuestoUtil.getApartadosXAnio(apartados, presBD, idTemp);
        idApartados = new ArrayList(idTemp.values());
        List<Object> amortizacion = new ArrayList<AmortApartadoDTO>();
        if (idApartados.size() > 0) {
            amortizacion = this.presupuestoDAO.getApartadosAmortizacion(idApartados);
        }
        Map<String, Double> apartadosAmor = PresupuestoUtil.getAmortXApartados(idApartados, amortizacion);
        List amortizables = this.presupuestoDAO.getAmortizables();
        List<PresupuestoDTO> presupuestos = PresupuestoUtil.getSumarizadoPresupuestos(apartadosAmor, mapPre, amortizables);
        return presupuestos;
    }

    private List<PresupuestoDTO> calcularPresupuestosSinComprometido(List<PresupuestoApartadoDTO> apartados, List<PresupuestoDTO> presBD) {
        HashMap<Long, Long> idTemp = new HashMap<Long, Long>();
        Map<Integer, List<PresupuestoApartadoDTO>> mapPre = PresupuestoUtil.getApartadosXAnio(apartados, presBD, idTemp);
        HashMap<String, Double> temp = new HashMap<String, Double>();
        ArrayList<AmortApartadoDTO> temp1 = new ArrayList<AmortApartadoDTO>();
        List<PresupuestoDTO> presupuestos = PresupuestoUtil.getSumarizadoPresupuestos(temp, mapPre, temp1);
        return presupuestos;
    }

    public Boolean getAmortizable() {
        return this.amortizable;
    }

    public String guardarApartados(List<PresupuestoApartadoDTO> apartados, Integer anio) throws Exception {
        String mensaje = "";
        Boolean valido = true;
        for (PresupuestoApartadoDTO apartado : apartados) {
            if (apartado.getIdPreApart() != -1L || apartado.getMontoAsignado() == null || !(apartado.getMontoAsignado() > 0.0)) continue;
            if (apartado.getType().compareTo("Amortizable") == 0) {
                apartado.setFechaSAP(this.getFechaHoy());
                String codigoSAP = this.notificarSAP(apartado, anio, "KBUD");
                if (codigoSAP == null) {
                    valido = false;
                    mensaje = mensaje + apartado.getNombre() + ", ";
                }
            }
            if (!valido.booleanValue()) continue;
            this.presupuestoDAO.eliminarPrepApartadoPrevio(apartado.getId(), anio);
            this.presupuestoDAO.guardarApartado(apartado, anio);
        }
        if (mensaje.compareTo("") == 0) {
            mensaje = null;
        }
        return mensaje;
    }

    public void actualizarApartadosTmp(List<PresupuestoApartadoDTO> apartados, Integer anio) throws Exception {
        for (PresupuestoApartadoDTO apartado : apartados) {
            if (apartado.getType().compareTo("Amortizable") == 0) {
                apartado.setFechaSAP(this.getFechaHoy());
            }
            if (apartado.getIdPreApart() == -1L && apartado.getMontoAsignado() != null && apartado.getMontoAsignado() > 0.0) {
                this.presupuestoDAO.eliminarPrepApartadoPrevio(apartado.getId(), anio);
                this.presupuestoDAO.guardarApartado(apartado, anio);
                continue;
            }
            if (apartado.getIdPreApart() == -1L || apartado.getMontoAsignado() == null) continue;
            this.presupuestoDAO.actualizarApartado(apartado);
        }
    }

    public List<PresupuestoDTO> obtenerPresptoXTipo(String tipo) {
        PresupuestoDTO pto;
        ArrayList<PresupuestoDTO> presupuestos = new ArrayList<PresupuestoDTO>();
        List apartados = this.presupuestoDAO.getApartadosXTipo(tipo);
        List asignado = this.presupuestoDAO.obtenerPresupuestoAsignado(apartados);
        List comprometido = this.presupuestoDAO.obtenerPresupuestoComprometido(tipo);
        TreeMap<Integer, PresupuestoDTO> presups = new TreeMap<Integer, PresupuestoDTO>();
        for (ApartadoPreBD a : PresupuestoBO.safeList(asignado)) {
            pto = new PresupuestoDTO();
            pto.setAnio(a.getAnio());
            pto.setMontoAsignado(Double.valueOf(Double.parseDouble(a.getMontoAsignado())));
            presups.put(a.getAnio(), pto);
        }
        for (ApartadoPreBD a : PresupuestoBO.safeList(comprometido)) {
            if (presups.containsKey(a.getAnio())) {
                PresupuestoDTO temp = (PresupuestoDTO)presups.get(a.getAnio());
                temp.setMontoComprometido(Double.valueOf(Double.parseDouble(a.getMontoAsignado())));
                presups.put(a.getAnio(), temp);
                continue;
            }
            pto = new PresupuestoDTO();
            pto.setAnio(a.getAnio());
            pto.setMontoComprometido(Double.valueOf(Double.parseDouble(a.getMontoAsignado())));
            presups.put(a.getAnio(), pto);
        }
        Set set = presups.entrySet();
        for (Map.Entry me : set) {
            presupuestos.add((PresupuestoDTO)me.getValue());
        }
        return presupuestos;
    }

    public PresupuestoDTO obtenerApartadosPresptoXAnio(String tipo, int anio) {
        PresupuestoDTO presupuesto = new PresupuestoDTO();
        List apartados = this.presupuestoDAO.getApartadosXTipo(tipo);
        List asignado = this.presupuestoDAO.obtenerApartadosAsignado(apartados, Integer.valueOf(anio));
        List comprometido = this.presupuestoDAO.obtenerApartadosComprometido(tipo, Integer.valueOf(anio));
        for (ApartadoPreBD a : PresupuestoBO.safeList(asignado)) {
            for (PresupuestoApartadoDTO ap : PresupuestoBO.safeList(apartados)) {
                if (ap.getId().intValue() != a.getIdApartado().intValue()) continue;
                ap.setFechaSAP(a.getFechaSap());
                ap.setIdPreApart(a.getIdPreApart());
                ap.setMontoAsignado(Double.valueOf(Double.parseDouble(a.getMontoAsignado())));
            }
        }
        for (ApartadoPreBD a : PresupuestoBO.safeList(comprometido)) {
            for (PresupuestoApartadoDTO ap : PresupuestoBO.safeList(apartados)) {
                if (ap.getId().intValue() != a.getIdApartado().intValue()) continue;
                ap.setMontoComprometido(Double.valueOf(Double.parseDouble(a.getMontoAsignado())));
            }
        }
        presupuesto.setApartados(apartados);
        Collections.sort(presupuesto.getApartados(), new Comparator<PresupuestoApartadoDTO>(){

            @Override
            public int compare(PresupuestoApartadoDTO o1, PresupuestoApartadoDTO o2) {
                return o1.getNombre().compareTo(o2.getNombre());
            }
        });
        if (tipo.equals("Amortizable")) {
            String valor = this.presupuestoDAO.getAmortizable(Integer.valueOf(anio));
            valor = valor == null ? "0" : valor;
            presupuesto.setMontoAmortizable(Double.valueOf(Double.parseDouble(valor)));
        }
        return presupuesto;
    }

    public String redistribuirApartados(List<PresupuestoApartadoDTO> apartados, Integer anio) throws Exception {
        String msg = null;
        if (apartados.get(0).getType().compareTo("No Amortizable") == 0) {
            this.logger.debug(apartados.toString());
            ArrayList<PresupuestoApartadoDTO> amortizables = new ArrayList<PresupuestoApartadoDTO>();
            apartados.get(0).setMontoAsignado(Double.valueOf(apartados.get(1).getMontoAsignado() - Math.abs(apartados.get(0).getMontoAsignado())));
            apartados.get(2).setMontoAsignado(Double.valueOf(apartados.get(3).getMontoAsignado() + Math.abs(apartados.get(2).getMontoAsignado())));
            amortizables.add(apartados.get(0));
            amortizables.add(apartados.get(2));
            this.actualizarApartadosTmp(amortizables, anio);
            this.guardarRedistribucionBD(apartados.get(1).getId(), apartados.get(3).getId(), String.valueOf(apartados.get(1).getMontoAsignado()), String.valueOf(apartados.get(3).getMontoAsignado()), String.valueOf(apartados.get(1).getMontoAsignado() - apartados.get(0).getMontoAsignado()));
        } else {
            apartados.get(0).setMontoAsignado(apartados.get(0).getMontoAsignado());
            String idSAP = this.notificarSAP(apartados.get(0), anio, "KBR0");
            if (idSAP == null) {
                msg = "No se realizo la redistribucion, ocurrio un error inesperado.";
            } else {
                idSAP = this.notificarSAP(apartados.get(2), anio, "KBN0");
                if (idSAP == null) {
                    apartados.get(0).setMontoAsignado(Double.valueOf(apartados.get(0).getMontoAsignado() * -1.0));
                    idSAP = this.notificarSAP(apartados.get(0), anio, "KBN0");
                    msg = "No se realizo la redistribucion, ocurrio un error inesperado.";
                } else {
                    ArrayList<PresupuestoApartadoDTO> amortizables = new ArrayList<PresupuestoApartadoDTO>();
                    apartados.get(0).setMontoAsignado(Double.valueOf(apartados.get(1).getMontoAsignado() - Math.abs(apartados.get(0).getMontoAsignado())));
                    apartados.get(2).setMontoAsignado(Double.valueOf(apartados.get(3).getMontoAsignado() + Math.abs(apartados.get(2).getMontoAsignado())));
                    amortizables.add(apartados.get(0));
                    amortizables.add(apartados.get(2));
                    this.actualizarApartadosTmp(amortizables, anio);
                    this.guardarRedistribucionBD(apartados.get(1).getId(), apartados.get(3).getId(), String.valueOf(apartados.get(1).getMontoAsignado()), String.valueOf(apartados.get(3).getMontoAsignado()), String.valueOf(apartados.get(1).getMontoAsignado() - apartados.get(0).getMontoAsignado()));
                }
            }
        }
        return msg;
    }

    public String redistribuirApartadosMontoDispo(List<PresupuestoApartadoDTO> apartados, Integer anio) throws Exception {
        String msg = null;
        if (apartados.get(0).getType().compareTo("Amortizable") == 0) {
            apartados.get(0).setMontoAsignado(apartados.get(0).getMontoAsignado());
            String idSAP = this.notificarSAP(apartados.get(0), anio, "KBN0");
            if (idSAP == null) {
                msg = "No se realizo la redistribucion, ocurrio un error inesperado.";
            } else {
                ArrayList<PresupuestoApartadoDTO> amortizables = new ArrayList<PresupuestoApartadoDTO>();
                apartados.get(0).setMontoAsignado(Double.valueOf(apartados.get(1).getMontoAsignado() + Math.abs(apartados.get(0).getMontoAsignado())));
                amortizables.add(apartados.get(0));
                this.actualizarApartadosTmp(amortizables, anio);
                this.guardarRedistribucionBD(null, apartados.get(1).getId(), null, String.valueOf(apartados.get(1).getMontoAsignado()), String.valueOf(apartados.get(1).getMontoAsignado() - apartados.get(0).getMontoAsignado()));
            }
        }
        return msg;
    }

    public String notificarSAP(PresupuestoApartadoDTO apartado, int anio, String tipoOperacion) {
        String respuesta = null;
        try {
            DTPresupuestoOIReq dTPresupuestoOIReq = new DTPresupuestoOIReq();
            DTPresupuestoOIReq.Registro registro = new DTPresupuestoOIReq.Registro();
            PresupuestoOrdenDTO presupuestoDTO = new PresupuestoOrdenDTO();
            registro.setTipoOperacion(tipoOperacion);
            registro.setOrden(apartado.getIdSap());
            registro.setEjercicio(String.valueOf(anio));
            registro.setImporte(String.format("%.2f", apartado.getMontoAsignado()));
            registro.setMoneda("USD");
            dTPresupuestoOIReq.setRegistro(registro);
            this.logger.info("Se llama interfaz ORDENES_INTERNAS_PRESUPUESTO #7");
            this.logger.info("Presupuesto. {}", (Object)apartado);
            this.logger.info("tipoOperaion: {}, orden: {},  moneda:USD", (Object)tipoOperacion, (Object)apartado.getIdSap());
            this.logger.info("ejercicio: {}, importe:{}", (Object)anio, (Object)apartado.getMontoAsignado());
            DLARestClient c = this.dlaRestClientFactory.getClient(DLARestServices.ORDENES_INTERNAS_PRESUPUESTO);
            this.logger.info("URL {}", (Object)c.getUri());
            presupuestoDTO = c.get(dTPresupuestoOIReq, PresupuestoOrdenDTO.class);
            this.logger.info("Respuesta servicio {}", (Object)presupuestoDTO.getEstatus());
            respuesta = presupuestoDTO.getEstatus().compareTo("OK") != 0 ? null : "OK";
        }
        catch (Exception e) {
            this.logger.error("Se produjo un error al llamar al servicio rest." + DLARestServices.ORDENES_INTERNAS_PRESUPUESTO.toString());
            this.logger.error("Error: {}", (Throwable)e);
            respuesta = null;
        }
        return respuesta;
    }

    public void guardarRedistribucionBD(Long apOrigen, Long apDestino, String montoOrign, String montoDestino, String montoReasignado) throws Exception {
        MontoTransferirDTO monto = new MontoTransferirDTO(apOrigen, apDestino, montoOrign, montoDestino, montoReasignado, new Date());
        this.presupuestoDAO.guardarTransferencia(monto);
    }

    private Date getFechaHoy() {
        Date date = new Date();
        return date;
    }

    public static <T> List<T> safeList(List<T> other) {
        return other == null ? Collections.EMPTY_LIST : other;
    }
}

