/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.common.bos;

import com.dla.dda.domain.model.request.PresupuestoRequest;
import com.dla.dda.domain.model.response.PresupuestoResponse;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulos.dtos.ParamValorTituloDTO;
import com.mx.dla.dda.contrato.titulos.dtos.ResponseValorTituloDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ParamValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validapresupuesto.ResponseValidaPresupuestoCntDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ParamValidaMinimoSeleccionDTO;
import com.mx.dla.dda.contrato.ws.validarMinimoSeleccion.ResponseValidaMinimoSeleccionDTO;
import com.mx.dla.dda.restClient.bos.DLARestClient;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.dda.restClient.constants.DLARestServices;
import com.mx.dla.global.bos.BaseBO;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CommonRestBO
extends BaseBO {
    @Autowired
    private DLARestClientFactory dlaRestClientFactory;

    public ResponseValorTituloDTO llamadaCostoTitulo(Date fechaInicio, Long idContrato, String origen) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.COSTO_TITULO);
        ParamValorTituloDTO request = new ParamValorTituloDTO();
        Calendar cal = Calendar.getInstance();
        cal.setTime(fechaInicio);
        cal.set(2, cal.get(2) - 1);
        cal.set(5, 1);
        SimpleDateFormat fecha = new SimpleDateFormat("dd/MM/yyyy");
        request.setIdContrato(idContrato.toString());
        request.setMesCalculo(fecha.format(cal.getTime()));
        request.setOrigenTitulos(origen);
        this.logger.info("Request rest costo [{}]", (Object)request);
        ResponseValorTituloDTO response = client.get(request, ResponseValorTituloDTO.class);
        this.logger.info("Response rest costo [{}]", (Object)response);
        return response;
    }

    public PresupuestoResponse validaPresupuesto_deprecated(Date fechaInicio, Long idContrato, String origen) {
        DLARestClient clientPresupuesto = this.dlaRestClientFactory.getClient(DLARestServices.VALIDA_PRESUPUESTO);
        PresupuestoRequest req = new PresupuestoRequest();
        Calendar cal = Calendar.getInstance();
        cal.setTime(fechaInicio);
        Calendar calh = Calendar.getInstance();
        int hoy = calh.get(1);
        int fecIContrato = cal.get(1);
        req.setAnio(hoy >= fecIContrato ? hoy : fecIContrato);
        req.setContrato(idContrato.longValue());
        req.setOrigenTitulos(origen);
        this.logger.debug("Request Presupuesto [{}]", (Object)req);
        PresupuestoResponse resp = clientPresupuesto.get(req, PresupuestoResponse.class);
        this.logger.debug("Response Presupuesto [{}]", (Object)resp);
        return resp;
    }

    public ResponseValidaPresupuestoCntDTO validaPresupuesto(Date fechaInicio, Long idContrato, String origen) {
        DLARestClient client = this.dlaRestClientFactory.getClient(DLARestServices.VALIDAR_PRESUPUESTO_POR_CONTRATO);
        ParamValidaPresupuestoCntDTO req = new ParamValidaPresupuestoCntDTO();
        ResponseValidaPresupuestoCntDTO resp = null;
        req.setIdContrato(idContrato.toString());
        this.logger.debug("request : [{}]", (Object)req);
        resp = client.get(req, ResponseValidaPresupuestoCntDTO.class);
        this.logger.debug("response : [{}]", (Object)resp);
        return resp;
    }

    public ResponseValidaMinimoSeleccionDTO validaMinimos(ContratoDTO ct, String origen) {
        DLARestClient clientMinimos = this.dlaRestClientFactory.getClient(DLARestServices.VALIDA_MINIMO_SELECCION);
        ParamValidaMinimoSeleccionDTO rmin = new ParamValidaMinimoSeleccionDTO();
        rmin.setIdContrato(ct.getIdContrato().toString());
        rmin.setOrigenTitulos(origen);
        this.logger.debug("Validacion minimo [{}]", (Object)rmin);
        ResponseValidaMinimoSeleccionDTO respmin = clientMinimos.get(rmin, ResponseValidaMinimoSeleccionDTO.class);
        this.logger.debug("Response Minimo [{}]", (Object)respmin);
        return respmin;
    }
}

