/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.condicionesLicense.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.condicionesLicense.constants.TipoCondicion;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PLFAnnioDAO;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PlfRangoDAO;
import com.mx.dla.dda.contrato.condicionesLicense.daos.PlicenseDAO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlfAnnioDTO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlfRangoDTO;
import com.mx.dla.dda.contrato.condicionesLicense.dtos.PlicenseDTO;
import com.mx.dla.dda.contrato.condicionesLicense.exception.CondicionesLicenseException;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CondicionesLicenseBO
extends BaseBO {
    @Autowired
    private CatalogosDAO catalogosDAO;
    @Autowired
    private PLFAnnioDAO plfAnnioDAO;
    @Autowired
    private PlfRangoDAO plfRangoDAO;
    @Autowired
    private PlicenseDAO plicenseDAO;

    public PlicenseDTO buscarCondiciones(PlicenseDTO condiciones) throws ParseException {
        PlicenseDTO c = this.plicenseDAO.buscarPlicense(condiciones.getIdContrato());
        condiciones.setMontoAnio(this.buscarPeriodoAnios(condiciones.getIdContrato(), condiciones.getFechaInicio(), condiciones.getFechaFin()));
        if (c != null) {
            condiciones.setTipoAnio(c.getTipoAnio());
            condiciones.setTipoCondicion(c.getTipoCondicion());
            condiciones.setTipoPeriodoPago(c.getTipoPeriodoPago());
        }
        return condiciones;
    }

    public PlicenseDTO guardarCondiciones(PlicenseDTO condiciones) throws CondicionesLicenseException {
        block6: {
            block5: {
                PlicenseDTO p = this.plicenseDAO.buscarPlicense(condiciones.getIdContrato());
                TipoCondicion tc = TipoCondicion.parse((String)condiciones.getTipoCondicion());
                if (tc == null) {
                    throw new CondicionesLicenseException("Condici\u00c3\u00b3n incorrecta");
                }
                if (p == null) {
                    this.plicenseDAO.insertarPlicense(condiciones);
                } else {
                    this.plicenseDAO.acualizarPlicense(condiciones);
                }
                this.plfAnnioDAO.borrarPlAnnio(condiciones.getIdContrato());
                this.plfRangoDAO.borrarPlRango(condiciones.getIdContrato());
                if (!tc.equals((Object)TipoCondicion.SUSCRIPTORES)) break block5;
                Long index = 0L;
                if (condiciones.getRango() == null) break block6;
                for (int i = 0; i < condiciones.getRango().size(); ++i) {
                    PlfRangoDTO r = (PlfRangoDTO)condiciones.getRango().get(i);
                    if (r == null) continue;
                    r.setIdSuscriptor(index);
                    Long l = index;
                    Long l2 = index = Long.valueOf(index + 1L);
                    r.setIdContrato(condiciones.getIdContrato());
                    this.plfRangoDAO.insertarPlRango(r);
                }
                break block6;
            }
            int i = 0;
            while ((long)i < this.calculaDiferencia(condiciones.getFechaInicio(), condiciones.getFechaFin())) {
                PlfAnnioDTO a = (PlfAnnioDTO)condiciones.getMontoAnio().get(i);
                a.setAnnio(new Long(i + 1));
                a.setIdContrato(condiciones.getIdContrato());
                this.plfAnnioDAO.insertarPlAnnio(a);
                ++i;
            }
        }
        return condiciones;
    }

    public List<PlfRangoDTO> buscarSuscriptores(Long idContrato) throws ParseException {
        List susc = this.plfRangoDAO.buscarPlRango(idContrato);
        return susc;
    }

    public List<PlfAnnioDTO> buscarPeriodoAnios(Long idContrato, Date fechaIni, Date fechaFin) {
        List aniosBD = this.plfAnnioDAO.buscarPlAnnios(idContrato);
        ArrayList<PlfAnnioDTO> anios = new ArrayList<PlfAnnioDTO>();
        Long dif = this.calculaDiferencia(fechaIni, fechaFin);
        if ((long)aniosBD.size() != dif) {
            int i = 0;
            while ((long)i < dif) {
                if (aniosBD.size() <= i) {
                    PlfAnnioDTO a = new PlfAnnioDTO();
                    a.setMonto("");
                    anios.add(a);
                } else {
                    anios.add((PlfAnnioDTO)aniosBD.get(i));
                }
                ++i;
            }
        } else {
            anios.addAll(aniosBD);
        }
        return anios;
    }

    public List<CatalogoDTO> buscarPeriodos() {
        return this.catalogosDAO.buscarPeriodosActivos();
    }

    private Long calculaDiferencia(Date first, Date second) {
        Integer diff = 0;
        Integer diffYears = (second.getYear() - first.getYear()) * 12;
        diff = diffYears - first.getMonth();
        diff = diff + second.getMonth();
        this.logger.debug("total of months [{}]", (Object)diff);
        return diff.longValue();
    }
}

