/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.fees.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.CategoriaFeesDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoCostoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoFlat;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoRangoDTO;
import com.mx.dla.dda.contrato.minimoseleccion.bos.MinimoSeleccionBO;
import com.mx.dla.global.bos.BaseBO;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FeesCategoriaBO
extends BaseBO {
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    @Autowired
    private MinimoSeleccionBO minimoSeleccionBO;

    public void guardarCategorias(List<FeesContratoPagoDTO> periodos, Long idContrato) throws UnsupportedEncodingException {
        block5: {
            block4: {
                if (periodos.get(0).getTipoPago().compareTo("ESCALA") != 0) break block4;
                for (int i = 0; i < periodos.get(0).getCategorias().size(); ++i) {
                    CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(((FeesPagoCostoDTO)periodos.get(0).getCategorias().get(i)).getDescCategoria(), "UTF-8"));
                    this.feesContratoDAO.guardarCategoria(categoria, idContrato);
                    for (int j = 0; j < periodos.size(); ++j) {
                        ((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).setIdCategoria(categoria.getIdCategoria());
                    }
                }
                break block5;
            }
            if (periodos.get(0).getTipoPago().compareTo("FLAT") != 0) break block5;
            for (int i = 0; i < periodos.get(0).getFlats().size(); ++i) {
                CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(((FeesPagoFlat)periodos.get(0).getFlats().get(i)).getDescCategoria(), "UTF-8"));
                this.feesContratoDAO.guardarCategoria(categoria, idContrato);
                for (int j = 0; j < periodos.size(); ++j) {
                    ((FeesPagoFlat)periodos.get(j).getFlats().get(i)).setIdCategoria(categoria.getIdCategoria());
                }
            }
        }
    }

    public void editarCategorias(List<FeesContratoPagoDTO> periodos, Long idContrato) throws UnsupportedEncodingException {
        block8: {
            block7: {
                if (periodos.get(0).getTipoPago().compareTo("ESCALA") != 0) break block7;
                for (int i = 0; i < periodos.get(0).getCategorias().size(); ++i) {
                    CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(((FeesPagoCostoDTO)periodos.get(0).getCategorias().get(i)).getDescCategoria(), "UTF-8"));
                    categoria.setIdCategoria(((FeesPagoCostoDTO)periodos.get(0).getCategorias().get(i)).getIdCategoria());
                    if (((FeesPagoCostoDTO)periodos.get(0).getCategorias().get(i)).getIdCategoria() <= 0L) {
                        this.feesContratoDAO.guardarCategoria(categoria, idContrato);
                        for (int j = 0; j < periodos.size(); ++j) {
                            ((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).setIdCategoria(categoria.getIdCategoria());
                            if (periodos.get(j).getIdContratoPago() <= 0L) continue;
                            this.minimoSeleccionBO.guardarMinSeleccion(periodos.get(j).getIdContratoPago(), categoria.getIdCategoria(), null);
                            for (int r = 0; r < ((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).getRangos().size(); ++r) {
                                if (((FeesPagoRangoDTO)((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).getRangos().get(r)).getIdRango() <= 0L) continue;
                                this.feesContratoDAO.guardarPagoCosto(((FeesPagoRangoDTO)((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).getRangos().get(r)).getIdRango(), ((FeesPagoRangoDTO)((FeesPagoCostoDTO)periodos.get(j).getCategorias().get(i)).getRangos().get(r)).getMonto(), categoria.getIdCategoria());
                            }
                        }
                        continue;
                    }
                    this.feesContratoDAO.actualizarCategoria(categoria);
                }
                break block8;
            }
            if (periodos.get(0).getTipoPago().compareTo("FLAT") != 0) break block8;
            for (int i = 0; i < periodos.get(0).getFlats().size(); ++i) {
                CategoriaFeesDTO categoria = new CategoriaFeesDTO(URLDecoder.decode(((FeesPagoFlat)periodos.get(0).getFlats().get(i)).getDescCategoria(), "UTF-8"));
                categoria.setIdCategoria(((FeesPagoFlat)periodos.get(0).getFlats().get(i)).getIdCategoria());
                if (((FeesPagoFlat)periodos.get(0).getFlats().get(i)).getIdCategoria() <= 0L) {
                    this.feesContratoDAO.guardarCategoria(categoria, idContrato);
                    for (int j = 0; j < periodos.size(); ++j) {
                        ((FeesPagoFlat)periodos.get(j).getFlats().get(i)).setIdCategoria(categoria.getIdCategoria());
                    }
                    continue;
                }
                this.feesContratoDAO.actualizarCategoria(categoria);
            }
        }
    }

    public void eliminarCategorias(Long idContrato) {
        this.feesContratoDAO.eliminarCategoriasContrato(idContrato);
    }

    public List<CategoriaFeesDTO> getCategoriasTitulosXContrato(Long idContrato) {
        return this.feesContratoDAO.getCategoriasTitulosXContrato(idContrato);
    }

    public List<CategoriaFeesDTO> getCategoriasTitulosXCategoria(Long idCategoria) {
        return this.feesContratoDAO.getCategoriasTitulosXCategoria(idCategoria);
    }

    public List<FeesContratoPagoDTO> eliminarCategoriaFlat(Long idCategoria, List<FeesContratoPagoDTO> periodos) {
        this.feesContratoDAO.eliminarPagoFlatByCategoria(idCategoria);
        for (FeesContratoPagoDTO periodo : periodos) {
            this.minimoSeleccionBO.eliminarMinSeleccion(periodo.getIdContratoPago(), idCategoria);
            int index = -1;
            for (int i = 0; i < periodo.getFlats().size(); ++i) {
                if (((FeesPagoFlat)periodo.getFlats().get(i)).getIdCategoria().longValue() != idCategoria.longValue()) continue;
                index = i;
            }
            if (index == -1) continue;
            periodo.getFlats().remove(index);
        }
        this.feesContratoDAO.actualizarTitulosTCateg(idCategoria);
        this.feesContratoDAO.actualizarTitulosMCateg(idCategoria);
        this.feesContratoDAO.eliminarPagoCategoria(idCategoria);
        return periodos;
    }

    public String actualizarCostoTitulos(Map<String, Object> paramNumeroContrato) {
        return this.feesContratoDAO.actualizarCostoTitulos(paramNumeroContrato);
    }
}

