/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.fees.bos;

import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.fees.bos.FeesBonoBO;
import com.mx.dla.dda.contrato.fees.bos.FeesCategoriaBO;
import com.mx.dla.dda.contrato.fees.bos.FeesFlatBO;
import com.mx.dla.dda.contrato.fees.bos.FeesSuscriptorBO;
import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesContratoPagoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesFlatBD;
import com.mx.dla.dda.contrato.fees.dtos.FeesPagoCostoDTO;
import com.mx.dla.dda.contrato.fees.dtos.FeesSuscriptorBD;
import com.mx.dla.dda.contrato.generales.bos.GeneralesBO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.titulo.bos.TitulosBussinesBO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FeesContratoBO
extends BaseBO {
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    @Autowired
    private AmortizacionDAO amortizacionDAO;
    @Autowired
    private FeesSuscriptorBO feesSuscriptorBO;
    @Autowired
    private FeesFlatBO feesFlatBO;
    @Autowired
    private FeesBonoBO feesBonoBO;
    @Autowired
    private FeesCategoriaBO feesCategoriaBO;
    @Autowired
    private GeneralesBO generalesBO;
    @Autowired
    private TitulosBussinesBO titulosBussinesBO;
    private ContratoDTO cto;

    public List<FeesContratoPagoDTO> getDatosFees(Long idContrato) throws Exception {
        ArrayList<FeesContratoPagoDTO> datos = new ArrayList<FeesContratoPagoDTO>();
        List periodos = this.feesContratoDAO.getPeriodos(idContrato);
        try {
            if (periodos.isEmpty()) {
                FeesContratoPagoDTO dato = this.feesSuscriptorBO.crearSuscriptor(null, null);
                FeesContratoPagoDTO datoFlat = this.feesFlatBO.crearFlat(null, null);
                dato.setFlats(datoFlat.getFlats());
                dato.setMaxAnios(datoFlat.getMaxAnios());
                datos.add(dato);
            } else {
                List suscriptores = new ArrayList();
                List flats = new ArrayList();
                ArrayList<Long> idsPeriodos = new ArrayList<Long>();
                for (FeesContratoPagoBD item : periodos) {
                    idsPeriodos.add(item.getIdContratoPago());
                }
                if (((FeesContratoPagoBD)periodos.get(0)).getTipoPago().compareTo("ESCALA") == 0) {
                    suscriptores = this.feesContratoDAO.getFeesSuscriptor(idsPeriodos);
                    for (FeesContratoPagoBD periodo : periodos) {
                        ArrayList<FeesSuscriptorBD> temporal = new ArrayList<FeesSuscriptorBD>();
                        for (FeesSuscriptorBD suscriptor : suscriptores) {
                            if (periodo.getIdContratoPago().longValue() != suscriptor.getIdContratoPago().longValue()) continue;
                            temporal.add(suscriptor);
                        }
                        datos.add(this.feesSuscriptorBO.crearSuscriptor(periodo, temporal));
                    }
                } else if (((FeesContratoPagoBD)periodos.get(0)).getTipoPago().compareTo("FLAT") == 0) {
                    flats = this.feesContratoDAO.getFeesFlat(idsPeriodos);
                    for (FeesContratoPagoBD periodo : periodos) {
                        ArrayList<FeesFlatBD> temporal = new ArrayList<FeesFlatBD>();
                        for (FeesFlatBD flat : flats) {
                            if (periodo.getIdContratoPago().longValue() != flat.getIdContratoPago().longValue()) continue;
                            temporal.add(flat);
                        }
                        datos.add(this.feesFlatBO.crearFlat(periodo, temporal));
                    }
                } else if (((FeesContratoPagoBD)periodos.get(0)).getTipoPago().compareTo("NA") == 0) {
                    for (FeesContratoPagoBD periodo : periodos) {
                        datos.add(this.crearFeesNA(periodo));
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new Exception(e);
        }
        return datos;
    }

    public void guardarPagosFees(List<FeesContratoPagoDTO> periodos, Long idContrato) throws ParseException, Exception {
        try {
            this.feesCategoriaBO.guardarCategorias(periodos, idContrato);
            for (FeesContratoPagoDTO periodo : periodos) {
                if (periodo.getTipoPago().compareTo("ESCALA") == 0) {
                    this.feesSuscriptorBO.guardarSuscriptor(periodo, idContrato);
                    continue;
                }
                if (periodo.getTipoPago().compareTo("FLAT") == 0) {
                    this.feesFlatBO.guardarFlat(periodo, idContrato);
                    continue;
                }
                if (periodo.getTipoPago().compareTo("NA") != 0) continue;
                this.guardarFeesNA(idContrato);
            }
        }
        catch (Exception e) {
            this.logger.error("Error ", (Throwable)e);
            throw new Exception(e);
        }
    }

    public void editarPagosFees(List<FeesContratoPagoDTO> periodos, Long idContrato) throws ParseException, Exception {
        try {
            this.feesCategoriaBO.editarCategorias(periodos, idContrato);
            this.logger.info("Se han editado las categorias");
            if (periodos.get(0).getTipoPago().compareTo("ESCALA") == 0) {
                this.feesSuscriptorBO.eliminarRangosCostoSuscriptor(idContrato);
            } else if (periodos.get(0).getTipoPago().compareTo("FLAT") == 0) {
                this.feesFlatBO.eliminarPagosFlat(idContrato);
            }
            for (FeesContratoPagoDTO periodo : periodos) {
                if (periodo.getTipoPago().compareTo("ESCALA") == 0) {
                    if (periodo.getIdContratoPago() <= 0L) {
                        this.feesSuscriptorBO.guardarSuscriptor(periodo, idContrato);
                        continue;
                    }
                    this.feesSuscriptorBO.editarSuscriptor(periodo);
                    continue;
                }
                if (periodo.getTipoPago().compareTo("FLAT") != 0) continue;
                if (periodo.getIdContratoPago() <= 0L) {
                    this.feesFlatBO.guardarFlat(periodo, idContrato);
                    continue;
                }
                this.feesFlatBO.editarFlat(periodo);
            }
        }
        catch (Exception e) {
            this.logger.error("Error {}", (Throwable)e);
            throw new Exception(e);
        }
    }

    public void eliminarPagosFees(Long idContrato) throws ParseException, Exception {
        String tipo = this.feesContratoDAO.getTipoFees(idContrato);
        try {
            if (tipo.compareTo("ESCALA") == 0) {
                this.feesSuscriptorBO.eliminarSuscriptores(idContrato);
            } else if (tipo.compareTo("FLAT") == 0) {
                this.feesFlatBO.eliminarFlats(idContrato);
            } else if (tipo.compareTo("NA") == 0) {
                this.feesContratoDAO.eliminarContratoPagoXCto(idContrato);
            }
        }
        catch (Exception e) {
            this.logger.error("Error {}", (Throwable)e);
            throw new Exception(e);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarProcesoFees(String request, String requestBono, Integer inflacion, Long idContrato, String operacion, String periodosEliminar, String categoriasEliminar) throws ParseException, Exception {
        ObjectMapper mapper = new ObjectMapper();
        List<FeesContratoPagoDTO> datos = (List<FeesContratoPagoDTO>)mapper.readValue(request, (TypeReference)new TypeReference<List<FeesContratoPagoDTO>>(){});
        if (datos != null) {
            if (operacion.compareTo("nuevo") == 0) {
                this.guardarPagosFees(datos, idContrato);
                this.logger.info("Se guarda informacion por primera vez.");
            } else if (operacion.compareTo("resetear") == 0) {
                this.logger.info("Se guarda informacion resetear.");
                this.eliminarPagosFees(idContrato);
                this.feesCategoriaBO.eliminarCategorias(idContrato);
                this.guardarPagosFees(datos, idContrato);
            } else if (operacion.compareTo("limpiar") == 0) {
                this.eliminarPagosFees(idContrato);
                this.feesCategoriaBO.eliminarCategorias(idContrato);
                this.logger.info("Se guarda informacion limpiar.");
            } else if (operacion.compareTo("actualizar") == 0) {
                if (periodosEliminar != null) {
                    List periodosBorrar = (List)mapper.readValue(periodosEliminar, (TypeReference)new TypeReference<List<FeesContratoPagoDTO>>(){});
                    for (FeesContratoPagoDTO item : periodosBorrar) {
                        if (item.getTipoPago().compareTo("ESCALA") == 0) {
                            this.feesSuscriptorBO.eliminarSuscriptor(item);
                            continue;
                        }
                        this.feesFlatBO.eliminarFlat(item);
                    }
                    this.logger.info("Se eliminan los periodos.");
                }
                if (categoriasEliminar != null) {
                    List feesEliminar = (List)mapper.readValue(categoriasEliminar, (TypeReference)new TypeReference<List<FeesContratoPagoDTO>>(){});
                    for (FeesContratoPagoDTO item : feesEliminar) {
                        if (item.getTipoPago().compareTo("0") == 0) {
                            datos = this.feesSuscriptorBO.eliminarCategoriaSuscriptor(((FeesPagoCostoDTO)item.getCategorias().get(0)).getIdCategoria(), datos);
                        }
                        if (item.getTipoPago().compareTo("1") == 0) {
                            datos = this.feesCategoriaBO.eliminarCategoriaFlat(((FeesPagoCostoDTO)item.getCategorias().get(0)).getIdCategoria(), datos);
                        }
                        if (item.getTipoPago().compareTo("2") != 0) continue;
                        this.feesBonoBO.eliminarRangoBono(item);
                    }
                    this.logger.info("Se eliminan las categorias.");
                }
                if (datos.size() > 0) {
                    if (((FeesContratoPagoDTO)datos.get(0)).getCategorias() != null || ((FeesContratoPagoDTO)datos.get(0)).getFlats() != null) {
                        this.editarPagosFees(datos, idContrato);
                        this.logger.info("se editan los datos.");
                    }
                } else {
                    this.feesCategoriaBO.eliminarCategorias(idContrato);
                    this.logger.info("se elimian categorias??.");
                }
            }
            this.amortizacionDAO.updateContratoProceso(idContrato, Integer.valueOf(1));
        }
        this.titulosBussinesBO.procesoActualizacionTitulosEnmienda(idContrato);
        this.feesBonoBO.guardarBono(requestBono, idContrato);
        this.actualizarInflacionCto(inflacion, idContrato);
    }

    public int verificarCategoriasTitulos(String operacion, Long id) {
        int numero = 0;
        if (operacion.compareTo("1") == 0) {
            numero = this.feesCategoriaBO.getCategoriasTitulosXCategoria(id).size();
        } else if (operacion.compareTo("2") == 0) {
            numero = this.feesCategoriaBO.getCategoriasTitulosXContrato(id).size();
        } else if (operacion.compareTo("3") == 0) {
            numero = this.feesCategoriaBO.getCategoriasTitulosXContrato(id).size();
        }
        return numero;
    }

    public String actualizarCostoTitulos(Map<String, Object> paramNumeroContrato) {
        return this.feesCategoriaBO.actualizarCostoTitulos(paramNumeroContrato);
    }

    public FeesContratoPagoDTO crearFeesNA(FeesContratoPagoBD pagoBD) {
        FeesContratoPagoDTO fee = new FeesContratoPagoDTO();
        if (pagoBD == null) {
            fee.setTipoPago("NA");
        } else {
            fee.setTipoPago(pagoBD.getTipoPago());
        }
        return fee;
    }

    public void guardarFeesNA(Long idContrato) throws ParseException, Exception {
        FeesContratoPagoBD contratoPago = new FeesContratoPagoBD();
        contratoPago.setIdContrato(idContrato);
        contratoPago.setTipoPago("NA");
        this.feesContratoDAO.guardarContratoPago(contratoPago);
    }

    public List<String> getVigenciaContrato(Long idContrato) throws ParseException {
        ArrayList<String> fechas = new ArrayList<String>();
        String inicio = this.feesContratoDAO.fechaInicio(idContrato);
        String fin = this.feesContratoDAO.fechaFin(idContrato);
        fechas.add(inicio);
        fechas.add(fin);
        return fechas;
    }

    public void actualizarInflacionCto(Integer inflacion, Long idContrato) {
        String inflaCto = inflacion != null ? String.valueOf(inflacion) : "";
        this.feesContratoDAO.actualizarInflacionCto(inflaCto, idContrato);
    }

    public Long obtenerEdoContrato(Long idContrato) {
        this.cto = this.generalesBO.obtenContrato(idContrato);
        return this.cto.getIdEstatus();
    }

    public Integer getInflacionCto() {
        Integer inflacion = null;
        if (this.cto.getInflacion() != null && this.cto.getInflacion().compareTo("") != 0 && Integer.parseInt(this.cto.getInflacion()) > 0) {
            inflacion = Integer.parseInt(this.cto.getInflacion());
        }
        return inflacion;
    }

    public String getCostoTotal(Long idContrato) {
        return this.feesContratoDAO.getCostoTotal(idContrato);
    }
}

