/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.generales.bos;

import com.mx.dla.dda.contrato.amortizacion.constants.TipoAmortizacion;
import com.mx.dla.dda.contrato.amortizacion.daos.AmortizacionDAO;
import com.mx.dla.dda.contrato.generales.bos.PoblarGeneralesBO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.AreaDTO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.DetalleCatalogoContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.InfoDetalleContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.context.ExcelMapperContext;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.dda.restClient.bos.DLARestClientFactory;
import com.mx.dla.global.bos.BaseBO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GeneralesBO
extends BaseBO {
    @Autowired
    private GeneralesDAO generalesDAO;
    @Autowired
    private AmortizacionDAO amortizacionDAO;
    @Autowired
    private PoblarGeneralesBO poblarGeneralesBO;
    @Autowired
    private ExcelMapperContext excelMapperContext;
    @Autowired
    protected ExcelMapperTransform excelMapperTransform;
    @Autowired
    public DLARestClientFactory dlaRestClientFactory;

    public ContratoDTO registraContrato(Long campoEstudio, Long estatus, Long tipoOperacion, Long tipoContrato, Date campoFechaInicio, Date campoFechaFin, Long apartado, String annios, String meses, String tipoAmortizacion, Date fechaAutorizacion, String claveIva) {
        estatus = Estatus.Registro.getValor();
        ContratoDTO contratoNuevo = new ContratoDTO();
        HashMap<String, Object> paramNumeroContrato = new HashMap<String, Object>();
        boolean esVirtual = false;
        try {
            esVirtual = this.esEstudioVirtual(campoEstudio);
            contratoNuevo.setIdEstudio(campoEstudio);
            contratoNuevo.setIdEstatus(estatus);
            contratoNuevo.setIdTipoMovimiento(tipoOperacion);
            contratoNuevo.setIdTipoContrato(tipoContrato);
            contratoNuevo.setIdApartado(null);
            contratoNuevo.setFechaFin(campoFechaFin);
            contratoNuevo.setFechaInicio(campoFechaInicio);
            contratoNuevo.setIdContratoOriginal(contratoNuevo.getIdContrato());
            contratoNuevo.setFechaAlta(new Date());
            contratoNuevo.setAnnios(annios);
            contratoNuevo.setMeses(meses);
            contratoNuevo.setIdApartado(apartado);
            contratoNuevo.setFechaAutorizacion(fechaAutorizacion);
            contratoNuevo.setClaveIva(claveIva);
            if (contratoNuevo.getIdTipoContrato() == 1L) {
                contratoNuevo.setAmortizable("SI");
            } else {
                contratoNuevo.setAmortizable("NO");
            }
            if (tipoContrato == 1L) {
                if (tipoAmortizacion != null) {
                    contratoNuevo.setTipoAmortizacion(TipoAmortizacion.EXCLUSIVIDAD.name());
                } else {
                    contratoNuevo.setTipoAmortizacion(TipoAmortizacion.LINEAL.name());
                }
            }
            this.generalesDAO.registrarContrato(contratoNuevo);
            this.logger.debug(" idContrato desde insert : " + contratoNuevo.getIdContrato() + " tipoOperacion : " + tipoOperacion);
            paramNumeroContrato.put("idEstudio", campoEstudio);
            paramNumeroContrato.put("idTipo", tipoContrato);
            paramNumeroContrato.put("idContrato", contratoNuevo.getIdContrato());
            paramNumeroContrato.put("idMovimiento", tipoOperacion);
            paramNumeroContrato.put("numeroContrato", "");
            if (esVirtual) {
                String ceros = "000000";
                ceros = ceros.substring(0, contratoNuevo.getIdContrato().toString().length());
                contratoNuevo.setNumeroContrato("ETV" + ceros + contratoNuevo.getIdContrato());
            } else {
                this.generalesDAO.llamarCrearNumeroContrato(paramNumeroContrato);
                this.logger.debug("N\u00famero de contrato recuperado : [{}]", paramNumeroContrato);
                contratoNuevo.setNumeroContrato((String)paramNumeroContrato.get("numeroContrato"));
            }
            this.logger.debug("N\u00famero de contrato seteado en ContratoDTO : [{}]", (Object)contratoNuevo.getNumeroContrato());
            this.generalesDAO.actualizaNumeroContrato(contratoNuevo.getIdContrato(), contratoNuevo.getNumeroContrato());
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        this.logger.debug(contratoNuevo.toString());
        return contratoNuevo;
    }

    public void registraContratoProceso(Long idContrato) {
        this.logger.debug("En registraContratoProceso --  idContrato : [{}]", (Object)idContrato);
        try {
            this.amortizacionDAO.insertContratoProceso(idContrato, Integer.valueOf(0));
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public String actualizaContratoProceso(Long idContrato, Integer valorAmortizacion) {
        String mensaje = "OK";
        try {
            this.amortizacionDAO.updateContratoProceso(idContrato, valorAmortizacion);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
            mensaje = "Fallo al Actualizar";
        }
        return mensaje;
    }

    public ContratoDTO obtenContrato(Long idContrato) {
        ContratoDTO contrato = null;
        try {
            contrato = this.generalesDAO.obtenerContrato(idContrato);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return contrato;
    }

    public void actualizaContrato(Long campoContrato, Long campoEstudio, Date campoFechaInicio, Date campoFechaFin, Long apartado, String annios, String meses, Date campoFechaAutorizacion, String indicador) {
        try {
            this.generalesDAO.actualizaContrato(campoContrato, campoEstudio, campoFechaInicio, campoFechaFin, apartado, annios, meses, campoFechaAutorizacion, indicador);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public void cambiarAddendum(Long idContrato, String numeroContrato) {
        numeroContrato = numeroContrato.substring(0, 9) + "A";
        this.generalesDAO.cambiarAddendum(idContrato, numeroContrato);
    }

    public boolean eliminaContrato(Long idContrato) {
        Long noError = 0L;
        boolean respuestaDeEliminar = false;
        HashMap<String, Object> parametroSP = new HashMap<String, Object>();
        parametroSP.put("idContrato", idContrato);
        parametroSP.put("noError", 0L);
        parametroSP.put("strError", "");
        try {
            this.generalesDAO.llamarEliminaContrato(parametroSP);
            this.logger.debug("noError : [{}]", parametroSP.get("noError"));
            this.logger.debug("strError : [{}]", parametroSP.get("strError"));
            noError = (Long)parametroSP.get("noError");
            if (noError >= 0L) {
                respuestaDeEliminar = true;
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return respuestaDeEliminar;
    }

    public void cambiaEstudioVirtualContrato(Long idContrato, Long idEstudioOficial, Long idEstudio, boolean eliminaVirtual) {
        HashMap<String, Object> paramNumeroContrato = new HashMap<String, Object>();
        try {
            this.generalesDAO.actualizaIdEstudioContrato(idContrato, idEstudioOficial);
            ContratoDTO contrato = this.generalesDAO.obtenerContrato(idContrato);
            paramNumeroContrato.put("idEstudio", idEstudioOficial);
            paramNumeroContrato.put("idTipo", contrato.getIdTipoContrato());
            paramNumeroContrato.put("idContrato", contrato.getIdContrato());
            paramNumeroContrato.put("idMovimiento", contrato.getIdTipoMovimiento());
            paramNumeroContrato.put("numeroContrato", "");
            this.generalesDAO.llamarCrearNumeroContrato(paramNumeroContrato);
            contrato.setNumeroContrato((String)paramNumeroContrato.get("numeroContrato"));
            this.generalesDAO.actualizaNumeroContrato(contrato.getIdContrato(), contrato.getNumeroContrato());
            this.generalesDAO.actulizaEstudioTitulos(idEstudio, idEstudioOficial);
            if (eliminaVirtual) {
                this.generalesDAO.eliminaEstudioVirtual(idEstudio);
            }
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
    }

    public boolean esEstudioVirtual(Long idEstudio) {
        String idSap = null;
        try {
            idSap = this.generalesDAO.obtenIdSapEstudio(idEstudio);
        }
        catch (Exception ex) {
            this.logger.error("", (Throwable)ex);
        }
        return idSap == null;
    }

    public String obtenerFechaSAP() {
        String fechaSAP = null;
        try {
            fechaSAP = this.generalesDAO.obtenerFechaSAP();
        }
        catch (Exception ex) {
            this.logger.error("Erro : [{}]", (Throwable)ex);
        }
        return fechaSAP;
    }

    public AreaDTO obtenerAreaPorExpediente(String expediente) {
        AreaDTO area = null;
        try {
            area = this.generalesDAO.obtenerAreaPorExpediente(expediente);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return area;
    }

    public AreaDTO obtenerAreaPorOrdenWF(Integer ordenWF) {
        AreaDTO area = null;
        try {
            area = this.generalesDAO.obtenerAreaPorOrdenWF(ordenWF);
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return area;
    }

    public List<AreaDTO> obtenerAreasFinalizadoras() {
        List areas = null;
        try {
            areas = this.generalesDAO.obtenerAreasFinalizadoras();
        }
        catch (Exception ex) {
            this.logger.error("Error : [{}]", (Throwable)ex);
        }
        return areas;
    }

    public List<DetalleCatalogoContratoDTO> detalleContrato(Long idContrato) {
        ArrayList<DetalleCatalogoContratoDTO> detalleCompleto = new ArrayList<DetalleCatalogoContratoDTO>();
        try {
            InfoDetalleContratoDTO detalleContrato = this.generalesDAO.obtenDetalleContrato(idContrato);
            List catalogosContrato = this.generalesDAO.obtenDetalleCatalogos(idContrato);
            detalleCompleto.add(this.creaDetalleCatalogoContrato("N\u00famero Contrato", detalleContrato.getNumeroContrato()));
            detalleCompleto.add(this.creaDetalleCatalogoContrato("Estudio", detalleContrato.getDescripcionEstudio()));
            detalleCompleto.add(this.creaDetalleCatalogoContrato("Vigencia", this.poblarGeneralesBO.formateaFecha(detalleContrato.getFechaInicio()) + " - " + this.poblarGeneralesBO.formateaFecha(detalleContrato.getFechaFin())));
            detalleCompleto.add(this.creaDetalleCatalogoContrato("Estatus", detalleContrato.getDescripcionEstatus()));
            detalleCompleto.add(this.creaDetalleCatalogoContrato("Apartado", detalleContrato.getDescripcionApartado()));
            if (detalleContrato.getFechaAutorizacion() != null) {
                detalleCompleto.add(this.creaDetalleCatalogoContrato("Fecha Autorizaci\u00f3n", this.poblarGeneralesBO.formateaFecha(detalleContrato.getFechaAutorizacion())));
            }
            for (DetalleCatalogoContratoDTO cc : catalogosContrato) {
                detalleCompleto.add(cc);
            }
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
        }
        return detalleCompleto;
    }

    public DetalleCatalogoContratoDTO creaDetalleCatalogoContrato(String tipo, String value) {
        DetalleCatalogoContratoDTO dcc = new DetalleCatalogoContratoDTO();
        dcc.setTipo(tipo);
        dcc.setLista(value);
        return dcc;
    }

    public InputStream h(Long idContrato) {
        byte[] bytesExcel = null;
        ExcelMapper mapper = null;
        ByteArrayInputStream is = null;
        try {
            mapper = this.excelMapperContext.getExcelMapper("detalleContrato");
            bytesExcel = this.excelMapperTransform.transformObjectToExcel(this.detalleContrato(idContrato), mapper, DetalleCatalogoContratoDTO.class);
            is = new ByteArrayInputStream(bytesExcel);
        }
        catch (ExcelMapperException e) {
            this.logger.error("[{}]", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("[{}]", (Throwable)e);
        }
        return is;
    }

    public void crearListaNuevaTransaccion(Long idContrato, Date fechaInicio) {
        try {
            this.generalesDAO.crearListaNuevaTransaccion(idContrato, fechaInicio);
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
        }
    }

    public void actualizaFechaInicioLista(Long idContrato, Date fechaInicio) {
        try {
            this.logger.info("en Generales BO TIPO CONTRATO :" + idContrato + "|" + fechaInicio);
            SimpleDateFormat formatoEntrada = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String fecha = formatoEntrada.format(fechaInicio);
            this.logger.info("en Generales BO fechaInicio 11111111:" + fecha);
            SimpleDateFormat formatoFecha = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date fechaInicioLista = formatoFecha.parse(fecha);
            this.logger.info("en Generales BO fechaInicio 2222222:" + fechaInicioLista);
            this.generalesDAO.actualizaFechaLista(idContrato, fechaInicio);
        }
        catch (Exception ex) {
            this.logger.error("[{}]", (Throwable)ex);
        }
    }
}

