/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.listado.bos;

import com.mx.dla.dda.contrato.common.daos.DocumentoDAO;
import com.mx.dla.dda.contrato.common.dtos.DocumentoDTO;
import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.generales.enums.Estatus;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.dda.contrato.listado.daos.ListadoDAO;
import com.mx.dla.dda.contrato.listado.dtos.ContratoListaDTO;
import com.mx.dla.dda.contrato.listado.dtos.ListadoBD;
import com.mx.dla.dda.contrato.listado.dtos.RequestListadoDTO;
import com.mx.dla.global.bos.BaseBO;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ListadoContratoBO
extends BaseBO {
    @Autowired
    private ListadoDAO listadoDAO;
    @Autowired
    private DocumentoDAO documentoDAO;
    @Autowired
    private FeesContratoDAO feesContratoDAO;

    public List<ContratoListaDTO> getListadoContratos(RequestListadoDTO request) throws ParseException {
        ArrayList<ContratoListaDTO> listado = new ArrayList<ContratoListaDTO>();
        List listadoBD = this.listadoDAO.getContratosListado(request);
        for (ListadoBD bd : listadoBD) {
            int tipo = bd.getIndentar();
            if (bd.getEstatus() != null && bd.getEstatus().equals(Estatus.Rechazado.getDescripcion()) && !request.getRechazado().booleanValue()) {
                tipo = -1;
            }
            switch (tipo) {
                case 0: {
                    listado.add(this.listadoBD2ListadoDTO(bd, 0));
                    break;
                }
                case 1: {
                    ContratoListaDTO cto = this.listadoBD2ListadoDTO(bd, 1);
                    if (cto.getEstatus().compareTo(Estatus.Vigente.getDescripcion()) == 0) {
                        cto.setAdendum(Boolean.valueOf(true));
                        cto.setEnmienda(Boolean.valueOf(true));
                    }
                    listado.add(cto);
                    break;
                }
                case 2: {
                    this.asignarHijos2Nivel(listado, bd);
                    break;
                }
                case 3: {
                    this.asignarHijos3Nivel(listado, bd);
                    break;
                }
                case -1: {
                    this.logger.info("Cto Rechazado no ver.");
                }
            }
        }
        for (ContratoListaDTO c : ListadoContratoBO.safeList(listado)) {
            boolean res = this.verificarHijos(c);
            if (res) continue;
            this.quitarLinks(c);
        }
        return listado;
    }

    public boolean verificarHijos(ContratoListaDTO cto) {
        boolean resultado = true;
        if (cto == null || cto.getEstatus() == null) {
            return true;
        }
        if (cto.getHijos() != null && !cto.getHijos().isEmpty()) {
            for (int i = 0; i < cto.getHijos().size(); ++i) {
                boolean res = this.verificarHijos((ContratoListaDTO)cto.getHijos().get(i));
                if (res) continue;
                return false;
            }
        }
        resultado = cto != null && cto.getEstatus() != null && cto.getEstatus().equals(Estatus.Vigente.getDescripcion()) || cto.getEstatus().equals(Estatus.Autorizado.getDescripcion());
        return resultado;
    }

    public void quitarLinks(ContratoListaDTO cto) {
        if (cto != null) {
            cto.setAdendum(Boolean.valueOf(false));
            cto.setEnmienda(Boolean.valueOf(false));
        }
        if (cto != null && cto.getHijos() != null && !cto.getHijos().isEmpty()) {
            for (int i = 0; i < cto.getHijos().size(); ++i) {
                ((ContratoListaDTO)cto.getHijos().get(i)).setAdendum(Boolean.valueOf(false));
                ((ContratoListaDTO)cto.getHijos().get(i)).setEnmienda(Boolean.valueOf(false));
                this.quitarLinks((ContratoListaDTO)cto.getHijos().get(i));
            }
        }
    }

    public void verificarHijosVigente(ContratoListaDTO cto) {
        if (cto.getEstatus() != null && cto.getHijos() != null && !cto.getHijos().isEmpty() && (cto.getEstatus().equals(Estatus.Vigente.getDescripcion()) || cto.getEstatus().equals(Estatus.Autorizado.getDescripcion()))) {
            boolean add = false;
            for (ContratoListaDTO c : ListadoContratoBO.safeList(cto.getHijos())) {
                if (c.getEstatus().equals(Estatus.Rechazado.getDescripcion())) {
                    add = true;
                }
                if (c.getEstatus().equals(Estatus.Vigente.getDescripcion()) || c.getEstatus().equals(Estatus.Autorizado.getDescripcion())) {
                    add = true;
                }
                this.verificarHijosVigente(c);
            }
            if (!add) {
                cto.setAdendum(Boolean.valueOf(false));
                cto.setEnmienda(Boolean.valueOf(false));
            }
        } else if (cto.getEstatus() != null && (cto.getHijos() == null || cto.getHijos() != null && cto.getHijos().isEmpty()) && (cto.getEstatus().equals(Estatus.Vigente.getDescripcion()) || cto.getEstatus().equals(Estatus.Autorizado.getDescripcion()))) {
            cto.setAdendum(Boolean.valueOf(true));
            cto.setEnmienda(Boolean.valueOf(true));
        } else {
            cto.setAdendum(Boolean.valueOf(false));
            cto.setEnmienda(Boolean.valueOf(false));
        }
    }

    public List<ContratoListaDTO> asignarHijos2Nivel(List<ContratoListaDTO> listado, ListadoBD bd) {
        for (ContratoListaDTO contrato : ListadoContratoBO.safeList(listado)) {
            if (contrato.getIdContrato() == null || contrato.getIdContrato().longValue() != bd.getIdPadre().longValue()) continue;
            ContratoListaDTO cto = this.listadoBD2ListadoDTO(bd, 2);
            if (cto.getDescripcion().compareTo(Movimiento.Adendum.getDescripcion()) == 0 && (cto.getEstatus().compareTo(Estatus.Vigente.getDescripcion()) == 0 || cto.getEstatus().compareTo(Estatus.Autorizado.getDescripcion()) == 0)) {
                cto.setEnmienda(Boolean.valueOf(true));
                cto.setAdendum(Boolean.valueOf(false));
            }
            contrato.getHijos().add(cto);
            contrato.setAdendum(Boolean.valueOf(true));
            contrato.setEnmienda(Boolean.valueOf(true));
        }
        return listado;
    }

    public List<ContratoListaDTO> asignarHijos3Nivel(List<ContratoListaDTO> listado, ListadoBD bd) {
        for (ContratoListaDTO contrato : listado) {
            for (ContratoListaDTO ctoHijo : ListadoContratoBO.safeList(contrato.getHijos())) {
                if (ctoHijo.getIdContrato().longValue() != bd.getIdContratoOriginal().longValue()) continue;
                ContratoListaDTO cto = this.listadoBD2ListadoDTO(bd, 3);
                ctoHijo.getHijos().add(cto);
                if (ctoHijo.getDescripcion().compareTo(Movimiento.Adendum.getDescripcion()) != 0) continue;
                ctoHijo.setEnmienda(Boolean.valueOf(true));
                ctoHijo.setAdendum(Boolean.valueOf(false));
            }
        }
        return listado;
    }

    public ContratoListaDTO listadoBD2ListadoDTO(ListadoBD bd, int tipo) {
        ContratoListaDTO contrato = new ContratoListaDTO();
        contrato.setAbierto(Boolean.valueOf(false));
        if (Objects.nonNull(bd.getNumeroContrato()) && bd.getNumeroContrato().endsWith("V")) {
            contrato.setDescripcion("Virtual");
        } else {
            contrato.setDescripcion(bd.getConcepto());
        }
        contrato.setNumeroContrato(bd.getNumeroContrato());
        contrato.setFechaInicio(bd.getFechaInicio());
        contrato.setFechaFin(bd.getFechaFin());
        contrato.setEstatus(bd.getEstatus());
        contrato.setIdContrato(bd.getIdContrato());
        contrato.setHijos(new ArrayList());
        if (tipo == 0) {
            contrato.setEncabezadoTitulo(Boolean.valueOf(true));
            boolean colap = bd.getColapsable() == 1;
            contrato.setColapsable(Boolean.valueOf(colap));
        }
        ArrayList documentos = bd.getNumDocumentos() > 0 && tipo != 0 ? new ArrayList() : null;
        contrato.setDocumentos(documentos);
        return contrato;
    }

    public DocumentoDTO getDocumento(Long idContratoDocto) {
        return this.documentoDAO.buscarDocumento(idContratoDocto);
    }

    public List<ContratoListaDTO> getDocumentos(Long id) {
        ArrayList<ContratoListaDTO> obj = new ArrayList<ContratoListaDTO>();
        ContratoListaDTO cto = new ContratoListaDTO();
        cto.setDocumentos(this.documentoDAO.buscarDocumentos(id));
        obj.add(cto);
        return obj;
    }

    public Long crearAdendum(Map<String, Object> params) {
        this.listadoDAO.crearAdendum(params);
        Integer id = (Integer)params.get("idContratoNuevo");
        String idS = String.valueOf(id);
        Long idL = Long.parseLong(idS);
        return idL;
    }

    public Long crearEmnienda(Map<String, Object> params) {
        this.listadoDAO.crearEmnienda(params);
        Integer id = (Integer)params.get("idNuevo");
        String idS = String.valueOf(id);
        Long idL = Long.parseLong(idS);
        return idL;
    }

    public static <T> List<T> safeList(List<T> other) {
        return other == null ? Collections.EMPTY_LIST : other;
    }
}

