/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.titulo.bos;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.catalogos.dtos.CatalogoDTO;
import com.mx.dla.dda.contrato.common.bos.CommonRestBO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.enums.Movimiento;
import com.mx.dla.dda.contrato.titulo.bos.TitulosBussinesBO;
import com.mx.dla.dda.contrato.titulo.bos.TitulosUtilBO;
import com.mx.dla.dda.contrato.titulo.constants.TipoCambioTitulo;
import com.mx.dla.dda.contrato.titulo.daos.ListaDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Lista;
import com.mx.dla.dda.contrato.titulo.dtos.SapNum;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.dda.contrato.titulo.rules.TituloRules;
import com.mx.dla.global.bos.BaseBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloGridBO
extends BaseBO {
    @Autowired
    private TituloDmDAO tituloDmDAO;
    @Autowired
    protected TituloDAO tituloDAO;
    @Autowired
    protected ListaDAO listaDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected GeneralesDAO generalesDAO;
    @Autowired
    protected CommonRestBO commonRestBO;
    @Autowired
    protected TituloRules tituloRules;
    @Autowired
    protected TitulosBussinesBO titulosBussinesBO;
    @Autowired
    private TitulosUtilBO titulosUtilBO;

    public String alta(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.info("Alta. Titulo [{}]", (Object)t);
        String serie = null;
        if (this.tituloRules.verificarSerieNueva(t)) {
            serie = "El sistema generar\u00e1 autom\u00e1ticamente" + t.getEpisodio() + " los episodios de " + t.getDescTitulo();
        } else {
            this.guardaTitulo(c, l, t);
            this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
        }
        return serie;
    }

    public void altaSeriesAuto(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.info("Alta Serie. Titulo [{}]", (Object)t);
        int numEpisodios = Integer.parseInt(t.getEpisodio());
        String nombre = t.getDescTitulo() + ": Episodio # ";
        for (int i = 1; i <= numEpisodios; ++i) {
            String name = nombre + i;
            this.guardaTitulo(c, l, this.titulosUtilBO.getTituloSerieAuto(t, name, String.valueOf(i)));
        }
        this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
    }

    public Titulo guardaTitulo(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        t.setIdLista(l.getIdLista());
        this.tituloRules.validaEntrada(t, this.titulosBussinesBO.calculaFechasInicioFinValidacion(c));
        t = this.titulosUtilBO.getTituloGuardar(t, c);
        this.tituloDmDAO.insertarTitulo(t);
        return t;
    }

    public void cambio(ContratoDTO c, Lista l, Titulo t) throws TituloException {
        this.logger.info("Cambio. Titulo [{}]", (Object)t);
        this.tituloRules.validaEntrada(t, this.titulosBussinesBO.calculaFechasInicioFinValidacion(c));
        Titulo bd = this.tituloDmDAO.buscarTitulo(t.getIdTituloCnt());
        t = this.titulosUtilBO.copiarTitulo(t, bd);
        this.tituloDmDAO.actualizarTitulo(t);
        this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
    }

    public void cambioMultiple(ContratoDTO c, Lista l, Titulo titulo, String tipoCambio, List<Long> idsTitulos) throws TituloException {
        titulo.setIdLista(l.getIdLista());
        if (TipoCambioTitulo.VENTANA.name().equals(tipoCambio)) {
            titulo.setVidaUtil(this.titulosUtilBO.calcularVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
            titulo.setMesesvu(this.titulosUtilBO.calculaMesesVidaUtil(titulo.getFechaInicio(), titulo.getFechaFin()));
            for (Long id : idsTitulos) {
                titulo.setIdTituloCnt(id);
                this.tituloDmDAO.actualizarTituloCambio(titulo);
            }
        }
        if (Movimiento.Adendum.getValor().longValue() == c.getIdTipoMovimiento().longValue() || Movimiento.Original.getValor().longValue() == c.getIdTipoMovimiento().longValue()) {
            if (TipoCambioTitulo.CATEGORIA.name().equals(tipoCambio)) {
                CatalogoDTO cat = null;
                if (titulo.getPagoCateg() != null) {
                    cat = this.catalogosDAO.buscarCategoriaPagoPorDesc(c.getIdContrato(), titulo.getPagoCateg().getDesc());
                }
                titulo.setPagoCateg(cat);
                titulo.setPrecioAnual(null);
                for (Long id : idsTitulos) {
                    titulo.setIdTituloCnt(id);
                    this.tituloDmDAO.actualizarTituloCambio(titulo);
                }
            }
            this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
        } else if (Movimiento.Enmienda.getValor().longValue() == c.getIdTipoMovimiento().longValue()) {
            titulo.setIdTituloCnt(idsTitulos.get(0));
            if (TipoCambioTitulo.TRASLADAR.name().equals(tipoCambio)) {
                this.tituloRules.validaEntrada(titulo, this.titulosBussinesBO.calculaFechasInicioFinValidacion(c));
            }
            this.titulosBussinesBO.verificarEnmiendaActualizacion(titulo, tipoCambio, c);
            this.titulosBussinesBO.actualizaCostoTodosLosTitulos(c);
            this.titulosBussinesBO.actualizarBanderasTraslados(c.getIdContrato());
        }
    }

    public void baja(ContratoDTO c, Titulo t) {
        this.logger.debug("baja. Titulo [{}]", (Object)t);
        Titulo tbd = this.tituloDmDAO.buscarTitulo(t.getIdTituloCnt());
        if (tbd.getIdSap() == null) {
            this.tituloDmDAO.borrarTitulo(t.getIdTituloCnt());
        } else {
            tbd.setEstatus("ELIMINADO");
            tbd.setFechaContabilizacion(t.getFechaContabilizacion());
            if (tbd.getFechaNotifsap() != null) {
                tbd.setBajaPerdida(t.getBajaPerdida());
            } else {
                tbd.setBajaPerdida(Long.valueOf(0L));
            }
            this.tituloDmDAO.actualizarTitulo(tbd);
        }
    }

    public List<Titulo> busqueda(Titulo t, boolean calculaAmortizacion, String prefix) throws TituloException {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        titulos.addAll(this.tituloDmDAO.buscaTotalesLista(t.getIdLista(), prefix));
        titulos.addAll(this.tituloDmDAO.buscaDetallePeliculas(t.getIdLista(), prefix));
        this.logger.debug(((Object)titulos).toString());
        List nombresUnicos = this.tituloDmDAO.buscaSerie1Capitulo(t.getIdLista(), prefix);
        List series = this.tituloDmDAO.buscaTotalesSerie(t.getIdLista(), t.getNombreUnico(), prefix);
        block0: for (Titulo s : nombresUnicos) {
            int i = 0;
            for (Titulo tt : series) {
                if (tt.getNombreUnico().equals(s.getNombreUnico())) {
                    series.remove(i);
                    continue block0;
                }
                ++i;
            }
        }
        titulos.addAll(nombresUnicos);
        titulos.addAll(series);
        if (calculaAmortizacion) {
            for (Titulo tam : titulos) {
                HashMap<String, String> h = new HashMap<String, String>();
                if (tam.getAmortizaciones() != null) {
                    for (CatalogoDTO cat : tam.getAmortizaciones()) {
                        h.put(cat.getValue(), cat.getDesc());
                    }
                }
                tam.setAmortizacionesH(h);
            }
        }
        return titulos;
    }

    public List<Titulo> busquedaDetalle(Titulo t, boolean calcularAmort, String prefix) throws TituloException {
        ArrayList<Titulo> titulos = new ArrayList<Titulo>();
        this.logger.info("t :{}", (Object)t);
        this.logger.info("calcularAmort :{}", (Object)calcularAmort);
        this.logger.info("prefix :{}", (Object)prefix);
        this.logger.info("buscaTotalesSerie :{}", (Object)this.tituloDmDAO.buscaTotalesSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        this.logger.info("buscaDetalleSerie :{}", (Object)this.tituloDmDAO.buscaDetalleSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        titulos.addAll(this.tituloDmDAO.buscaTotalesSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        titulos.addAll(this.tituloDmDAO.buscaDetalleSerie(t.getIdLista(), t.getNombreUnico(), prefix));
        ((Titulo)titulos.get(0)).setAgrupable(Integer.valueOf(0));
        if (calcularAmort) {
            for (Titulo tam : titulos) {
                HashMap<String, String> h = new HashMap<String, String>();
                if (tam.getAmortizaciones() != null) {
                    for (CatalogoDTO cat : tam.getAmortizaciones()) {
                        h.put(cat.getValue(), cat.getDesc());
                    }
                }
                tam.setAmortizacionesH(h);
            }
        }
        this.logger.info("titulos :{}", titulos);
        return titulos;
    }

    public List<SapNum> getAumentosSapNumXTitulo(Long IdTituloCnt, Long idCto) {
        return this.tituloDmDAO.getAumentosSapNumXTitulo(IdTituloCnt, idCto);
    }
}

