/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.titulo.rules;

import com.mx.dla.dda.catalogos.daos.CatalogosDAO;
import com.mx.dla.dda.contrato.generales.daos.GeneralesDAO;
import com.mx.dla.dda.contrato.generales.dtos.ContratoDTO;
import com.mx.dla.dda.contrato.generales.dtos.FechasDTO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDAO;
import com.mx.dla.dda.contrato.titulo.daos.TituloDmDAO;
import com.mx.dla.dda.contrato.titulo.dtos.Titulo;
import com.mx.dla.dda.contrato.titulo.exception.TituloException;
import com.mx.dla.global.bos.BaseBO;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.beanutils.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TituloRules
extends BaseBO {
    @Autowired
    private TituloDmDAO tituloDmDAO;
    @Autowired
    protected TituloDAO tituloDAO;
    @Autowired
    protected CatalogosDAO catalogosDAO;
    @Autowired
    protected GeneralesDAO generalesDAO;

    public void validaEntrada(Titulo titulo, ContratoDTO contrato) throws TituloException {
        this.validaTituloDuplicado(titulo.getIdTituloCnt(), titulo.getIdLista(), titulo);
        ContratoDTO contratoValidacion = this.calculaFechasInicioFinValidacion(contrato);
        if (titulo.getPrecioAnual() == null || "".equals(titulo.getPrecioAnual())) {
            if (titulo.getPagoCateg() == null) {
                throw new TituloException("El t\u00edtulo debe tener Precio o Categor\u00eda");
            }
            if (titulo.getPagoCateg() != null && titulo.getPagoCateg().getValue() == null) {
                throw new TituloException("El t\u00edtulo debe tener Precio o Categor\u00eda");
            }
        }
        if (titulo.getPrecioAnual() != null && !"".equals(titulo.getPrecioAnual()) && titulo.getPagoCateg() != null && titulo.getPagoCateg().getValue() != null) {
            throw new TituloException("El t\u00edtulo no debe tener Precio y Categor\u00eda");
        }
        if (titulo.getFechaInicio() != null && titulo.getFechaFin() != null && titulo.getFechaFin().before(titulo.getFechaInicio())) {
            throw new TituloException("Fecha fin no puede ser anterior a Fecha inicio");
        }
        if (titulo.getFechaInicio() != null && (contratoValidacion.getFechaInicio().after(titulo.getFechaInicio()) || contratoValidacion.getFechaFin().before(titulo.getFechaInicio()))) {
            throw new TituloException("Fecha de exhibici\u00f3n fuera de rango");
        }
        if (titulo.getNombreUnico() == null) {
            throw new TituloException("El t\u00edtulo no cuenta con nombre \u00fanico");
        }
        if (titulo.getIdBv() != null) {
            this.cuentaOcurrenciasEnOtrosContratos(titulo, contrato);
        }
    }

    public void cuentaOcurrenciasEnOtrosContratos(Titulo t, ContratoDTO contrato) throws TituloException {
        this.logger.info("IBV {}", (Object)t.getIdBv());
        Long ocurrences = this.tituloDAO.buscarTitulosOtrosContratosXBV(t.getFechaInicio(), t.getFechaFin(), t.getIdBv(), t.getIdLista());
        if (ocurrences != null && ocurrences != 0L) {
            throw new TituloException("El t\u00edtulo ya se encuentra en otro contrato en el mismo id BroadView");
        }
        this.logger.info("ocurrencias {}", (Object)ocurrences);
        ocurrences = 0L;
        ocurrences = this.tituloDAO.buscarTitulosListaXBV(t.getFechaInicio(), t.getFechaFin(), t.getIdBv(), t.getIdLista(), t.getIdTituloCnt());
        if (ocurrences != null && ocurrences != 0L) {
            throw new TituloException("El t\u00edtulo ya se encuentra en la misma lista con el mismo id BroadView");
        }
        this.logger.info("ocurrencias {}", (Object)ocurrences);
    }

    protected void validaTituloDuplicado(Long idTitulo, Long idLista, Titulo titulo) throws TituloException {
        Titulo t = null;
        this.logger.debug("valido L:[{}] D:[{}] T:[{}] E:[{}]", new Object[]{idLista, titulo.getDescTitulo(), titulo.getTemporada(), titulo.getEpisodio()});
        try {
            t = this.tituloDmDAO.buscarTitulosPorDescripcionEnLista(idLista, titulo.getDescTitulo(), titulo.getTemporada(), titulo.getEpisodio());
        }
        catch (Exception e) {
            this.logger.debug("Error", (Throwable)e);
            throw new TituloException("El t\u00edtulo ya se encuentra en la lista");
        }
        if (t != null && idTitulo == null) {
            throw new TituloException("El t\u00edtulo ya se encuentra en la lista");
        }
        if (t != null && Long.compare(t.getIdTituloCnt(), idTitulo) != 0) {
            throw new TituloException("El t\u00edtulo ya se encuentra en la lista");
        }
    }

    protected ContratoDTO calculaFechasInicioFinValidacion(ContratoDTO contrato) {
        ContratoDTO cv = null;
        try {
            cv = (ContratoDTO)BeanUtils.cloneBean((Object)contrato);
            FechasDTO fechas = this.generalesDAO.obtenerFechasMaximaMinimaDeContratosPorContratoOriginal(contrato.getIdContratoOriginal());
            cv.setFechaInicio(fechas.getInicio());
            cv.setFechaFin(fechas.getFin());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.error("Error ", (Throwable)e);
        }
        return cv;
    }

    public boolean verificarSerieNueva(Titulo titulo) {
        boolean valido = true;
        if (this.tituloDAO.findCategoria(Long.valueOf(Long.parseLong(titulo.getCategoriaTit().getValue()))) != 1) {
            valido = false;
        }
        this.logger.debug("serie categoria {}", (Object)valido);
        if (valido && (!TituloRules.isNumeric(titulo.getEpisodio()) || Integer.parseInt(titulo.getEpisodio()) < 1)) {
            valido = false;
        }
        this.logger.debug("serie episodio {}", (Object)valido);
        if (valido && this.tituloDAO.findSerieSeason(titulo.getNombreUnico(), titulo.getTemporada()) > 1) {
            valido = false;
        }
        this.logger.debug("serie existe {}", (Object)valido);
        return valido;
    }

    private static boolean isNumeric(String cadena) {
        try {
            Integer.parseInt(cadena);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }
}

