/*
 * Decompiled with CFR 0.152.
 */
package com.mx.dla.dda.contrato.transaccion.fees.bos;

import com.mx.dla.dda.contrato.fees.daos.FeesContratoDAO;
import com.mx.dla.dda.contrato.transaccion.catalagos.dtos.TipoCambioTDTO;
import com.mx.dla.dda.contrato.transaccion.exceptions.dtos.TransaccionException;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesEstTransaccioBO;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesLibreriaTransaccioBO;
import com.mx.dla.dda.contrato.transaccion.fees.bos.FeesPremierTransaccioBO;
import com.mx.dla.dda.contrato.transaccion.fees.daos.FeesTransaccionDAO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesEstDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesLibreriaDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesPremierDTO;
import com.mx.dla.dda.contrato.transaccion.fees.dtos.FeesTransaccionDTO;
import com.mx.dla.dda.excelMapper.bos.ExcelMapperTransform;
import com.mx.dla.dda.excelMapper.constants.ExcelMapperDataType;
import com.mx.dla.dda.excelMapper.dtos.ExcelEntityResult;
import com.mx.dla.dda.excelMapper.dtos.ExcelMapper;
import com.mx.dla.dda.excelMapper.dtos.ExcelRule;
import com.mx.dla.dda.excelMapper.exceptions.ExcelMapperException;
import com.mx.dla.global.bos.BaseBO;
import com.mx.dla.global.dtos.FilaExcelDTO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FeesTransaccioBO
extends BaseBO {
    @Autowired
    private FeesPremierTransaccioBO premier;
    @Autowired
    private FeesLibreriaTransaccioBO feesLib;
    @Autowired
    private FeesEstTransaccioBO feesEst;
    @Autowired
    private FeesContratoDAO feesContratoDAO;
    @Autowired
    private FeesTransaccionDAO feesTDAO;
    @Autowired
    private ExcelMapperTransform excelTransform;
    @Value(value="${uri.file.carga.fees}")
    protected String uriCarga;
    private String fechaInicio;
    private String fechaFin;
    private String nombreArchivo;

    public FeesTransaccionDTO obtenerFees(Long idContrato) {
        FeesTransaccionDTO fees = new FeesTransaccionDTO();
        this.fechaInicio = this.feesContratoDAO.fechaInicio(idContrato);
        this.fechaFin = this.feesContratoDAO.fechaFin(idContrato);
        fees.setFechaInicioCto(this.fechaInicio);
        fees.setFechaFinCto(this.fechaFin);
        fees = this.obtenerTiposCambio(fees);
        Long tipo = 0L;
        fees.setIdTipoCambio(Long.valueOf(tipo));
        return fees;
    }

    private FeesTransaccionDTO obtenerTiposCambio(FeesTransaccionDTO fees) {
        ArrayList<TipoCambioTDTO> tipos = new ArrayList<TipoCambioTDTO>();
        TipoCambioTDTO t = new TipoCambioTDTO();
        t.setId(Long.valueOf(0L));
        t.setDesc("Selecciona Valor");
        tipos.add(t);
        tipos.addAll(this.feesTDAO.getTipoCambio());
        fees.setTiposCambio(tipos);
        return fees;
    }

    private FeesTransaccionDTO establecerSeccion(FeesTransaccionDTO fees, Long idContrato) {
        List seccionCat = this.feesTDAO.obtenerSeccionMinimos(idContrato);
        List seccionAni = this.feesTDAO.obtenerSeccionAnio(idContrato);
        if (seccionCat != null && seccionAni != null) {
            seccionCat.addAll(seccionAni);
        } else if (seccionCat == null && seccionAni != null) {
            seccionCat = seccionAni;
        }
        if (seccionCat == null || seccionCat.isEmpty()) {
            fees.setPremier(true);
        } else if (this.obtenerValor("RP", seccionCat)) {
            fees.setPremier(true);
        } else if (this.obtenerValor("RL", seccionCat)) {
            fees.setLibreria(true);
        } else if (this.obtenerValor("VT", seccionCat)) {
            fees.setEst(true);
        }
        return fees;
    }

    private boolean obtenerValor(String seccion, List<String> secciones) {
        boolean encontrado = false;
        for (String str : secciones) {
            if (str.compareTo(seccion) != 0) continue;
            encontrado = true;
        }
        return encontrado;
    }

    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={Exception.class})
    public void guardarFees(String tipo, Long idContrato, Long idTipoCambio, FeesPremierDTO feesPremierDTO, FeesLibreriaDTO feesLibreriaDTO, FeesEstDTO feesEstDTO) throws TransaccionException {
        try {
            if (idTipoCambio != null) {
                this.feesTDAO.eliminarTipoCambio(idContrato);
                this.feesTDAO.guardarTipoCambio(idContrato, idTipoCambio);
            }
            if (tipo.compareTo("Premier") == 0) {
                this.logger.debug(feesPremierDTO.toString());
                this.premier.guardarFeesTransaccion(idContrato, null, null, feesPremierDTO);
            } else if (tipo.compareTo("Libreria") == 0) {
                this.logger.debug(feesLibreriaDTO.toString());
                this.feesLib.guardarFeesLibreria(idContrato, null, null, feesLibreriaDTO);
            } else if (tipo.compareTo("Est") == 0) {
                this.logger.debug(this.feesEst.toString());
                this.feesEst.guardarFeesEst(idContrato, null, null, feesEstDTO);
            }
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }

    public FeesPremierDTO obtenerPremierFees(Long idContrato) throws TransaccionException {
        this.fechaInicio = this.feesContratoDAO.fechaInicio(idContrato);
        this.fechaFin = this.feesContratoDAO.fechaFin(idContrato);
        return this.premier.obtenerFeesTransaccion(idContrato, this.fechaInicio, this.fechaFin);
    }

    public FeesLibreriaDTO obtenerLibreriaFees(Long idContrato) throws TransaccionException {
        this.fechaInicio = this.feesContratoDAO.fechaInicio(idContrato);
        this.fechaFin = this.feesContratoDAO.fechaFin(idContrato);
        return this.feesLib.obtenerFeesLibreria(idContrato, this.fechaInicio, this.fechaFin);
    }

    public FeesEstDTO obtenerEstFees(Long idContrato) throws TransaccionException {
        this.fechaInicio = this.feesContratoDAO.fechaInicio(idContrato);
        this.fechaFin = this.feesContratoDAO.fechaFin(idContrato);
        return this.feesEst.obtenerFeesEst(idContrato, this.fechaInicio, this.fechaFin);
    }

    public boolean verificarCategoria(Long id) throws TransaccionException {
        try {
            return true;
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al guardar los datos.", e);
        }
    }

    public byte[] descargarArchivoExcel(String seccion, String operacion, List<List<String>> datos, List<String> encabezados) throws TransaccionException {
        byte[] archivo = null;
        try {
            if (seccion.compareTo("premier") == 0) {
                switch (operacion) {
                    case "min_cat": {
                        this.nombreArchivo = "templateFees/dda_premierMGC_";
                        break;
                    }
                    case "min_anio": {
                        this.nombreArchivo = "templateFees/dda_premierMGA_";
                        break;
                    }
                    case "release": {
                        this.nombreArchivo = "templateFees/dda_premierRD_";
                        break;
                    }
                    case "precio": {
                        this.nombreArchivo = "templateFees/dda_premierPPE_";
                    }
                }
                archivo = datos == null ? this.getFile(this.nombreArchivo + ".xlsx") : this.excelTransform.transformMapToExcel2(datos, encabezados);
            } else if (seccion.compareTo("libreria") == 0) {
                switch (operacion) {
                    case "min_cat": {
                        this.nombreArchivo = "templateFees/dda_libreriaMG_";
                        break;
                    }
                    case "min_anio": {
                        this.nombreArchivo = "templateFees/dda_libreriaMGA_";
                        break;
                    }
                    case "precio": {
                        this.nombreArchivo = "templateFees/dda_libreriaPPE_";
                    }
                }
                archivo = datos == null ? this.getFile(this.nombreArchivo + ".xlsx") : this.excelTransform.transformMapToExcel2(datos, encabezados);
            } else if (seccion.compareTo("est") == 0) {
                switch (operacion) {
                    case "min_cat": {
                        this.nombreArchivo = "templateFees/dda_ventaMG_";
                        break;
                    }
                    case "min_anio": {
                        this.nombreArchivo = "templateFees/dda_ventaMGA_";
                        break;
                    }
                    case "precio movies": {
                        this.nombreArchivo = "templateFees/dda_ventaMoviesPPE_";
                        break;
                    }
                    case "precio series": {
                        this.nombreArchivo = "templateFees/dda_ventaSeriesPPE_";
                    }
                }
                archivo = datos == null ? this.getFile(this.nombreArchivo + ".xlsx") : this.excelTransform.transformMapToExcel2(datos, encabezados);
            }
            return archivo;
        }
        catch (Exception e) {
            throw new TransaccionException("Se genero un error al descargar el arhivo.", e);
        }
    }

    private byte[] getFile(String fileName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(fileName);
        byte[] byteArr = IOUtils.toByteArray((InputStream)stream);
        return byteArr;
    }

    public List<FilaExcelDTO> obtenerDatosExcel(File fileUpload, String fileName, String expediente, Long idContrato) throws IOException, ExcelMapperException {
        String nombreArchivo = this.uriCarga + idContrato + expediente + fileName;
        byte[] f = FileUtils.readFileToByteArray((File)fileUpload);
        File d = new File(nombreArchivo);
        d.setExecutable(true, false);
        d.setReadable(true, false);
        d.setWritable(true, false);
        this.logger.debug("Absolute path [{}]  -  [{}]", (Object)d.getCanonicalPath(), (Object)d.getPath());
        FileUtils.writeByteArrayToFile((File)d, (byte[])f);
        List<FilaExcelDTO> datos = this.obtenerDatosExcel(nombreArchivo);
        FileUtils.deleteQuietly((File)d);
        this.logger.debug(datos.toString());
        return datos;
    }

    public List<FilaExcelDTO> obtenerDatosExcel(String nombreArchivo) throws ExcelMapperException {
        ArrayList<FilaExcelDTO> datos = new ArrayList<FilaExcelDTO>();
        ExcelMapper mapper = new ExcelMapper();
        mapper.setClassName("com.mx.dla.global.dtos.FilaExcelDTO");
        mapper.setFirstRow(1);
        ArrayList<ExcelRule> rules = new ArrayList<ExcelRule>();
        ExcelRule er = new ExcelRule();
        er.setType(ExcelMapperDataType.string);
        er.setAttribute("fila");
        rules.add(er);
        mapper.setRules(rules);
        ExcelEntityResult res = this.excelTransform.readExcelToObject(nombreArchivo, mapper);
        for (int i = 0; i < res.getResult().size(); ++i) {
            FilaExcelDTO fila = (FilaExcelDTO)res.getResult().get(i);
            datos.add(fila);
        }
        return datos;
    }

    public String getNombreArchivo() {
        return this.nombreArchivo;
    }
}

